/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.verapdf.as.io.ASFileInStream;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.io.SeekableInputStream;
import org.verapdf.tools.IntReference;

public class InternalInputStream
extends SeekableInputStream {
    private static final String READ_ONLY_MODE = "r";
    private boolean isTempFile;
    private IntReference numOfFileUsers;
    private String fileName;
    private RandomAccessFile source;

    public InternalInputStream(File file) throws FileNotFoundException {
        this(file, 1);
    }

    public InternalInputStream(File file, boolean isTempFile) throws FileNotFoundException {
        this(file);
        this.isTempFile = isTempFile;
    }

    public InternalInputStream(File file, int numOfFileUsers) throws FileNotFoundException {
        this.isTempFile = false;
        this.fileName = file.getAbsolutePath();
        this.source = new RandomAccessFile(file, READ_ONLY_MODE);
        this.numOfFileUsers = new IntReference(numOfFileUsers);
    }

    public InternalInputStream(String fileName) throws FileNotFoundException {
        this(fileName, 1);
    }

    public InternalInputStream(String fileName, int numOfFileUsers) throws FileNotFoundException {
        this.isTempFile = false;
        this.fileName = fileName;
        this.source = new RandomAccessFile(fileName, READ_ONLY_MODE);
        this.numOfFileUsers = new IntReference(numOfFileUsers);
    }

    public InternalInputStream(InputStream fileStream) throws IOException {
        this.isTempFile = true;
        File tempFile = this.createTempFile(fileStream);
        this.fileName = tempFile.getAbsolutePath();
        this.source = new RandomAccessFile(tempFile, READ_ONLY_MODE);
    }

    public InternalInputStream(byte[] alreadyRead, InputStream stream) throws IOException {
        this.isTempFile = true;
        File temp = this.createTempFile(alreadyRead, stream);
        this.fileName = temp.getAbsolutePath();
        this.source = new RandomAccessFile(temp, READ_ONLY_MODE);
        this.numOfFileUsers = new IntReference(1);
    }

    @Override
    public int read() throws IOException {
        this.checkClosed("Reading");
        return this.source.read();
    }

    @Override
    public int read(byte[] buffer, int size) throws IOException {
        this.checkClosed("Reading");
        return this.source.read(buffer, 0, size);
    }

    @Override
    public int skip(int size) throws IOException {
        this.checkClosed("Skipping");
        return this.source.skipBytes(size);
    }

    @Override
    public void closeResource() throws IOException {
        if (!this.isSourceClosed) {
            this.isSourceClosed = true;
            this.numOfFileUsers.decrement();
            if (this.numOfFileUsers.equals(0)) {
                this.source.close();
                if (this.isTempFile) {
                    File tmp = new File(this.fileName);
                    tmp.delete();
                }
            }
        }
    }

    @Override
    public void reset() throws IOException {
        this.source.seek(0L);
    }

    public boolean isCloneable() {
        return false;
    }

    @Override
    public long getOffset() throws IOException {
        this.checkClosed("Offset obtaining");
        return this.source.getFilePointer();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.checkClosed("Seeking");
        this.source.seek(pos);
    }

    @Override
    public int peek() throws IOException {
        this.checkClosed("Peeking");
        if (!this.isEOF()) {
            byte result = this.source.readByte();
            this.unread();
            return result;
        }
        return -1;
    }

    @Override
    public long getStreamLength() throws IOException {
        this.checkClosed("Stream length obtaining");
        return this.source.length();
    }

    public String getFileName() {
        return this.fileName;
    }

    public RandomAccessFile getStream() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createTempFile(InputStream input) throws IOException {
        try (FileOutputStream output = null;){
            int n;
            File tmpFile = File.createTempFile("tmp_pdf_file", ".pdf");
            tmpFile.deleteOnExit();
            output = new FileOutputStream(tmpFile);
            byte[] buffer = new byte[4096];
            while ((n = input.read(buffer, 0, 2048)) != -1) {
                output.write(buffer, 0, n);
            }
            File file = tmpFile;
            return file;
        }
    }

    private File createTempFile(byte[] alreadyRead, InputStream input) throws IOException {
        FileOutputStream output = null;
        File tmpFile = File.createTempFile("tmp_pdf_file", ".pdf");
        tmpFile.deleteOnExit();
        try {
            int n;
            output = new FileOutputStream(tmpFile);
            output.write(alreadyRead);
            byte[] buffer = new byte[2048];
            while ((n = input.read(buffer, 0, 2048)) != -1) {
                output.write(buffer, 0, n);
            }
            File file = tmpFile;
            return file;
        }
        catch (IOException e) {
            tmpFile.delete();
            throw e;
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    @Override
    public ASInputStream getStream(long startOffset, long length) {
        return new ASFileInStream(this.source, startOffset, length, this.numOfFileUsers, this.fileName, this.isTempFile);
    }

    private void checkClosed(String streamUsage) throws IOException {
        if (this.isSourceClosed) {
            throw new IOException(streamUsage + " can't be performed; stream is closed");
        }
    }

    public boolean isSourceClosed() {
        return this.isSourceClosed;
    }
}

