/**
 * This file is part of veraPDF Validation Model API, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation Model API is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation Model API as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation Model API as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.alayer;
		
import org.verapdf.model.baselayer.Object;

		
/**
*/
public interface AEncryptionPublicKey extends AObject {
	



	/**
	*/
	public Boolean getcontainsCF();

	/**
	*/
	public String getCFType();

	/**
	*/
	public Boolean getCFHasTypeDictionary();

	/**
	*/
	public Boolean getcontainsEFF();

	/**
	*/
	public String getEFFType();

	/**
	*/
	public Boolean getEFFHasTypeName();

	/**
	*/
	public String getEFFNameValue();

	/**
	*/
	public Boolean getcontainsEncryptMetadata();

	/**
	*/
	public String getEncryptMetadataType();

	/**
	*/
	public Boolean getEncryptMetadataHasTypeBoolean();

	/**
	*/
	public Boolean getcontainsFilter();

	/**
	*/
	public String getFilterType();

	/**
	*/
	public Boolean getFilterHasTypeName();

	/**
	*/
	public String getFilterNameValue();

	/**
	*/
	public Boolean getcontainsKDFSalt();

	/**
	*/
	public Boolean getisKDFSaltIndirect();

	/**
	*/
	public String getKDFSaltType();

	/**
	*/
	public Boolean getKDFSaltHasTypeStringByte();

	/**
	*/
	public Boolean getcontainsLength();

	/**
	*/
	public String getLengthType();

	/**
	*/
	public Boolean getLengthHasTypeInteger();

	/**
	*/
	public Long getLengthIntegerValue();

	/**
	*/
	public Boolean getcontainsP();

	/**
	*/
	public String getPType();

	/**
	*/
	public Boolean getPHasTypeBitmask();

	/**
	*/
	public Long getPBitmaskValue();

	/**
	*/
	public Boolean getcontainsRecipients();

	/**
	*/
	public String getRecipientsType();

	/**
	*/
	public Boolean getRecipientsHasTypeArray();

	/**
	*/
	public Boolean getcontainsStmF();

	/**
	*/
	public String getStmFType();

	/**
	*/
	public Boolean getStmFHasTypeName();

	/**
	*/
	public String getStmFNameValue();

	/**
	*/
	public Boolean getcontainsStrF();

	/**
	*/
	public String getStrFType();

	/**
	*/
	public Boolean getStrFHasTypeName();

	/**
	*/
	public String getStrFNameValue();

	/**
	*/
	public Boolean getcontainsSubFilter();

	/**
	*/
	public String getSubFilterType();

	/**
	*/
	public Boolean getSubFilterHasTypeName();

	/**
	*/
	public String getSubFilterNameValue();

	/**
	*/
	public Boolean getcontainsV();

	/**
	*/
	public String getVType();

	/**
	*/
	public Boolean getVHasTypeInteger();

	/**
	*/
	public Long getVIntegerValue();

	/**
	*/
	public Boolean gethasExtensionADBE_Extn3();

	/**
	*/
	public Boolean gethasExtensionISO_TS_32004();
}
