/**
 * This file is part of veraPDF Validation Model API, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation Model API is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation Model API as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation Model API as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.salayer;
		
import org.verapdf.model.baselayer.Object;
import java.util.List;

		
/**
* text chunk
*/
public interface SATextChunk extends SAChunk {
	

	/**
	* text size
	*/
	public Double gettextSize();

	/**
	* contrast ratio
	*/
	public Double getcontrastRatio();

	/**
	* text weight
	*/
	public Double gettextWeight();

	/**
	* true, if this text chunk has style different from common style
	*/
	public Boolean gethasSpecialStyle();

	/**
	* true, if this text chunk has background different from common background
	*/
	public Boolean gethasSpecialBackground();

	/**
	* true, if this text chunk is underlined
	*/
	public Boolean getisUnderlined();

	/**
	* ampersand separated list of all parent elements standard types of this text chunk in the structure hierarchy
	*/
	public String getparentsStandardTypes();

	/**
	* true, if this text chunk consists of white spaces
	*/
	public Boolean getisWhiteSpaceChunk();
}
