package org.verapdf.model.external;
		
import org.verapdf.model.baselayer.Object;
import java.util.List;

		
/**  Embedded ICC profile
 */
public interface ICCProfile extends External {
	

	/**  value of the N key in the ICC profile stream dictionary
	 */
	public Long getN();

	/**  a four-byte string identifying the device class of the profile (monitor, printer, scanner, abstract color space)
	 */
	public String getdeviceClass();

	/**  a four-byte string identifying the device class of the profile (GRAY, RGB, CMYK, LAB)
	 */
	public String getcolorSpace();

	/**  version of the ICC profile
	 */
	public Double getversion();

	/**  true if the profile satisfies the corresponding ICC Specification
	 */
	public Boolean getisValid();
}
