/**
 * This file is part of veraPDF Validation Model API, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation Model API is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation Model API as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation Model API as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.coslayer;
		
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.pdlayer.PDMetadata;
import org.verapdf.model.pdlayer.PDDocument;
import org.verapdf.model.pdlayer.PDEncryption;
import org.verapdf.model.external.EmbeddedFile;

		
/**  Low-level PDF Document object 
 */
public interface CosDocument extends CosObject {
	

	/**  number of indirect objects in the document
	 */
	public Long getnrIndirects();

	/**  version of the document
	 */
	public Double getheaderVersion();

	/**  true if the OCProperties key is present in the document Catalog
	 */
	public Boolean getisOptionalContentPresent();

	/**  size of data after the EOF and (optional) end of line marker
	 */
	public Long getpostEOFDataSize();

	/**  true if Info dictionary is present and synchronized with the document metadata
	 */
	public Boolean getdoesInfoMatchXMP();

	/**  id of the first page trailer, if the document is linearized. Null, if the document is not linearized
	 */
	public String getfirstPageID();

	/**  id of the last trailer in the document
	 */
	public String getlastID();

	/**  true if the document is linearized
	 */
	public Boolean getisLinearized();





	/**  offset of the PDF document header
	 */
	public Long getheaderOffset();

	/**  the content of the PDF header
	 */
	public String getheader();

	/**  first four bytes in the comment that follows the PDF header
	 */
	public Long getheaderByte1();

	public Long getheaderByte2();

	public Long getheaderByte3();

	public Long getheaderByte4();


	/**  the value of the /Marked entry in the MarkInfo dictionary (false, if this entry is missing)
	 */
	public Boolean getMarked();

	/**  - null, if the /Requirements key is not present in the document Catalog 
	 */
	public String getRequirements();

	/**  NeedsRendering entry in the document's Catalog (false by default)
	 */
	public Boolean getNeedsRendering();

	/**  true, if the document contains the EmbeddedFiles entry in the names dictionary
	 */
	public Boolean getcontainsEmbeddedFiles();

	/**  value of the /Suspects entry in the MarkInfo dictionary
	 */
	public Boolean getSuspects();

	/**  value of the /DisplayDocTitle key in the ViewerPreferences dictionary
	 */
	public Boolean getDisplayDocTitle();
}
