/**
 * This file is part of veraPDF Validation Model API, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation Model API is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation Model API as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation Model API as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.pdlayer;
		
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosObject;
import org.verapdf.model.coslayer.CosDict;
import org.verapdf.model.coslayer.CosStream;
import org.verapdf.model.coslayer.CosReal;
import org.verapdf.model.coslayer.CosNumber;
import org.verapdf.model.coslayer.CosRenderingIntent;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.model.coslayer.CosIIFilter;
import org.verapdf.model.coslayer.CosBBox;
import org.verapdf.model.coslayer.CosBM;
import org.verapdf.model.coslayer.CosLang;
import org.verapdf.model.coslayer.CosActualText;
import org.verapdf.model.operator.Operator;
import org.verapdf.model.external.ICCOutputProfile;
import org.verapdf.model.external.ICCInputProfile;
import org.verapdf.model.external.FontProgram;
import org.verapdf.model.external.CMapFile;
import org.verapdf.model.external.JPEG2000;
import org.verapdf.model.external.PKCSDataObject;
import org.verapdf.model.xmplayer.XMPPackage;
import org.verapdf.model.selayer.SEContentItem;

		
/**  the structure element dictionary
 */
public interface PDStructElem extends PDObject {
	

	/**  the value of the Type entry
	 */
	public String getType();

	/**  ampersand separated list of child element types, role mapped to the standard types
	 */
	public String getkidsStandardTypes();

	/**  parent element type, role mapped to the standard type
	 */
	public String getparentStandardType();

	/**  true if the structure element contains content items as its children
	 */
	public Boolean gethasContentItems();



	/**  structure type
	 */
	public String getvalueS();

	/**  standard structure type defined via role map
	 */
	public String getstandardType();


	/**  value of parent Lang entry
	 */
	public String getparentLang();

	/**  true if type is standard but remapped
	 */
	public Boolean getisRemappedStandardType();

	/**  value of the /Alt entry
	 */
	public String getAlt();

	/**  value of the /ActualText entry
	 */
	public String getActualText();

	/**  value of the /E entry
	 */
	public String getE();

	/**  true, if circular mapping exist
	 */
	public Boolean getcircularMappingExist();

}
