/**
 * This file is part of veraPDF Validation Model API, a module of the veraPDF project.
 * Copyright (c) 2015-2024, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation Model API is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation Model API as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation Model API as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.pdlayer;
		
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosObject;
import org.verapdf.model.coslayer.CosDict;
import org.verapdf.model.coslayer.CosStream;
import org.verapdf.model.coslayer.CosReal;
import org.verapdf.model.coslayer.CosNumber;
import org.verapdf.model.coslayer.CosRenderingIntent;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.model.coslayer.CosIIFilter;
import org.verapdf.model.coslayer.CosBBox;
import org.verapdf.model.coslayer.CosBM;
import org.verapdf.model.coslayer.CosLang;
import org.verapdf.model.coslayer.CosTextString;
import org.verapdf.model.coslayer.CosActualText;
import org.verapdf.model.coslayer.CosAlt;
import org.verapdf.model.operator.Operator;
import org.verapdf.model.external.ICCOutputProfile;
import org.verapdf.model.external.ICCInputProfile;
import org.verapdf.model.external.FontProgram;
import org.verapdf.model.external.CMapFile;
import org.verapdf.model.external.JPEG2000;
import org.verapdf.model.external.PKCSDataObject;
import org.verapdf.model.xmplayer.XMPPackage;
import org.verapdf.model.selayer.SEContentItem;

		
/**
* annotation object
*/
public interface PDAnnot extends PDObject {
	

	/**
	* annotation subtype
	*/
	public String getSubtype();

	/**
	* annotation opacity (CA key)
	*/
	public Double getCA();

	/**
	* annotation flags
	*/
	public Long getF();

	/**
	* ampersand-separated list of all keys in the annotation's appearance dictionary (AP key)
	*/
	public String getAP();

	/**
	* the value of the /FT entry (Field type), in case this is the widget annotation representing the form field, or null, if this entry is not present
	*/
	public String getFT();

	/**
	* the type of the normal appearance entry (/N key) in the annotation appearance dictionary (/AP key) or null, if the normal appearance is not present
	*/
	public String getN_type();


	/**
	* true if the annotation dictionary contains the C entry
	*/
	public Boolean getcontainsC();

	/**
	* true if the annotation dictionary contains the IC entry
	*/
	public Boolean getcontainsIC();



	/**
	* the width of the annotation computed as an absolute value of the difference of value 1 and value 3 of the Rect entry
	*/
	public Double getwidth();

	/**
	* the height of the annotation computed as an absolute value of the difference of value 2 and value 4 of the Rect entry
	*/
	public Double getheight();

	/**
	* true if the annotation dictionary contains the A entry
	*/
	public Boolean getcontainsA();

	/**
	* true if the annotation dictionary contains the AA entry
	*/
	public Boolean getcontainsAA();

	/**
	* struct parent element type
	*/
	public String getstructParentType();

	/**
	* struct parent element standard type
	*/
	public String getstructParentStandardType();

	/**
	* indirect object number and generation number of the parent struct element of the annotation
	*/
	public String getstructParentObjectKey();


	/**
	* the value of the /Contents entry
	*/
	public String getContents();

	/**
	* the Alt entry of parent structure element
	*/
	public String getAlt();

	/**
	* true, if annotation rectangle is outside page CropBox
	*/
	public Boolean getisOutsideCropBox();

	/**
	* true if this annotation is contained in an Artifact structure element (directly or indirectly)
	*/
	public Boolean getisArtifact();

}
