/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDNameTreeNode;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.documentinterchange.markedcontent.PDPropertyList;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontLike;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.apache.pdfbox.pdmodel.graphics.PDPostScriptXObject;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.color.PDIndexed;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDGroup;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObjectProxy;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDShadingPattern;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceEntry;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeaturesExtractor;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.FeaturesReporter;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.PBFeaturesObjectCreator;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public final class PBFeatureParser {
    private static final Logger LOGGER = Logger.getLogger(PBFeatureParser.class);
    private static final String PAGE = "page";
    private static final String ICCPROFILE = "iccProfile";
    private static final String ID = "id";
    private static final String ANNOTATION = "annotation";
    private static final String ANNOT = "annot";
    private static final String OUTINT = "outInt";
    private static final String EMBEDDEDFILE = "embeddedFile";
    private static final String FONT = "font";
    private static final String SHADING = "shading";
    private static final String XOBJECT = "xobject";
    private static final String PATTERN = "pattern";
    private static final String COLORSPACE = "colorSpace";
    private static final String EXTGSTATE_ID = "exGSt";
    private static final String COLORSPACE_ID = "clrsp";
    private static final String PATTERN_ID = "ptrn";
    private static final String SHADING_ID = "shdng";
    private static final String XOBJECT_ID = "xobj";
    private static final String FONT_ID = "fnt";
    private static final String PROPERTIES_ID = "prop";
    private static final String DEVICEGRAY_ID = "devgray";
    private static final String DEVICERGB_ID = "devrgb";
    private static final String DEVICECMYK_ID = "devcmyk";
    private FeaturesReporter reporter;
    private Map<String, COSStream> iccProfiles = new HashMap<String, COSStream>();
    private Map<String, Set<String>> iccProfileOutInts = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> iccProfileICCBased = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> pageExtGStateChild = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> pageColorSpaceChild = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> pagePatternChild = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> pageShadingChild = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> pageXObjectChild = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> pageFontChild = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> pagePropertiesChild = new HashMap<String, Set<String>>();
    private Map<String, PDAnnotation> annots = new HashMap<String, PDAnnotation>();
    private Map<String, String> annotChild = new HashMap<String, String>();
    private Map<String, Set<String>> annotXObjectsChild = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> annotPagesParent = new HashMap<String, Set<String>>();
    private Map<String, String> annotParent = new HashMap<String, String>();
    private Map<String, PDExtendedGraphicsState> exGStates = new HashMap<String, PDExtendedGraphicsState>();
    private Map<String, String> exGStateFontChild = new HashMap<String, String>();
    private Map<String, Set<String>> exGStatePageParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> exGStatePatternParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> exGStateXObjectParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> exGStateFontParent = new HashMap<String, Set<String>>();
    private Map<String, PDColorSpace> colorSpaces = new HashMap<String, PDColorSpace>();
    private Map<String, String> colorSpaceIccProfileChild = new HashMap<String, String>();
    private Map<String, String> colorSpaceColorSpaceChild = new HashMap<String, String>();
    private Map<String, Set<String>> colorSpacePageParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> colorSpaceColorSpaceParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> colorSpacePatternParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> colorSpaceShadingParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> colorSpaceXObjectParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> colorSpaceFontParent = new HashMap<String, Set<String>>();
    private Map<String, PDTilingPattern> tilingPatterns = new HashMap<String, PDTilingPattern>();
    private Map<String, Set<String>> tilingPatternExtGStateChild = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> tilingPatternColorSpaceChild = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> tilingPatternPatternChild = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> tilingPatternShadingChild = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> tilingPatternXObjectChild = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> tilingPatternFontChild = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> tilingPatternPropertiesChild = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> tilingPatternPageParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> tilingPatternPatternParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> tilingPatternXObjectParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> tilingPatternFontParent = new HashMap<String, Set<String>>();
    private Map<String, PDShadingPattern> shadingPatterns = new HashMap<String, PDShadingPattern>();
    private Map<String, String> shadingPatternShadingChild = new HashMap<String, String>();
    private Map<String, String> shadingPatternExtGStateChild = new HashMap<String, String>();
    private Map<String, Set<String>> shadingPatternPageParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> shadingPatternPatternParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> shadingPatternXObjectParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> shadingPatternFontParent = new HashMap<String, Set<String>>();
    private Map<String, PDShading> shadings = new HashMap<String, PDShading>();
    private Map<String, String> shadingColorSpaceChild = new HashMap<String, String>();
    private Map<String, Set<String>> shadingPageParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> shadingPatternParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> shadingXObjectParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> shadingFontParent = new HashMap<String, Set<String>>();
    private Map<String, PDImageXObjectProxy> imageXObjects = new HashMap<String, PDImageXObjectProxy>();
    private Map<String, String> imageXObjectColorSpaceChild = new HashMap<String, String>();
    private Map<String, String> imageXObjectMaskChild = new HashMap<String, String>();
    private Map<String, String> imageXObjectSMaskChild = new HashMap<String, String>();
    private Map<String, Set<String>> imageXObjectAlternatesChild = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> imageXObjectPageParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> imageXObjectPatternParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> imageXObjectXObjectParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> imageXObjectFontParent = new HashMap<String, Set<String>>();
    private Map<String, PDFormXObject> formXObjects = new HashMap<String, PDFormXObject>();
    private Map<String, String> groupXObjectColorSpaceChild = new HashMap<String, String>();
    private Map<String, Set<String>> formXObjectExtGStateChild = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> formXObjectColorSpaceChild = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> formXObjectPatternChild = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> formXObjectShadingChild = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> formXObjectXObjectChild = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> formXObjectFontChild = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> formXObjectPropertiesChild = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> formXObjectPageParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> formXObjectAnnotationParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> formXObjectPatternParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> formXObjectXObjectParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> formXObjectFontParent = new HashMap<String, Set<String>>();
    private Map<String, PDFontLike> fonts = new HashMap<String, PDFontLike>();
    private Map<String, Set<String>> fontExtGStateChild = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> fontColorSpaceChild = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> fontPatternChild = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> fontShadingChild = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> fontXObjectChild = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> fontFontChild = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> fontPropertiesChild = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> fontExtGStateParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> fontPageParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> fontPatternParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> fontXObjectParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> fontFontParent = new HashMap<String, Set<String>>();
    private Map<String, COSDictionary> properties = new HashMap<String, COSDictionary>();
    private Map<String, Set<String>> propertyPageParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> propertyPatternParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> propertyXObjectParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> propertyFontParent = new HashMap<String, Set<String>>();
    private Set<String> postscripts = new HashSet<String>();
    private Map<String, Set<String>> postscriptPageParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> postscriptPatternParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> postscriptXObjectParent = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> postscriptFontParent = new HashMap<String, Set<String>>();

    private PBFeatureParser(FeaturesReporter reporter) {
        this.reporter = reporter;
    }

    public static FeaturesCollection getFeaturesCollection(PDDocument document) {
        FeaturesReporter reporter = new FeaturesReporter();
        return PBFeatureParser.getFeatures(document, reporter);
    }

    public static FeaturesCollection getFeaturesCollection(PDDocument document, List<FeaturesExtractor> extractors) {
        FeaturesReporter reporter = new FeaturesReporter(extractors);
        return PBFeatureParser.getFeatures(document, reporter);
    }

    private static FeaturesCollection getFeatures(PDDocument document, FeaturesReporter reporter) {
        if (document != null) {
            PBFeatureParser parser = new PBFeatureParser(reporter);
            parser.parseDocumentFeatures(document);
        }
        return reporter.getCollection();
    }

    private void parseDocumentFeatures(PDDocument document) {
        this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createInfoDictFeaturesObject(document.getDocumentInformation()));
        this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createDocSecurityFeaturesObject(document.getEncryption()));
        PDDocumentCatalog catalog = document.getDocumentCatalog();
        if (catalog != null) {
            this.getCatalogFeatures(catalog);
        }
        this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createLowLvlInfoFeaturesObject(document.getDocument()));
    }

    private void getCatalogFeatures(PDDocumentCatalog catalog) {
        String id;
        PDPageTree pageTree;
        this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createMetadataFeaturesObject(catalog.getMetadata()));
        this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createOutlinesFeaturesObject(catalog.getDocumentOutline()));
        if (catalog.getNames() != null && catalog.getNames().getEmbeddedFiles() != null) {
            this.reportEmbeddedFiles(catalog);
        }
        if (catalog.getOutputIntents() != null) {
            int outIntNumber = 0;
            for (PDOutputIntent pDOutputIntent : catalog.getOutputIntents()) {
                String outIntID = PBFeatureParser.getId(pDOutputIntent.getCOSObject(), OUTINT, outIntNumber++);
                String iccProfileID = this.addICCProfileFromOutputIntent(pDOutputIntent, outIntID);
                this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createOutputIntentFeaturesObject(pDOutputIntent, outIntID, iccProfileID));
            }
        }
        if ((pageTree = catalog.getPages()) != null) {
            this.getPageTreeFeatures(pageTree);
        }
        for (Map.Entry entry : this.iccProfiles.entrySet()) {
            if (entry.getValue() == null) continue;
            id = (String)entry.getKey();
            this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createICCProfileFeaturesObject((COSStream)entry.getValue(), id, this.iccProfileOutInts.get(id), this.iccProfileICCBased.get(id)));
        }
        for (Map.Entry entry : this.annots.entrySet()) {
            if (entry.getValue() == null) continue;
            id = (String)entry.getKey();
            this.getAnnotationResourcesDependencies((PDAnnotation)entry.getValue(), id);
            this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createAnnotFeaturesObject((PDAnnotation)entry.getValue(), id, this.annotPagesParent.get(id), this.annotParent.get(id), this.annotChild.get(id), this.annotXObjectsChild.get(id)));
        }
        this.getResourcesFeatures();
    }

    private void getResourcesFeatures() {
        String id;
        for (Map.Entry<String, PDExtendedGraphicsState> entry : this.exGStates.entrySet()) {
            if (entry.getValue() == null) continue;
            id = entry.getKey();
            this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createExtGStateFeaturesObject(entry.getValue(), id, this.exGStateFontChild.get(id), this.exGStatePageParent.get(id), this.exGStatePatternParent.get(id), this.exGStateXObjectParent.get(id), this.exGStateFontParent.get(id)));
        }
        for (Map.Entry<String, PDExtendedGraphicsState> entry : this.colorSpaces.entrySet()) {
            if (entry.getValue() == null) continue;
            id = entry.getKey();
            this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createColorSpaceFeaturesObject((PDColorSpace)entry.getValue(), id, this.colorSpaceIccProfileChild.get(id), this.colorSpaceColorSpaceChild.get(id), this.colorSpacePageParent.get(id), this.colorSpaceColorSpaceParent.get(id), this.colorSpacePatternParent.get(id), this.colorSpaceShadingParent.get(id), this.colorSpaceXObjectParent.get(id), this.colorSpaceFontParent.get(id)));
        }
        for (Map.Entry<String, PDExtendedGraphicsState> entry : this.tilingPatterns.entrySet()) {
            if (entry.getValue() == null) continue;
            id = entry.getKey();
            this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createTilingPatternFeaturesObject((PDTilingPattern)entry.getValue(), id, this.tilingPatternExtGStateChild.get(id), this.tilingPatternColorSpaceChild.get(id), this.tilingPatternPatternChild.get(id), this.tilingPatternShadingChild.get(id), this.tilingPatternXObjectChild.get(id), this.tilingPatternFontChild.get(id), this.tilingPatternPropertiesChild.get(id), this.tilingPatternPageParent.get(id), this.tilingPatternPatternParent.get(id), this.tilingPatternXObjectParent.get(id), this.tilingPatternFontParent.get(id)));
        }
        for (Map.Entry<String, PDExtendedGraphicsState> entry : this.shadingPatterns.entrySet()) {
            if (entry.getValue() == null) continue;
            id = entry.getKey();
            this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createShadingPatternFeaturesObject((PDShadingPattern)entry.getValue(), id, this.shadingPatternShadingChild.get(id), this.shadingPatternExtGStateChild.get(id), this.shadingPatternPageParent.get(id), this.shadingPatternPatternParent.get(id), this.shadingPatternXObjectParent.get(id), this.shadingPatternFontParent.get(id)));
        }
        for (Map.Entry<String, PDExtendedGraphicsState> entry : this.shadings.entrySet()) {
            if (entry.getValue() == null) continue;
            id = entry.getKey();
            this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createShadingFeaturesObject((PDShading)entry.getValue(), id, this.shadingColorSpaceChild.get(id), this.shadingPageParent.get(id), this.shadingPatternParent.get(id), this.shadingXObjectParent.get(id), this.shadingFontParent.get(id)));
        }
        for (Map.Entry<String, PDExtendedGraphicsState> entry : this.imageXObjects.entrySet()) {
            if (entry.getValue() == null) continue;
            id = entry.getKey();
            this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createImageXObjectFeaturesObject((PDImageXObjectProxy)entry.getValue(), id, this.imageXObjectColorSpaceChild.get(id), this.imageXObjectMaskChild.get(id), this.imageXObjectSMaskChild.get(id), this.imageXObjectAlternatesChild.get(id), this.imageXObjectPageParent.get(id), this.imageXObjectPatternParent.get(id), this.imageXObjectXObjectParent.get(id), this.imageXObjectFontParent.get(id)));
        }
        for (Map.Entry<String, PDExtendedGraphicsState> entry : this.formXObjects.entrySet()) {
            if (entry.getValue() == null) continue;
            id = entry.getKey();
            this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createFormXObjectFeaturesObject((PDFormXObject)entry.getValue(), id, this.groupXObjectColorSpaceChild.get(id), this.formXObjectExtGStateChild.get(id), this.formXObjectColorSpaceChild.get(id), this.formXObjectPatternChild.get(id), this.formXObjectShadingChild.get(id), this.formXObjectXObjectChild.get(id), this.formXObjectFontChild.get(id), this.formXObjectPropertiesChild.get(id), this.formXObjectPageParent.get(id), this.formXObjectAnnotationParent.get(id), this.formXObjectPatternParent.get(id), this.formXObjectXObjectParent.get(id), this.formXObjectFontParent.get(id)));
        }
        for (String string : this.postscripts) {
            if (string == null) continue;
            this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createPostScriptXObjectFeaturesObject(string, this.postscriptPageParent.get(string), this.postscriptPatternParent.get(string), this.postscriptXObjectParent.get(string), this.postscriptFontParent.get(string)));
        }
        for (Map.Entry entry : this.fonts.entrySet()) {
            if (entry.getValue() == null) continue;
            id = (String)entry.getKey();
            this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createFontFeaturesObject((PDFontLike)entry.getValue(), id, this.fontExtGStateChild.get(id), this.fontColorSpaceChild.get(id), this.fontPatternChild.get(id), this.fontShadingChild.get(id), this.fontXObjectChild.get(id), this.fontFontChild.get(id), this.fontPropertiesChild.get(id), this.fontExtGStateParent.get(id), this.fontPageParent.get(id), this.fontPatternParent.get(id), this.fontXObjectParent.get(id), this.fontFontParent.get(id)));
        }
        for (Map.Entry entry : this.properties.entrySet()) {
            if (entry.getValue() == null) continue;
            id = (String)entry.getKey();
            this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createPropertiesDictFeaturesObject((COSDictionary)entry.getValue(), id, this.propertyPageParent.get(id), this.propertyPatternParent.get(id), this.propertyXObjectParent.get(id), this.propertyFontParent.get(id)));
        }
    }

    private void getPageTreeFeatures(PDPageTree pageTree) {
        for (PDPage page : pageTree) {
            int pageIndex = pageTree.indexOf(page) + 1;
            Set<String> annotsId = this.addAnnotsDependencies(page, pageIndex);
            String thumbID = null;
            if (page.getCOSObject().getDictionaryObject(COSName.getPDFName((String)"Thumb")) != null) {
                COSBase baseThumb = page.getCOSObject().getItem(COSName.getPDFName((String)"Thumb"));
                thumbID = PBFeatureParser.getId(baseThumb, XOBJECT_ID, this.imageXObjects.size() + this.formXObjects.size() + this.postscripts.size());
                if (this.imageXObjectPageParent.get(thumbID) == null) {
                    this.imageXObjectPageParent.put(thumbID, new HashSet());
                }
                this.imageXObjectPageParent.get(thumbID).add(PAGE + pageIndex);
                if (!this.imageXObjects.containsKey(thumbID)) {
                    COSBase base = PBFeatureParser.getBase(baseThumb);
                    if (base instanceof COSStream) {
                        PDImageXObjectProxy img = new PDImageXObjectProxy(new PDStream((COSStream)base), null);
                        this.imageXObjects.put(thumbID, img);
                        this.parseImageXObject(img, thumbID);
                    } else {
                        this.xobjectCreationProblem(thumbID, "Thumb is not a stream");
                    }
                }
            }
            this.getResourceDictionaryDependencies(page.getResources(), PAGE + pageIndex, this.pageExtGStateChild, this.pageColorSpaceChild, this.pagePatternChild, this.pageShadingChild, this.pageXObjectChild, this.pageFontChild, this.pagePropertiesChild, this.exGStatePageParent, this.colorSpacePageParent, this.tilingPatternPageParent, this.shadingPatternPageParent, this.shadingPageParent, this.imageXObjectPageParent, this.formXObjectPageParent, this.postscriptPageParent, this.fontPageParent, this.propertyPageParent);
            this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createPageFeaturesObject(page, thumbID, annotsId, this.pageExtGStateChild.get(PAGE + pageIndex), this.pageColorSpaceChild.get(PAGE + pageIndex), this.pagePatternChild.get(PAGE + pageIndex), this.pageShadingChild.get(PAGE + pageIndex), this.pageXObjectChild.get(PAGE + pageIndex), this.pageFontChild.get(PAGE + pageIndex), this.pagePropertiesChild.get(PAGE + pageIndex), PAGE + pageIndex, pageIndex));
        }
    }

    private Set<String> addAnnotsDependencies(PDPage page, int pageIndex) {
        COSArray annotsArray = (COSArray)page.getCOSObject().getDictionaryObject(COSName.ANNOTS);
        if (annotsArray == null) {
            return Collections.emptySet();
        }
        HashSet<String> annotsId = new HashSet<String>();
        for (int i = 0; i < annotsArray.size(); ++i) {
            COSBase item = annotsArray.get(i);
            if (item == null) continue;
            String id = PBFeatureParser.getId(item, ANNOT, this.annots.keySet().size());
            annotsId.add(id);
            if (this.annotPagesParent.get(id) == null) {
                this.annotPagesParent.put(id, new HashSet());
            }
            this.annotPagesParent.get(id).add(PAGE + pageIndex);
            COSBase base = PBFeatureParser.getBase(item);
            try {
                PDAnnotation annotation = PDAnnotation.createAnnotation((COSBase)base);
                this.annots.put(id, annotation);
                COSBase pop = annotation.getCOSObject().getItem(COSName.getPDFName((String)"Popup"));
                if (pop == null) continue;
                this.addPopup(pop, id);
                continue;
            }
            catch (IOException e) {
                LOGGER.debug((Object)"Unknown annotation type detected.", (Throwable)e);
                this.generateUnknownAnnotation(id);
            }
        }
        return annotsId;
    }

    private void addPopup(COSBase item, String parentId) {
        String id = PBFeatureParser.getId(item, ANNOT, this.annots.keySet().size());
        COSBase base = PBFeatureParser.getBase(item);
        this.annotChild.put(parentId, id);
        this.annotParent.put(id, parentId);
        try {
            PDAnnotation annotation = PDAnnotation.createAnnotation((COSBase)base);
            this.annots.put(id, annotation);
        }
        catch (IOException e) {
            LOGGER.debug((Object)"Unknown annotation type detected.", (Throwable)e);
            this.generateUnknownAnnotation(id);
        }
    }

    private void generateUnknownAnnotation(String id) {
        try {
            FeatureTreeNode annot = FeatureTreeNode.createRootNode((String)ANNOTATION);
            annot.setAttribute(ID, id);
            ErrorsHelper.addErrorIntoCollection((FeaturesCollection)this.reporter.getCollection(), (FeatureTreeNode)annot, (String)"Unknown annotation type");
            this.reporter.getCollection().addNewFeatureTree(FeaturesObjectTypesEnum.ANNOTATION, annot);
        }
        catch (FeatureParsingException e) {
            String message = "PBFeatureParser.generateUnknownAnnotation logic failure.";
            LOGGER.fatal((Object)message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
    }

    private void reportEmbeddedFiles(PDDocumentCatalog catalog) {
        int index = 0;
        PDEmbeddedFilesNameTreeNode efTree = catalog.getNames().getEmbeddedFiles();
        try {
            if (efTree.getNames() != null) {
                for (PDComplexFileSpecification file : efTree.getNames().values()) {
                    this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createEmbeddedFileFeaturesObject(file, ++index));
                }
            }
        }
        catch (IOException e) {
            LOGGER.debug((Object)"Error creating PDFBox SubType.", (Throwable)e);
            this.handleSubtypeCreationProblem(e.getMessage());
        }
        if (efTree.getKids() != null) {
            for (PDNameTreeNode tree : efTree.getKids()) {
                if (tree == null) continue;
                index = this.reportEmbeddedFileNode((PDNameTreeNode<PDComplexFileSpecification>)tree, index);
            }
        }
    }

    private int reportEmbeddedFileNode(PDNameTreeNode<PDComplexFileSpecification> node, int index) {
        int res = index;
        try {
            if (node.getNames() != null) {
                for (PDComplexFileSpecification file : node.getNames().values()) {
                    if (file == null) continue;
                    this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createEmbeddedFileFeaturesObject(file, ++res));
                }
            }
        }
        catch (IOException e) {
            LOGGER.debug((Object)"Subtype creation exception caught", (Throwable)e);
            this.handleSubtypeCreationProblem(e.getMessage());
        }
        if (node.getKids() != null) {
            for (PDNameTreeNode tree : node.getKids()) {
                res = this.reportEmbeddedFileNode((PDNameTreeNode<PDComplexFileSpecification>)tree, res);
            }
        }
        return res;
    }

    private String addICCProfileFromOutputIntent(PDOutputIntent outInt, String outIntID) {
        COSBase outIntBase = outInt.getCOSObject();
        if (outIntBase instanceof COSDictionary) {
            COSDictionary outIntDict = (COSDictionary)outIntBase;
            String iccProfileID = PBFeatureParser.getId(outIntDict.getItem(COSName.DEST_OUTPUT_PROFILE), ICCPROFILE, this.iccProfiles.size());
            if (!this.iccProfiles.containsKey(iccProfileID)) {
                this.iccProfiles.put(iccProfileID, outInt.getDestOutputIntent());
            }
            if (!this.iccProfileOutInts.containsKey(iccProfileID)) {
                this.iccProfileOutInts.put(iccProfileID, new HashSet());
            }
            this.iccProfileOutInts.get(iccProfileID).add(outIntID);
            return iccProfileID;
        }
        return null;
    }

    private void handleSubtypeCreationProblem(String errorMessage) {
        this.creationProblem(EMBEDDEDFILE, null, errorMessage, FeaturesObjectTypesEnum.EMBEDDED_FILE, "PBFeatureParser.reportEmbeddedFileNode logic failure.", true);
    }

    private void fontCreationProblem(String nodeID, String errorMessage) {
        this.creationProblem(FONT, nodeID, errorMessage, FeaturesObjectTypesEnum.FONT, "PBFeatureParser.fontCreationProblem logic failure.", false);
    }

    private void patternCreationProblem(String nodeID, String errorMessage) {
        this.creationProblem(PATTERN, nodeID, errorMessage, FeaturesObjectTypesEnum.PATTERN, "PBFeatureParser.patternCreationProblem logic failure.", false);
    }

    private void colorSpaceCreationProblem(String nodeID, String errorMessage) {
        this.creationProblem(COLORSPACE, nodeID, errorMessage, FeaturesObjectTypesEnum.COLORSPACE, "PBFeatureParser.colorSpaceCreationProblem logic failure.", false);
    }

    private void shadingCreationProblem(String nodeID, String errorMessage) {
        this.creationProblem(SHADING, nodeID, errorMessage, FeaturesObjectTypesEnum.SHADING, "PBFeatureParser.shadingCreationProblem logic failure.", false);
    }

    private void xobjectCreationProblem(String nodeID, String errorMessage) {
        this.creationProblem(XOBJECT, nodeID, errorMessage, FeaturesObjectTypesEnum.FAILED_XOBJECT, "PBFeatureParser.xobjectCreationProblem logic failure.", false);
    }

    private void creationProblem(String nodeName, String nodeID, String errorMessage, FeaturesObjectTypesEnum type, String loggerMessage, boolean isTypeError) {
        try {
            if (!isTypeError) {
                FeatureTreeNode node = FeatureTreeNode.createRootNode((String)nodeName);
                if (nodeID != null) {
                    node.setAttribute(ID, nodeID);
                }
                this.reporter.getCollection().addNewFeatureTree(type, node);
                ErrorsHelper.addErrorIntoCollection((FeaturesCollection)this.reporter.getCollection(), (FeatureTreeNode)node, (String)errorMessage);
            } else {
                String id = ErrorsHelper.addErrorIntoCollection((FeaturesCollection)this.reporter.getCollection(), null, (String)errorMessage);
                this.reporter.getCollection().addNewError(type, id);
            }
        }
        catch (FeatureParsingException e) {
            LOGGER.fatal((Object)loggerMessage, (Throwable)e);
            throw new IllegalStateException(loggerMessage, e);
        }
    }

    private void getAnnotationResourcesDependencies(PDAnnotation annot, String annotationID) {
        PDAppearanceDictionary dic = annot.getAppearance();
        if (dic != null) {
            COSBase baseDown;
            COSBase baseRollover;
            COSBase baseNormal = dic.getCOSObject().getItem(COSName.N);
            if (baseNormal != null) {
                this.getAppearanceEntryDependencies(dic.getNormalAppearance(), baseNormal, annotationID);
            }
            if ((baseRollover = dic.getCOSObject().getItem(COSName.R)) != null) {
                this.getAppearanceEntryDependencies(dic.getRolloverAppearance(), baseRollover, annotationID);
            }
            if ((baseDown = dic.getCOSObject().getItem(COSName.D)) != null) {
                this.getAppearanceEntryDependencies(dic.getDownAppearance(), baseDown, annotationID);
            }
        }
    }

    private void getAppearanceEntryDependencies(PDAppearanceEntry entry, COSBase entryLink, String annotationID) {
        if (entry.isStream()) {
            this.getAppearanceStreamDependencies(entry.getAppearanceStream(), entryLink, annotationID);
        } else {
            for (Map.Entry mapEntry : entry.getSubDictionary().entrySet()) {
                this.getAppearanceStreamDependencies((PDAppearanceStream)mapEntry.getValue(), ((COSDictionary)entry.getCOSObject()).getItem((COSName)mapEntry.getKey()), annotationID);
            }
        }
    }

    private void getAppearanceStreamDependencies(PDAppearanceStream stream, COSBase entryLink, String annotationID) {
        String id = PBFeatureParser.getId(entryLink, XOBJECT_ID, this.formXObjects.size());
        PBFeatureParser.makePairDependence(id, annotationID, this.formXObjectAnnotationParent, this.annotXObjectsChild);
        if (!this.formXObjects.containsKey(id)) {
            this.formXObjects.put(id, (PDFormXObject)stream);
            this.getResourceDictionaryDependencies(stream.getResources(), id, this.formXObjectExtGStateChild, this.formXObjectColorSpaceChild, this.formXObjectPatternChild, this.formXObjectShadingChild, this.formXObjectXObjectChild, this.formXObjectFontChild, this.formXObjectPropertiesChild, this.exGStateXObjectParent, this.colorSpaceXObjectParent, this.tilingPatternXObjectParent, this.shadingPatternXObjectParent, this.shadingXObjectParent, this.imageXObjectXObjectParent, this.formXObjectXObjectParent, this.postscriptXObjectParent, this.fontXObjectParent, this.propertyXObjectParent);
        }
    }

    private void getResourceDictionaryDependencies(PDResources resources, String parentID, Map<String, Set<String>> exGStateChildMap, Map<String, Set<String>> colorSpaceChildMap, Map<String, Set<String>> patternChildMap, Map<String, Set<String>> shadingChildMap, Map<String, Set<String>> xobjectChildMap, Map<String, Set<String>> fontChildMap, Map<String, Set<String>> propertiesChildMap, Map<String, Set<String>> exGStateParentMap, Map<String, Set<String>> colorSpaceParentMap, Map<String, Set<String>> tilingPatternParentMap, Map<String, Set<String>> shadingPatternParentMap, Map<String, Set<String>> shadingParentMap, Map<String, Set<String>> imageXObjectParentMap, Map<String, Set<String>> formXObjectParentMap, Map<String, Set<String>> postscriptParentMap, Map<String, Set<String>> fontParentMap, Map<String, Set<String>> propertiesParentMap) {
        this.parseExGStateFromResource(resources, parentID, exGStateChildMap, exGStateParentMap);
        if (resources == null) {
            return;
        }
        if (resources.getColorSpaceNames() != null) {
            for (COSName name : resources.getColorSpaceNames()) {
                COSDictionary dict = (COSDictionary)resources.getCOSObject().getDictionaryObject(COSName.COLORSPACE);
                COSBase base = dict.getItem(name);
                String id = PBFeatureParser.getId(base, COLORSPACE_ID, this.colorSpaces.size());
                try {
                    PDColorSpace colorSpace = resources.getColorSpace(name);
                    id = PBFeatureParser.checkColorSpaceID(id, colorSpace);
                    PBFeatureParser.makePairDependence(id, parentID, colorSpaceParentMap, colorSpaceChildMap);
                    if (this.colorSpaces.containsKey(id)) continue;
                    this.colorSpaces.put(id, colorSpace);
                    this.parseColorSpace(colorSpace, id);
                }
                catch (IOException e) {
                    LOGGER.info((Object)e);
                    if (!xobjectChildMap.containsKey(parentID)) {
                        xobjectChildMap.put(parentID, new HashSet());
                    }
                    xobjectChildMap.get(parentID).add(id);
                    this.colorSpaceCreationProblem(id, e.getMessage());
                }
            }
        }
        this.parsePatternFromResource(resources, parentID, patternChildMap, tilingPatternParentMap, shadingPatternParentMap);
        this.parseShadingFromResource(resources, parentID, shadingChildMap, shadingParentMap);
        this.parseXObjectFromResources(resources, parentID, xobjectChildMap, imageXObjectParentMap, formXObjectParentMap, postscriptParentMap);
        this.parseFontFromResources(resources, parentID, fontChildMap, fontParentMap);
        this.parsePropertiesFromResources(resources, parentID, propertiesChildMap, propertiesParentMap);
    }

    private void parseImageXObject(PDImageXObjectProxy xobj, String id) {
        COSBase sMask;
        COSBase baseColorSpace = ((COSStream)xobj.getCOSObject()).getItem(COSName.CS);
        if (baseColorSpace == null) {
            baseColorSpace = ((COSStream)xobj.getCOSObject()).getItem(COSName.COLORSPACE);
        }
        String idColorSpace = PBFeatureParser.getId(baseColorSpace, COLORSPACE_ID, this.colorSpaces.size());
        try {
            PDColorSpace colorSpace = xobj.getColorSpace();
            idColorSpace = PBFeatureParser.checkColorSpaceID(idColorSpace, colorSpace);
            if (this.colorSpaceXObjectParent.get(idColorSpace) == null) {
                this.colorSpaceXObjectParent.put(idColorSpace, new HashSet());
            }
            this.colorSpaceXObjectParent.get(idColorSpace).add(id);
            this.imageXObjectColorSpaceChild.put(id, idColorSpace);
            if (!this.colorSpaces.containsKey(idColorSpace)) {
                this.colorSpaces.put(idColorSpace, colorSpace);
                this.parseColorSpace(colorSpace, idColorSpace);
            }
        }
        catch (IOException e) {
            if (this.colorSpaceXObjectParent.get(idColorSpace) == null) {
                this.colorSpaceXObjectParent.put(idColorSpace, new HashSet());
            }
            this.colorSpaceXObjectParent.get(idColorSpace).add(id);
            this.imageXObjectColorSpaceChild.put(id, idColorSpace);
            LOGGER.info((Object)e);
            this.colorSpaceCreationProblem(idColorSpace, e.getMessage());
        }
        COSBase mask = xobj.getCOSStream().getDictionaryObject(COSName.MASK);
        if (mask instanceof COSStream) {
            COSBase maskBase = ((COSStream)xobj.getCOSObject()).getItem(COSName.MASK);
            String idMask = PBFeatureParser.getId(maskBase, XOBJECT_ID, this.imageXObjects.size());
            if (this.imageXObjectXObjectParent.get(idMask) == null) {
                this.imageXObjectXObjectParent.put(idMask, new HashSet());
            }
            this.imageXObjectXObjectParent.get(idMask).add(id);
            this.imageXObjectMaskChild.put(id, idMask);
            if (!this.imageXObjects.containsKey(idMask)) {
                try {
                    PDImageXObjectProxy imxobj = xobj.getMask();
                    this.imageXObjects.put(idMask, imxobj);
                    this.parseImageXObject(imxobj, idMask);
                }
                catch (IOException e) {
                    LOGGER.info((Object)e);
                    this.xobjectCreationProblem(idMask, e.getMessage());
                }
            }
        }
        if ((sMask = xobj.getCOSStream().getDictionaryObject(COSName.SMASK)) instanceof COSStream) {
            COSBase sMaskBase = ((COSStream)xobj.getCOSObject()).getItem(COSName.SMASK);
            String idMask = PBFeatureParser.getId(sMaskBase, XOBJECT_ID, this.imageXObjects.size());
            if (this.imageXObjectXObjectParent.get(idMask) == null) {
                this.imageXObjectXObjectParent.put(idMask, new HashSet());
            }
            this.imageXObjectXObjectParent.get(idMask).add(id);
            this.imageXObjectSMaskChild.put(id, idMask);
            if (!this.imageXObjects.containsKey(idMask)) {
                try {
                    PDImageXObjectProxy imxobj = xobj.getSoftMask();
                    this.imageXObjects.put(idMask, imxobj);
                    this.parseImageXObject(imxobj, idMask);
                }
                catch (IOException e) {
                    LOGGER.info((Object)e);
                    this.xobjectCreationProblem(idMask, e.getMessage());
                }
            }
        }
        COSBase alternates = xobj.getCOSStream().getDictionaryObject(COSName.getPDFName((String)"Alternates"));
        if ((alternates = PBFeatureParser.getBase(alternates)) instanceof COSArray) {
            COSArray alternatesArray = (COSArray)alternates;
            for (COSBase entry : alternatesArray) {
                COSBase base = PBFeatureParser.getBase(entry);
                if (!(base instanceof COSDictionary)) continue;
                COSDictionary altDict = (COSDictionary)base;
                COSBase baseImage = altDict.getItem(COSName.IMAGE);
                String idImage = PBFeatureParser.getId(baseImage, XOBJECT_ID, this.imageXObjects.size());
                if (!((baseImage = PBFeatureParser.getBase(baseImage)) instanceof COSStream)) continue;
                PBFeatureParser.makePairDependence(idImage, id, this.imageXObjectXObjectParent, this.imageXObjectAlternatesChild);
                if (this.imageXObjects.containsKey(idImage)) continue;
                PDImageXObjectProxy im = new PDImageXObjectProxy(new PDStream((COSStream)baseImage), null);
                this.imageXObjects.put(idImage, im);
                this.parseImageXObject(im, idImage);
            }
        }
    }

    private void parseXObjectFromResources(PDResources resources, String parentID, Map<String, Set<String>> xobjectChildMap, Map<String, Set<String>> imageXObjectParentMap, Map<String, Set<String>> formXObjectParentMap, Map<String, Set<String>> postscriptParentMap) {
        if (resources == null || resources.getXObjectNames() == null) {
            return;
        }
        for (COSName name : resources.getXObjectNames()) {
            COSDictionary dict = (COSDictionary)resources.getCOSObject().getDictionaryObject(COSName.XOBJECT);
            COSBase base = dict.getItem(name);
            String id = PBFeatureParser.getId(base, XOBJECT_ID, this.imageXObjects.size() + this.formXObjects.size() + this.postscripts.size());
            try {
                PDXObject xobj = resources.getXObject(name);
                if (xobj instanceof PDImageXObjectProxy) {
                    PBFeatureParser.makePairDependence(id, parentID, imageXObjectParentMap, xobjectChildMap);
                    if (this.imageXObjects.containsKey(id)) continue;
                    this.imageXObjects.put(id, (PDImageXObjectProxy)xobj);
                    this.parseImageXObject((PDImageXObjectProxy)xobj, id);
                    continue;
                }
                if (xobj instanceof PDFormXObject) {
                    PBFeatureParser.makePairDependence(id, parentID, formXObjectParentMap, xobjectChildMap);
                    if (this.formXObjects.containsKey(id)) continue;
                    this.formXObjects.put(id, (PDFormXObject)xobj);
                    PDGroup group = ((PDFormXObject)xobj).getGroup();
                    if (group != null && COSName.TRANSPARENCY.equals((Object)group.getSubType())) {
                        COSBase baseColorSpace = group.getCOSObject().getItem(COSName.CS);
                        String idColorSpace = PBFeatureParser.getId(baseColorSpace, COLORSPACE_ID, this.colorSpaces.size());
                        try {
                            PDColorSpace colorSpace = group.getColorSpace();
                            idColorSpace = PBFeatureParser.checkColorSpaceID(idColorSpace, colorSpace);
                            if (this.colorSpaceXObjectParent.get(idColorSpace) == null) {
                                this.colorSpaceXObjectParent.put(idColorSpace, new HashSet());
                            }
                            this.colorSpaceXObjectParent.get(idColorSpace).add(id);
                            this.groupXObjectColorSpaceChild.put(id, idColorSpace);
                            if (!this.colorSpaces.containsKey(idColorSpace)) {
                                this.colorSpaces.put(idColorSpace, colorSpace);
                                this.parseColorSpace(colorSpace, idColorSpace);
                            }
                        }
                        catch (IOException e) {
                            if (this.colorSpaceXObjectParent.get(idColorSpace) == null) {
                                this.colorSpaceXObjectParent.put(idColorSpace, new HashSet());
                            }
                            this.colorSpaceXObjectParent.get(idColorSpace).add(id);
                            this.groupXObjectColorSpaceChild.put(id, idColorSpace);
                            LOGGER.info((Object)e);
                            this.colorSpaceCreationProblem(idColorSpace, e.getMessage());
                        }
                    }
                    this.getResourceDictionaryDependencies(((PDFormXObject)xobj).getResources(), id, this.formXObjectExtGStateChild, this.formXObjectColorSpaceChild, this.formXObjectPatternChild, this.formXObjectShadingChild, this.formXObjectXObjectChild, this.formXObjectFontChild, this.formXObjectPropertiesChild, this.exGStateXObjectParent, this.colorSpaceXObjectParent, this.tilingPatternXObjectParent, this.shadingPatternXObjectParent, this.shadingXObjectParent, this.imageXObjectXObjectParent, this.formXObjectXObjectParent, this.postscriptXObjectParent, this.fontXObjectParent, this.propertyXObjectParent);
                    continue;
                }
                if (!(xobj instanceof PDPostScriptXObject)) continue;
                PBFeatureParser.makePairDependence(id, parentID, postscriptParentMap, xobjectChildMap);
                this.postscripts.add(id);
            }
            catch (IOException e) {
                LOGGER.info((Object)e);
                this.xobjectCreationProblem(id, e.getMessage());
            }
        }
    }

    private void parsePropertiesFromResources(PDResources resources, String parentID, Map<String, Set<String>> propertiesChildMap, Map<String, Set<String>> propertiesParentMap) {
        if (resources == null || resources.getPropertiesNames() == null) {
            return;
        }
        for (COSName name : resources.getPropertiesNames()) {
            COSDictionary dict = (COSDictionary)resources.getCOSObject().getDictionaryObject(COSName.PROPERTIES);
            COSBase base = dict.getItem(name);
            String id = PBFeatureParser.getId(base, PROPERTIES_ID, this.properties.size());
            PBFeatureParser.makePairDependence(id, parentID, propertiesParentMap, propertiesChildMap);
            if (this.properties.containsKey(id)) continue;
            PDPropertyList property = resources.getProperties(name);
            this.properties.put(id, property.getCOSObject());
        }
    }

    private void parseFontFromResources(PDResources resources, String parentID, Map<String, Set<String>> fontChildMap, Map<String, Set<String>> fontParentMap) {
        if (resources == null || resources.getFontNames() == null) {
            return;
        }
        for (COSName name : resources.getFontNames()) {
            COSDictionary dict = (COSDictionary)resources.getCOSObject().getDictionaryObject(COSName.FONT);
            COSBase base = dict.getItem(name);
            String id = PBFeatureParser.getId(base, FONT_ID, this.fonts.size());
            PBFeatureParser.makePairDependence(id, parentID, fontParentMap, fontChildMap);
            if (this.fonts.containsKey(id)) continue;
            try {
                PDFont font = resources.getFont(name);
                this.fonts.put(id, (PDFontLike)font);
                this.parseFont(font, id);
            }
            catch (IOException e) {
                LOGGER.info((Object)e);
                this.fontCreationProblem(id, e.getMessage());
            }
        }
    }

    private void parseExGStateFromResource(PDResources resources, String parentID, Map<String, Set<String>> exGStateChildMap, Map<String, Set<String>> exGStateParentMap) {
        if (resources == null || resources.getExtGStateNames() == null) {
            return;
        }
        for (COSName name : resources.getExtGStateNames()) {
            COSDictionary dict = (COSDictionary)resources.getCOSObject().getDictionaryObject(COSName.EXT_G_STATE);
            COSBase base = dict.getItem(name);
            String id = PBFeatureParser.getId(base, EXTGSTATE_ID, this.exGStates.size());
            PBFeatureParser.makePairDependence(id, parentID, exGStateParentMap, exGStateChildMap);
            if (this.exGStates.containsKey(id)) continue;
            PDExtendedGraphicsState exGState = resources.getExtGState(name);
            this.exGStates.put(id, exGState);
            if (exGState.getFontSetting() == null || !(exGState.getFontSetting().getCOSObject() instanceof COSArray)) {
                return;
            }
            String fontID = PBFeatureParser.getId(((COSArray)exGState.getFontSetting().getCOSObject()).get(0), FONT_ID, this.fonts.size());
            if (this.fontExtGStateParent.get(fontID) == null) {
                this.fontExtGStateParent.put(fontID, new HashSet());
            }
            this.fontExtGStateParent.get(fontID).add(id);
            this.exGStateFontChild.put(id, fontID);
            if (this.fonts.containsKey(fontID)) continue;
            try {
                PDFont font = exGState.getFontSetting().getFont();
                this.fonts.put(fontID, (PDFontLike)font);
                this.parseFont(font, fontID);
            }
            catch (IOException e) {
                LOGGER.info((Object)e);
                this.fontCreationProblem(fontID, e.getMessage());
            }
        }
    }

    private void parsePatternFromResource(PDResources resources, String parentID, Map<String, Set<String>> patternChildMap, Map<String, Set<String>> tilingPatternParentMap, Map<String, Set<String>> shadingPatternParentMap) {
        if (resources == null || resources.getPatternNames() == null) {
            return;
        }
        for (COSName name : resources.getPatternNames()) {
            COSDictionary dict = (COSDictionary)resources.getCOSObject().getDictionaryObject(COSName.PATTERN);
            COSBase base = dict.getItem(name);
            String id = PBFeatureParser.getId(base, PATTERN_ID, this.shadingPatterns.size() + this.tilingPatterns.size());
            if (patternChildMap.get(parentID) == null) {
                patternChildMap.put(parentID, new HashSet());
            }
            patternChildMap.get(parentID).add(id);
            try {
                PDAbstractPattern pattern = resources.getPattern(name);
                if (pattern instanceof PDTilingPattern) {
                    if (tilingPatternParentMap.get(id) == null) {
                        tilingPatternParentMap.put(id, new HashSet());
                    }
                    tilingPatternParentMap.get(id).add(parentID);
                    if (this.tilingPatterns.containsKey(id)) continue;
                    PDTilingPattern tilingPattern = (PDTilingPattern)pattern;
                    this.tilingPatterns.put(id, tilingPattern);
                    this.getResourceDictionaryDependencies(tilingPattern.getResources(), id, this.tilingPatternExtGStateChild, this.tilingPatternColorSpaceChild, this.tilingPatternPatternChild, this.tilingPatternShadingChild, this.tilingPatternXObjectChild, this.tilingPatternFontChild, this.tilingPatternPropertiesChild, this.exGStatePatternParent, this.colorSpacePatternParent, this.tilingPatternPatternParent, this.shadingPatternPatternParent, this.shadingPatternParent, this.imageXObjectPatternParent, this.formXObjectPatternParent, this.postscriptPatternParent, this.fontPatternParent, this.propertyPatternParent);
                    continue;
                }
                if (shadingPatternParentMap.get(id) == null) {
                    shadingPatternParentMap.put(id, new HashSet());
                }
                shadingPatternParentMap.get(id).add(parentID);
                if (this.shadingPatterns.containsKey(id)) continue;
                PDShadingPattern shadingPattern = (PDShadingPattern)pattern;
                this.shadingPatterns.put(id, shadingPattern);
                COSBase baseShading = shadingPattern.getCOSObject().getItem(COSName.SHADING);
                String shadingID = PBFeatureParser.getId(baseShading, SHADING_ID, this.shadings.size());
                this.shadingPatternShadingChild.put(id, shadingID);
                if (this.shadingPatternParent.get(shadingID) == null) {
                    this.shadingPatternParent.put(shadingID, new HashSet());
                }
                this.shadingPatternParent.get(shadingID).add(id);
                if (!this.shadings.containsKey(shadingID) && shadingPattern.getShading() != null) {
                    this.shadings.put(shadingID, shadingPattern.getShading());
                    this.parseShading(shadingPattern.getShading(), shadingID);
                }
                COSBase baseExGState = shadingPattern.getCOSObject().getItem(COSName.EXT_G_STATE);
                String exGStateID = PBFeatureParser.getId(baseExGState, EXTGSTATE_ID, this.exGStates.size());
                this.shadingPatternExtGStateChild.put(id, exGStateID);
                if (this.exGStatePatternParent.get(exGStateID) == null) {
                    this.exGStatePatternParent.put(exGStateID, new HashSet());
                }
                this.exGStatePatternParent.get(exGStateID).add(id);
                if (this.exGStates.containsKey(exGStateID) || shadingPattern.getExtendedGraphicsState() == null) continue;
                this.exGStates.put(exGStateID, shadingPattern.getExtendedGraphicsState());
                if (shadingPattern.getExtendedGraphicsState().getFontSetting() == null) {
                    return;
                }
                String fontID = PBFeatureParser.getId(((COSArray)shadingPattern.getExtendedGraphicsState().getFontSetting().getCOSObject()).get(0), FONT_ID, this.fonts.size());
                if (this.fontExtGStateParent.get(fontID) == null) {
                    this.fontExtGStateParent.put(fontID, new HashSet());
                }
                this.fontExtGStateParent.get(fontID).add(exGStateID);
                this.exGStateFontChild.put(exGStateID, fontID);
                if (this.fonts.containsKey(fontID)) continue;
                try {
                    PDFont font = shadingPattern.getExtendedGraphicsState().getFontSetting().getFont();
                    this.fonts.put(fontID, (PDFontLike)font);
                    this.parseFont(font, fontID);
                }
                catch (IOException e) {
                    LOGGER.info((Object)e);
                    this.fontCreationProblem(fontID, e.getMessage());
                }
            }
            catch (IOException e) {
                LOGGER.info((Object)e);
                this.patternCreationProblem(id, e.getMessage());
            }
        }
    }

    private void parseShadingFromResource(PDResources resources, String parentID, Map<String, Set<String>> shadingChildMap, Map<String, Set<String>> shadingParentMap) {
        if (resources == null || resources.getShadingNames() == null) {
            return;
        }
        for (COSName name : resources.getShadingNames()) {
            COSDictionary dict = (COSDictionary)resources.getCOSObject().getDictionaryObject(COSName.SHADING);
            COSBase base = dict.getItem(name);
            String id = PBFeatureParser.getId(base, SHADING_ID, this.shadings.size());
            PBFeatureParser.makePairDependence(id, parentID, shadingParentMap, shadingChildMap);
            if (this.shadings.containsKey(id)) continue;
            try {
                PDShading shading = resources.getShading(name);
                this.parseShading(shading, id);
            }
            catch (IOException e) {
                LOGGER.info((Object)e);
                this.shadingCreationProblem(id, e.getMessage());
            }
        }
    }

    private void parseShading(PDShading shading, String parentID) {
        COSBase base = shading.getCOSObject().getItem(COSName.CS);
        if (base == null) {
            base = shading.getCOSObject().getItem(COSName.COLORSPACE);
        }
        String id = PBFeatureParser.getId(base, COLORSPACE_ID, this.colorSpaces.size());
        try {
            PDColorSpace colorSpace = shading.getColorSpace();
            id = PBFeatureParser.checkColorSpaceID(id, colorSpace);
            if (this.colorSpaceShadingParent.get(id) == null) {
                this.colorSpaceShadingParent.put(id, new HashSet());
            }
            this.colorSpaceShadingParent.get(id).add(parentID);
            this.shadingColorSpaceChild.put(parentID, id);
            if (!this.colorSpaces.containsKey(id)) {
                this.colorSpaces.put(id, colorSpace);
                this.parseColorSpace(colorSpace, id);
            }
        }
        catch (IOException e) {
            if (this.colorSpaceShadingParent.get(id) == null) {
                this.colorSpaceShadingParent.put(id, new HashSet());
            }
            this.colorSpaceShadingParent.get(id).add(parentID);
            this.shadingColorSpaceChild.put(parentID, id);
            LOGGER.info((Object)e);
            this.colorSpaceCreationProblem(id, e.getMessage());
        }
    }

    private void parseFont(PDFont font, String parentID) {
        PDType0Font type0;
        COSBase descendantFontsBase;
        if (font instanceof PDType3Font) {
            this.getResourceDictionaryDependencies(((PDType3Font)font).getResources(), parentID, this.fontExtGStateChild, this.fontColorSpaceChild, this.fontPatternChild, this.fontShadingChild, this.fontXObjectChild, this.fontFontChild, this.fontPropertiesChild, this.exGStateFontParent, this.colorSpaceFontParent, this.tilingPatternFontParent, this.shadingPatternFontParent, this.shadingFontParent, this.imageXObjectFontParent, this.formXObjectFontParent, this.postscriptFontParent, this.fontFontParent, this.propertyFontParent);
        } else if (font instanceof PDType0Font && (descendantFontsBase = (type0 = (PDType0Font)font).getCOSObject().getDictionaryObject(COSName.DESCENDANT_FONTS)) instanceof COSArray) {
            COSBase descendantFontDictionaryBase = ((COSArray)descendantFontsBase).getObject(0);
            String id = PBFeatureParser.getId(descendantFontDictionaryBase, FONT_ID, this.fonts.size());
            PBFeatureParser.makePairDependence(id, parentID, this.fontFontParent, this.fontFontChild);
            if (!this.fonts.containsKey(id)) {
                this.fonts.put(id, (PDFontLike)type0.getDescendantFont());
            }
        }
    }

    private void parseColorSpace(PDColorSpace colorSpace, String parentID) {
        if (colorSpace instanceof PDICCBased) {
            PDICCBased iccBased = (PDICCBased)colorSpace;
            COSArray array = (COSArray)iccBased.getCOSObject();
            COSBase base = array.get(1);
            String id = PBFeatureParser.getId(base, ICCPROFILE, this.iccProfiles.size());
            if (this.iccProfileICCBased.get(id) == null) {
                this.iccProfileICCBased.put(id, new HashSet());
            }
            this.iccProfileICCBased.get(id).add(parentID);
            this.colorSpaceIccProfileChild.put(parentID, id);
            if (!this.iccProfiles.containsKey(id)) {
                this.iccProfiles.put(id, iccBased.getPDStream().getStream());
            }
            COSBase baseAlt = iccBased.getPDStream().getStream().getItem(COSName.ALTERNATE);
            String idAlt = PBFeatureParser.getId(baseAlt, COLORSPACE_ID, this.colorSpaces.size());
            try {
                PDColorSpace altclr = iccBased.getAlternateColorSpace();
                idAlt = PBFeatureParser.checkColorSpaceID(idAlt, altclr);
                if (this.colorSpaceColorSpaceParent.get(idAlt) == null) {
                    this.colorSpaceColorSpaceParent.put(idAlt, new HashSet());
                }
                this.colorSpaceColorSpaceParent.get(idAlt).add(parentID);
                this.colorSpaceColorSpaceChild.put(parentID, idAlt);
                if (!this.colorSpaces.containsKey(idAlt)) {
                    this.colorSpaces.put(idAlt, iccBased.getAlternateColorSpace());
                    this.parseColorSpace(iccBased.getAlternateColorSpace(), idAlt);
                }
            }
            catch (IOException e) {
                LOGGER.info((Object)e);
                this.colorSpaceCreationProblem(idAlt, e.getMessage());
            }
        } else if (colorSpace instanceof PDIndexed || colorSpace instanceof PDSeparation || colorSpace instanceof PDDeviceN) {
            int number = colorSpace instanceof PDIndexed ? 1 : 2;
            COSArray array = (COSArray)colorSpace.getCOSObject();
            COSBase base = array.get(number);
            String id = PBFeatureParser.getId(base, COLORSPACE_ID, this.colorSpaces.size());
            try {
                PDColorSpace alt = colorSpace instanceof PDIndexed ? ((PDIndexed)colorSpace).getBaseColorSpace() : (colorSpace instanceof PDSeparation ? ((PDSeparation)colorSpace).getAlternateColorSpace() : ((PDDeviceN)colorSpace).getAlternateColorSpace());
                id = PBFeatureParser.checkColorSpaceID(id, alt);
                if (this.colorSpaceColorSpaceParent.get(id) == null) {
                    this.colorSpaceColorSpaceParent.put(id, new HashSet());
                }
                this.colorSpaceColorSpaceParent.get(id).add(parentID);
                this.colorSpaceColorSpaceChild.put(parentID, id);
                if (!this.colorSpaces.containsKey(id)) {
                    this.colorSpaces.put(id, alt);
                    this.parseColorSpace(alt, id);
                }
            }
            catch (IOException e) {
                LOGGER.info((Object)e);
                this.colorSpaceCreationProblem(id, e.getMessage());
            }
        }
    }

    private static String checkColorSpaceID(String prevID, PDColorSpace colorSpace) {
        String id = colorSpace instanceof PDDeviceGray ? DEVICEGRAY_ID : (colorSpace instanceof PDDeviceRGB ? DEVICERGB_ID : (colorSpace instanceof PDDeviceCMYK ? DEVICECMYK_ID : prevID));
        return id;
    }

    private static void makePairDependence(String childID, String parentID, Map<String, Set<String>> childParentMap, Map<String, Set<String>> parentChildMap) {
        if (parentChildMap.get(parentID) == null) {
            parentChildMap.put(parentID, new HashSet());
        }
        parentChildMap.get(parentID).add(childID);
        if (childParentMap.get(childID) == null) {
            childParentMap.put(childID, new HashSet());
        }
        childParentMap.get(childID).add(parentID);
    }

    private static COSBase getBase(COSBase base) {
        COSBase item = base;
        while (item instanceof COSObject) {
            item = ((COSObject)item).getObject();
        }
        return item;
    }

    private static String getId(COSBase base, String prefix, long number) {
        long numb = number;
        COSBase item = base;
        String type = "Dir";
        while (item instanceof COSObject) {
            numb = ((COSObject)item).getObjectNumber();
            type = "Indir";
            item = ((COSObject)item).getObject();
        }
        return prefix + type + numb;
    }
}

