/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.util.Set;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBExtGStateFeaturesObject
implements IFeaturesObject {
    private static final String ID = "id";
    private PDExtendedGraphicsState exGState;
    private String id;
    private String fontChildID;
    private Set<String> pageParentsID;
    private Set<String> patternParentsID;
    private Set<String> xobjectParentsID;
    private Set<String> fontParentsID;

    public PBExtGStateFeaturesObject(PDExtendedGraphicsState exGState, String id, String fontChildID, Set<String> pageParentsID, Set<String> patternParentsID, Set<String> xobjectParentsID, Set<String> fontParentsID) {
        this.exGState = exGState;
        this.id = id;
        this.fontChildID = fontChildID;
        this.pageParentsID = pageParentsID;
        this.patternParentsID = patternParentsID;
        this.xobjectParentsID = xobjectParentsID;
        this.fontParentsID = fontParentsID;
    }

    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.EXT_G_STATE;
    }

    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeatureParsingException {
        if (this.exGState != null) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode((String)"graphicsState");
            root.setAttribute(ID, this.id);
            this.parseParents(root);
            FeatureTreeNode.createChildNode((String)"transparency", (FeatureTreeNode)root).setValue(String.valueOf(!this.exGState.getAlphaSourceFlag()));
            FeatureTreeNode.createChildNode((String)"strokeAdjustment", (FeatureTreeNode)root).setValue(String.valueOf(this.exGState.getAutomaticStrokeAdjustment()));
            FeatureTreeNode.createChildNode((String)"overprintForStroke", (FeatureTreeNode)root).setValue(String.valueOf(this.exGState.getStrokingOverprintControl()));
            FeatureTreeNode.createChildNode((String)"overprintForFill", (FeatureTreeNode)root).setValue(String.valueOf(this.exGState.getNonStrokingOverprintControl()));
            if (this.fontChildID != null) {
                FeatureTreeNode resources = FeatureTreeNode.createChildNode((String)"resources", (FeatureTreeNode)root);
                FeatureTreeNode fonts = FeatureTreeNode.createChildNode((String)"fonts", (FeatureTreeNode)resources);
                FeatureTreeNode font = FeatureTreeNode.createChildNode((String)"font", (FeatureTreeNode)fonts);
                font.setAttribute(ID, this.fontChildID);
            }
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.EXT_G_STATE, root);
            return root;
        }
        return null;
    }

    public FeaturesData getData() {
        return null;
    }

    private void parseParents(FeatureTreeNode root) throws FeatureParsingException {
        if (this.pageParentsID != null && !this.pageParentsID.isEmpty() || this.patternParentsID != null && !this.patternParentsID.isEmpty() || this.xobjectParentsID != null && !this.xobjectParentsID.isEmpty() || this.fontParentsID != null && !this.fontParentsID.isEmpty()) {
            FeatureTreeNode parents = FeatureTreeNode.createChildNode((String)"parents", (FeatureTreeNode)root);
            PBCreateNodeHelper.parseIDSet(this.pageParentsID, "page", null, parents);
            PBCreateNodeHelper.parseIDSet(this.patternParentsID, "pattern", null, parents);
            PBCreateNodeHelper.parseIDSet(this.xobjectParentsID, "xobject", null, parents);
            PBCreateNodeHelper.parseIDSet(this.fontParentsID, "font", null, parents);
        }
    }
}

