/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDCIDFont;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDFontLike;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.FontFeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBFontFeaturesObject
implements IFeaturesObject {
    private static final Logger LOGGER = Logger.getLogger(PBFontFeaturesObject.class);
    private static final String ID = "id";
    private PDFontLike fontLike;
    private String id;
    private Set<String> extGStateChild;
    private Set<String> colorSpaceChild;
    private Set<String> patternChild;
    private Set<String> shadingChild;
    private Set<String> xobjectChild;
    private Set<String> fontChild;
    private Set<String> propertiesChild;
    private Set<String> extGStateParent;
    private Set<String> pageParent;
    private Set<String> patternParent;
    private Set<String> xobjectParent;
    private Set<String> fontParent;

    public PBFontFeaturesObject(PDFontLike fontLike, String id, Set<String> extGStateChild, Set<String> colorSpaceChild, Set<String> patternChild, Set<String> shadingChild, Set<String> xobjectChild, Set<String> fontChild, Set<String> propertiesChild, Set<String> extGStateParent, Set<String> pageParent, Set<String> patternParent, Set<String> xobjectParent, Set<String> fontParent) {
        this.fontLike = fontLike;
        this.id = id;
        this.extGStateChild = extGStateChild;
        this.colorSpaceChild = colorSpaceChild;
        this.patternChild = patternChild;
        this.shadingChild = shadingChild;
        this.xobjectChild = xobjectChild;
        this.fontChild = fontChild;
        this.propertiesChild = propertiesChild;
        this.extGStateParent = extGStateParent;
        this.pageParent = pageParent;
        this.patternParent = patternParent;
        this.xobjectParent = xobjectParent;
        this.fontParent = fontParent;
    }

    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.FONT;
    }

    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeatureParsingException {
        if (this.fontLike != null) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode((String)"font");
            root.setAttribute(ID, this.id);
            this.parseParents(root);
            if (this.fontLike instanceof PDFont) {
                PDFont font = (PDFont)this.fontLike;
                PBCreateNodeHelper.addNotEmptyNode("type", font.getSubType(), root);
                if (!(font instanceof PDType3Font)) {
                    PBCreateNodeHelper.addNotEmptyNode("baseFont", font.getName(), root);
                }
                if (font instanceof PDType0Font) {
                    PBCreateNodeHelper.parseIDSet(this.fontChild, "descendantFont", null, FeatureTreeNode.createChildNode((String)"descendantFonts", (FeatureTreeNode)root));
                    PBFontFeaturesObject.parseFontDescriptior(this.fontLike.getFontDescriptor(), root, collection);
                } else if (font instanceof PDSimpleFont) {
                    COSBase name;
                    int lc;
                    PDSimpleFont sFont = (PDSimpleFont)font;
                    int fc = sFont.getCOSObject().getInt(COSName.FIRST_CHAR);
                    if (fc != -1) {
                        FeatureTreeNode.createChildNode((String)"firstChar", (FeatureTreeNode)root).setValue(String.valueOf(fc));
                    }
                    if ((lc = sFont.getCOSObject().getInt(COSName.LAST_CHAR)) != -1) {
                        FeatureTreeNode.createChildNode((String)"lastChar", (FeatureTreeNode)root).setValue(String.valueOf(lc));
                    }
                    PBFontFeaturesObject.parseWidths(sFont.getWidths(), fc, FeatureTreeNode.createChildNode((String)"widths", (FeatureTreeNode)root));
                    COSBase enc = sFont.getCOSObject().getDictionaryObject(COSName.ENCODING);
                    if (enc instanceof COSName) {
                        PBCreateNodeHelper.addNotEmptyNode("encoding", ((COSName)enc).getName(), root);
                    } else if (enc instanceof COSDictionary && (name = ((COSDictionary)enc).getDictionaryObject(COSName.BASE_ENCODING)) instanceof COSName) {
                        PBCreateNodeHelper.addNotEmptyNode("encoding", ((COSName)name).getName(), root);
                    }
                    PBFontFeaturesObject.parseFontDescriptior(this.fontLike.getFontDescriptor(), root, collection);
                    if (sFont instanceof PDType3Font) {
                        PDType3Font type3 = (PDType3Font)sFont;
                        PBCreateNodeHelper.addBoxFeature("fontBBox", type3.getFontBBox(), root);
                        PBFontFeaturesObject.parseFloatMatrix(type3.getFontMatrix().getValues(), FeatureTreeNode.createChildNode((String)"fontMatrix", (FeatureTreeNode)root));
                        this.parseResources(root);
                    }
                }
            } else if (this.fontLike instanceof PDCIDFont) {
                PDCIDFont cid = (PDCIDFont)this.fontLike;
                PBCreateNodeHelper.addNotEmptyNode("type", cid.getCOSObject().getNameAsString(COSName.SUBTYPE), root);
                PBCreateNodeHelper.addNotEmptyNode("baseFont", cid.getBaseFont(), root);
                COSBase dw = cid.getCOSObject().getDictionaryObject(COSName.DW);
                if (dw instanceof COSInteger) {
                    FeatureTreeNode.createChildNode((String)"defaultWidth", (FeatureTreeNode)root).setValue(String.valueOf(((COSNumber)dw).intValue()));
                }
                if (cid.getCIDSystemInfo() != null) {
                    FeatureTreeNode cidS = FeatureTreeNode.createChildNode((String)"cidSystemInfo", (FeatureTreeNode)root);
                    PBCreateNodeHelper.addNotEmptyNode("registry", cid.getCIDSystemInfo().getRegistry(), cidS);
                    PBCreateNodeHelper.addNotEmptyNode("ordering", cid.getCIDSystemInfo().getOrdering(), cidS);
                    FeatureTreeNode.createChildNode((String)"supplement", (FeatureTreeNode)cidS).setValue(String.valueOf(cid.getCIDSystemInfo().getSupplement()));
                }
                PBFontFeaturesObject.parseFontDescriptior(this.fontLike.getFontDescriptor(), root, collection);
            }
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.FONT, root);
            return root;
        }
        return null;
    }

    public FeaturesData getData() {
        PDFontDescriptor descriptor = this.fontLike.getFontDescriptor();
        if (descriptor != null) {
            PDStream file = descriptor.getFontFile();
            if (file == null) {
                file = descriptor.getFontFile2();
            }
            if (file == null) {
                file = descriptor.getFontFile3();
            }
            if (file != null) {
                try {
                    PDRectangle rex;
                    byte[] stream = PBCreateNodeHelper.inputStreamToByteArray(file.getStream().getUnfilteredStream());
                    FontFeaturesData.Builder builder = new FontFeaturesData.Builder(stream);
                    byte[] metadata = null;
                    if (file.getMetadata() != null) {
                        try {
                            metadata = PBCreateNodeHelper.inputStreamToByteArray(file.getMetadata().getStream().getUnfilteredStream());
                        }
                        catch (IOException e) {
                            LOGGER.debug((Object)"Can not get metadata stream for font file", (Throwable)e);
                        }
                    }
                    builder.metadata(metadata);
                    builder.fontName(descriptor.getFontName());
                    builder.fontFamily(descriptor.getFontFamily());
                    builder.fontStretch(descriptor.getFontStretch());
                    COSDictionary descriptorDict = descriptor.getCOSObject();
                    builder.fontWeight(PBFontFeaturesObject.getNumber(descriptorDict.getDictionaryObject(COSName.FONT_WEIGHT)));
                    COSBase fl = descriptorDict.getDictionaryObject(COSName.FLAGS);
                    if (fl instanceof COSInteger) {
                        builder.flags(Integer.valueOf(((COSInteger)fl).intValue()));
                    }
                    if ((rex = descriptor.getFontBoundingBox()) != null) {
                        ArrayList<Double> rect = new ArrayList<Double>();
                        rect.add(Double.valueOf(rex.getLowerLeftX()));
                        rect.add(Double.valueOf(rex.getLowerLeftY()));
                        rect.add(Double.valueOf(rex.getUpperRightX()));
                        rect.add(Double.valueOf(rex.getUpperRightY()));
                        builder.fontBBox(rect);
                    }
                    builder.italicAngle(PBFontFeaturesObject.getNumber(descriptorDict.getDictionaryObject(COSName.ITALIC_ANGLE)));
                    builder.ascent(PBFontFeaturesObject.getNumber(descriptorDict.getDictionaryObject(COSName.ASCENT)));
                    builder.descent(PBFontFeaturesObject.getNumber(descriptorDict.getDictionaryObject(COSName.DESCENT)));
                    builder.leading(PBFontFeaturesObject.getNumber(descriptorDict.getDictionaryObject(COSName.LEADING)));
                    builder.capHeight(PBFontFeaturesObject.getNumber(descriptorDict.getDictionaryObject(COSName.CAP_HEIGHT)));
                    builder.xHeight(PBFontFeaturesObject.getNumber(descriptorDict.getDictionaryObject(COSName.XHEIGHT)));
                    builder.stemV(PBFontFeaturesObject.getNumber(descriptorDict.getDictionaryObject(COSName.STEM_V)));
                    builder.stemH(PBFontFeaturesObject.getNumber(descriptorDict.getDictionaryObject(COSName.STEM_H)));
                    builder.avgWidth(PBFontFeaturesObject.getNumber(descriptorDict.getDictionaryObject(COSName.AVG_WIDTH)));
                    builder.maxWidth(PBFontFeaturesObject.getNumber(descriptorDict.getDictionaryObject(COSName.MAX_WIDTH)));
                    builder.missingWidth(PBFontFeaturesObject.getNumber(descriptorDict.getDictionaryObject(COSName.MISSING_WIDTH)));
                    builder.charSet(descriptor.getCharSet());
                    return builder.build();
                }
                catch (IOException e) {
                    LOGGER.debug((Object)"Error in obtaining features data for fonts", (Throwable)e);
                }
            }
        }
        return null;
    }

    private static Double getNumber(Object value) {
        if (value instanceof COSNumber) {
            return ((COSNumber)value).doubleValue();
        }
        return null;
    }

    private static void putIfNotNull(Map<String, Object> map, String key, Object value) {
        if (key != null && value != null) {
            map.put(key, value);
        }
    }

    private static void parseFontDescriptior(PDFontDescriptor descriptor, FeatureTreeNode root, FeaturesCollection collection) throws FeatureParsingException {
        if (descriptor != null) {
            FeatureTreeNode descriptorNode = FeatureTreeNode.createChildNode((String)"fontDescriptor", (FeatureTreeNode)root);
            PBCreateNodeHelper.addNotEmptyNode("fontName", descriptor.getFontName(), descriptorNode);
            PBCreateNodeHelper.addNotEmptyNode("fontFamily", descriptor.getFontFamily(), descriptorNode);
            PBCreateNodeHelper.addNotEmptyNode("fontStretch", descriptor.getFontStretch(), descriptorNode);
            FeatureTreeNode.createChildNode((String)"fontWeight", (FeatureTreeNode)descriptorNode).setValue(String.valueOf(descriptor.getFontWeight()));
            FeatureTreeNode.createChildNode((String)"fixedPitch", (FeatureTreeNode)descriptorNode).setValue(String.valueOf(descriptor.isFixedPitch()));
            FeatureTreeNode.createChildNode((String)"serif", (FeatureTreeNode)descriptorNode).setValue(String.valueOf(descriptor.isSerif()));
            FeatureTreeNode.createChildNode((String)"symbolic", (FeatureTreeNode)descriptorNode).setValue(String.valueOf(descriptor.isSymbolic()));
            FeatureTreeNode.createChildNode((String)"script", (FeatureTreeNode)descriptorNode).setValue(String.valueOf(descriptor.isScript()));
            FeatureTreeNode.createChildNode((String)"nonsymbolic", (FeatureTreeNode)descriptorNode).setValue(String.valueOf(descriptor.isNonSymbolic()));
            FeatureTreeNode.createChildNode((String)"italic", (FeatureTreeNode)descriptorNode).setValue(String.valueOf(descriptor.isItalic()));
            FeatureTreeNode.createChildNode((String)"allCap", (FeatureTreeNode)descriptorNode).setValue(String.valueOf(descriptor.isAllCap()));
            FeatureTreeNode.createChildNode((String)"smallCap", (FeatureTreeNode)descriptorNode).setValue(String.valueOf(descriptor.isScript()));
            FeatureTreeNode.createChildNode((String)"forceBold", (FeatureTreeNode)descriptorNode).setValue(String.valueOf(descriptor.isForceBold()));
            PBCreateNodeHelper.addBoxFeature("fontBBox", descriptor.getFontBoundingBox(), descriptorNode);
            FeatureTreeNode.createChildNode((String)"italicAngle", (FeatureTreeNode)descriptorNode).setValue(String.valueOf(descriptor.getItalicAngle()));
            FeatureTreeNode.createChildNode((String)"ascent", (FeatureTreeNode)descriptorNode).setValue(String.valueOf(descriptor.getAscent()));
            FeatureTreeNode.createChildNode((String)"descent", (FeatureTreeNode)descriptorNode).setValue(String.valueOf(descriptor.getDescent()));
            FeatureTreeNode.createChildNode((String)"leading", (FeatureTreeNode)descriptorNode).setValue(String.valueOf(descriptor.getLeading()));
            FeatureTreeNode.createChildNode((String)"capHeight", (FeatureTreeNode)descriptorNode).setValue(String.valueOf(descriptor.getCapHeight()));
            FeatureTreeNode.createChildNode((String)"xHeight", (FeatureTreeNode)descriptorNode).setValue(String.valueOf(descriptor.getXHeight()));
            FeatureTreeNode.createChildNode((String)"stemV", (FeatureTreeNode)descriptorNode).setValue(String.valueOf(descriptor.getStemV()));
            FeatureTreeNode.createChildNode((String)"stemH", (FeatureTreeNode)descriptorNode).setValue(String.valueOf(descriptor.getStemH()));
            FeatureTreeNode.createChildNode((String)"averageWidth", (FeatureTreeNode)descriptorNode).setValue(String.valueOf(descriptor.getAverageWidth()));
            FeatureTreeNode.createChildNode((String)"maxWidth", (FeatureTreeNode)descriptorNode).setValue(String.valueOf(descriptor.getMaxWidth()));
            FeatureTreeNode.createChildNode((String)"missingWidth", (FeatureTreeNode)descriptorNode).setValue(String.valueOf(descriptor.getMissingWidth()));
            PBCreateNodeHelper.addNotEmptyNode("charSet", descriptor.getCharSet(), descriptorNode);
            PDStream file = descriptor.getFontFile();
            if (file == null) {
                file = descriptor.getFontFile2();
            }
            if (file == null) {
                file = descriptor.getFontFile3();
            }
            FeatureTreeNode.createChildNode((String)"embedded", (FeatureTreeNode)descriptorNode).setValue(String.valueOf(file != null));
            if (file != null) {
                PBCreateNodeHelper.parseMetadata(file.getMetadata(), "embeddedFileMetadata", descriptorNode, collection);
            }
        }
    }

    private static void parseFloatMatrix(float[][] array, FeatureTreeNode parent) throws FeatureParsingException {
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array.length - 1; ++j) {
                FeatureTreeNode element = FeatureTreeNode.createChildNode((String)"element", (FeatureTreeNode)parent);
                element.setAttribute("row", String.valueOf(i));
                element.setAttribute("column", String.valueOf(j));
                element.setAttribute("value", String.valueOf(array[i][j]));
            }
        }
    }

    private static void parseWidths(List<Integer> array, int firstChar, FeatureTreeNode parent) throws FeatureParsingException {
        int fc = firstChar == -1 ? 0 : firstChar;
        for (int i = 0; i < array.size(); ++i) {
            FeatureTreeNode element = FeatureTreeNode.createChildNode((String)"width", (FeatureTreeNode)parent);
            element.setValue(String.valueOf(array.get(i)));
            element.setAttribute("char", String.valueOf(i + fc));
        }
    }

    private void parseParents(FeatureTreeNode root) throws FeatureParsingException {
        if (this.pageParent != null && !this.pageParent.isEmpty() || this.extGStateParent != null && !this.extGStateParent.isEmpty() || this.patternParent != null && !this.patternParent.isEmpty() || this.xobjectParent != null && !this.xobjectParent.isEmpty() || this.fontParent != null && !this.fontParent.isEmpty()) {
            FeatureTreeNode parents = FeatureTreeNode.createChildNode((String)"parents", (FeatureTreeNode)root);
            PBCreateNodeHelper.parseIDSet(this.pageParent, "page", null, parents);
            PBCreateNodeHelper.parseIDSet(this.extGStateParent, "graphicsState", null, parents);
            PBCreateNodeHelper.parseIDSet(this.patternParent, "pattern", null, parents);
            PBCreateNodeHelper.parseIDSet(this.xobjectParent, "xobject", null, parents);
            PBCreateNodeHelper.parseIDSet(this.fontParent, "font", null, parents);
        }
    }

    private void parseResources(FeatureTreeNode root) throws FeatureParsingException {
        if (this.extGStateChild != null && !this.extGStateChild.isEmpty() || this.colorSpaceChild != null && !this.colorSpaceChild.isEmpty() || this.patternChild != null && !this.patternChild.isEmpty() || this.shadingChild != null && !this.shadingChild.isEmpty() || this.xobjectChild != null && !this.xobjectChild.isEmpty() || this.fontChild != null && !this.fontChild.isEmpty() || this.propertiesChild != null && !this.propertiesChild.isEmpty()) {
            FeatureTreeNode resources = FeatureTreeNode.createChildNode((String)"resources", (FeatureTreeNode)root);
            PBCreateNodeHelper.parseIDSet(this.extGStateChild, "graphicsState", "graphicsStates", resources);
            PBCreateNodeHelper.parseIDSet(this.colorSpaceChild, "colorSpace", "colorSpaces", resources);
            PBCreateNodeHelper.parseIDSet(this.patternChild, "pattern", "patterns", resources);
            PBCreateNodeHelper.parseIDSet(this.shadingChild, "shading", "shadings", resources);
            PBCreateNodeHelper.parseIDSet(this.xobjectChild, "xobject", "xobjects", resources);
            PBCreateNodeHelper.parseIDSet(this.fontChild, "font", "fonts", resources);
            PBCreateNodeHelper.parseIDSet(this.propertiesChild, "propertiesDict", "propertiesDicts", resources);
        }
    }
}

