/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.util.Arrays;
import java.util.TreeSet;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBInfoDictFeaturesObject
implements IFeaturesObject {
    private static final String[] predefinedKeys = new String[]{"Title", "Author", "Subject", "Keywords", "Creator", "Producer", "CreationDate", "ModDate", "Trapped"};
    private static final String ENTRY = "entry";
    private static final String KEY = "key";
    private PDDocumentInformation info;

    public PBInfoDictFeaturesObject(PDDocumentInformation info) {
        this.info = info;
    }

    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.INFORMATION_DICTIONARY;
    }

    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeatureParsingException {
        if (this.info != null) {
            FeatureTreeNode modificationDate;
            FeatureTreeNode root = FeatureTreeNode.createRootNode((String)"informationDict");
            PBInfoDictFeaturesObject.addEntry("Title", this.info.getTitle(), root);
            PBInfoDictFeaturesObject.addEntry("Author", this.info.getAuthor(), root);
            PBInfoDictFeaturesObject.addEntry("Subject", this.info.getSubject(), root);
            PBInfoDictFeaturesObject.addEntry("Keywords", this.info.getKeywords(), root);
            PBInfoDictFeaturesObject.addEntry("Creator", this.info.getCreator(), root);
            PBInfoDictFeaturesObject.addEntry("Producer", this.info.getProducer(), root);
            FeatureTreeNode creationDate = PBCreateNodeHelper.createDateNode(ENTRY, root, this.info.getCreationDate(), collection);
            if (creationDate != null) {
                creationDate.setAttribute(KEY, "CreationDate");
            }
            if ((modificationDate = PBCreateNodeHelper.createDateNode(ENTRY, root, this.info.getModificationDate(), collection)) != null) {
                modificationDate.setAttribute(KEY, "ModDate");
            }
            PBInfoDictFeaturesObject.addEntry("Trapped", this.info.getTrapped(), root);
            if (this.info.getMetadataKeys() != null) {
                TreeSet keys = new TreeSet(this.info.getMetadataKeys());
                keys.removeAll(Arrays.asList(predefinedKeys));
                for (String key : keys) {
                    PBInfoDictFeaturesObject.addEntry(key, this.info.getCustomMetadataValue(key), root);
                }
            }
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.INFORMATION_DICTIONARY, root);
            return root;
        }
        return null;
    }

    public FeaturesData getData() {
        return null;
    }

    private static void addEntry(String name, String value, FeatureTreeNode root) throws FeatureParsingException {
        if (name != null && value != null) {
            FeatureTreeNode entry = FeatureTreeNode.createChildNode((String)ENTRY, (FeatureTreeNode)root);
            entry.setValue(value);
            entry.setAttribute(KEY, name);
        }
    }
}

