/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.objects.PBEmbeddedFileFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBLowLvlInfoFeaturesObject
implements IFeaturesObject {
    private static final Logger LOGGER = Logger.getLogger(PBEmbeddedFileFeaturesObject.class);
    private COSDocument document;
    private static final Map<String, String> filtersAbbreviations;

    public PBLowLvlInfoFeaturesObject(COSDocument document) {
        this.document = document;
    }

    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.LOW_LEVEL_INFO;
    }

    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeatureParsingException {
        if (this.document != null) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode((String)"lowLevelInfo");
            if (this.document.getObjects() != null) {
                FeatureTreeNode.createChildNode((String)"indirectObjectsNumber", (FeatureTreeNode)root).setValue(String.valueOf(this.document.getObjects().size()));
            }
            this.addDocumentId(root, collection);
            Set<String> filters = this.getAllFilters();
            if (!filters.isEmpty()) {
                FeatureTreeNode filtersNode = FeatureTreeNode.createChildNode((String)"filters", (FeatureTreeNode)root);
                for (String filter : filters) {
                    if (filter == null) continue;
                    FeatureTreeNode filterNode = FeatureTreeNode.createChildNode((String)"filter", (FeatureTreeNode)filtersNode);
                    filterNode.setAttribute("name", filter);
                }
            }
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.LOW_LEVEL_INFO, root);
            return root;
        }
        return null;
    }

    public FeaturesData getData() {
        return null;
    }

    private Set<String> getAllFilters() {
        HashSet<String> res = new HashSet<String>();
        for (COSBase base : this.document.getObjects()) {
            COSStream stream;
            COSBase baseFilter;
            while (base instanceof COSObject) {
                base = ((COSObject)base).getObject();
            }
            if (!(base instanceof COSStream) || (baseFilter = (stream = (COSStream)base).getFilters()) == null) continue;
            PBLowLvlInfoFeaturesObject.addFiltersFromBase(res, baseFilter);
        }
        return res;
    }

    private void addDocumentId(FeatureTreeNode root, FeaturesCollection collection) throws FeatureParsingException {
        COSArray ids = this.document.getDocumentID();
        if (ids != null) {
            String creationId = PBCreateNodeHelper.getStringFromBase(ids.get(0));
            String modificationId = PBCreateNodeHelper.getStringFromBase(ids.get(1));
            FeatureTreeNode documentId = FeatureTreeNode.createChildNode((String)"documentId", (FeatureTreeNode)root);
            if (creationId != null || modificationId != null) {
                if (creationId != null) {
                    documentId.setAttribute("creationId", creationId);
                }
                if (modificationId != null) {
                    documentId.setAttribute("modificationId", modificationId);
                }
            }
            if (ids.size() != 2 || creationId == null || modificationId == null) {
                ErrorsHelper.addErrorIntoCollection((FeaturesCollection)collection, (FeatureTreeNode)documentId, (String)"Document's ID must be an array of two not null elements");
            }
        }
    }

    private static void addFiltersFromBase(Set<String> res, COSBase base) {
        if (base instanceof COSName) {
            String name = ((COSName)base).getName();
            if (filtersAbbreviations.keySet().contains(name)) {
                name = filtersAbbreviations.get(name);
            }
            res.add(name);
        } else if (base instanceof COSArray) {
            for (COSBase baseElement : (COSArray)base) {
                if (!(baseElement instanceof COSName)) continue;
                String name = ((COSName)baseElement).getName();
                if (filtersAbbreviations.keySet().contains(name)) {
                    name = filtersAbbreviations.get(name);
                }
                res.add(name);
            }
        }
    }

    static {
        HashMap<String, String> filtersAbbreviationsTemp = new HashMap<String, String>();
        filtersAbbreviationsTemp.put("AHx", "ASCIIHexDecode");
        filtersAbbreviationsTemp.put("A85", "ASCII85Decode");
        filtersAbbreviationsTemp.put("LZW", "LZWDecode");
        filtersAbbreviationsTemp.put("Fl", "FlateDecode");
        filtersAbbreviationsTemp.put("RL", "RunLengthDecode");
        filtersAbbreviationsTemp.put("CCF", "CCITTFaxDecode");
        filtersAbbreviationsTemp.put("DCT", "DCTDecode");
        filtersAbbreviations = Collections.unmodifiableMap(filtersAbbreviationsTemp);
    }
}

