/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBOutputIntentsFeaturesObject
implements IFeaturesObject {
    private PDOutputIntent outInt;
    private String id;
    private String iccProfileID;

    public PBOutputIntentsFeaturesObject(PDOutputIntent outInt, String id, String iccProfileID) {
        this.outInt = outInt;
        this.id = id;
        this.iccProfileID = iccProfileID;
    }

    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.OUTPUTINTENT;
    }

    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeatureParsingException {
        if (this.outInt != null) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode((String)"outputIntent");
            root.setAttribute("id", this.id);
            this.addSubtype(collection, root);
            PBCreateNodeHelper.addNotEmptyNode("outputCondition", this.outInt.getOutputCondition(), root);
            PBCreateNodeHelper.addNotEmptyNode("outputConditionIdentifier", this.outInt.getOutputConditionIdentifier(), root);
            PBCreateNodeHelper.addNotEmptyNode("registryName", this.outInt.getRegistryName(), root);
            PBCreateNodeHelper.addNotEmptyNode("info", this.outInt.getInfo(), root);
            FeatureTreeNode destOutInt = FeatureTreeNode.createChildNode((String)"destOutputIntent", (FeatureTreeNode)root);
            destOutInt.setAttribute("id", this.iccProfileID);
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.OUTPUTINTENT, root);
            return root;
        }
        return null;
    }

    public FeaturesData getData() {
        return null;
    }

    private void addSubtype(FeaturesCollection collection, FeatureTreeNode root) throws FeatureParsingException {
        COSBase base = this.outInt.getCOSObject();
        if (base instanceof COSDictionary) {
            COSDictionary dict = (COSDictionary)base;
            COSBase baseType = dict.getDictionaryObject(COSName.S);
            while (baseType instanceof COSObject) {
                baseType = ((COSObject)baseType).getObject();
            }
            if (baseType != null) {
                FeatureTreeNode type = FeatureTreeNode.createChildNode((String)"subtype", (FeatureTreeNode)root);
                if (baseType instanceof COSName) {
                    type.setValue(((COSName)baseType).getName());
                } else {
                    ErrorsHelper.addErrorIntoCollection((FeaturesCollection)collection, (FeatureTreeNode)type, (String)"Subtype is not of Name type");
                }
            }
        }
    }
}

