/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDNameTreeNode;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.documentinterchange.markedcontent.PDPropertyList;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontLike;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.apache.pdfbox.pdmodel.graphics.PDPostScriptXObject;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.color.PDIndexed;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDGroup;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObjectProxy;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDShadingPattern;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceEntry;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeaturesExtractor;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.FeaturesReporter;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.config.FeaturesConfig;
import org.verapdf.features.pb.PBFeaturesObjectCreator;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public final class PBFeatureParser {
    private static final Logger LOGGER = Logger.getLogger(PBFeatureParser.class);
    private static final String ICCPROFILE = "iccProfile";
    private static final String ID = "id";
    private static final String ANNOTATION = "annotation";
    private static final String ANNOT = "annot";
    private static final String EMBEDDEDFILE = "embeddedFile";
    private static final String FONT = "font";
    private static final String SHADING = "shading";
    private static final String XOBJECT = "xobject";
    private static final String PATTERN = "pattern";
    private static final String COLORSPACE = "colorSpace";
    private static final String EXTGSTATE_ID = "exGSt";
    private static final String COLORSPACE_ID = "clrsp";
    private static final String PATTERN_ID = "ptrn";
    private static final String SHADING_ID = "shdng";
    private static final String XOBJECT_ID = "xobj";
    private static final String FONT_ID = "fnt";
    private static final String PROPERTIES_ID = "prop";
    private static final String DEVICEGRAY_ID = "devgray";
    private static final String DEVICERGB_ID = "devrgb";
    private static final String DEVICECMYK_ID = "devcmyk";
    private FeaturesReporter reporter;
    private FeaturesConfig config;
    private Set<String> processedIDs;

    private PBFeatureParser(FeaturesReporter reporter, FeaturesConfig config) {
        this.reporter = reporter;
        this.config = config;
        this.processedIDs = new HashSet<String>();
    }

    public static FeaturesCollection getFeaturesCollection(PDDocument document, FeaturesConfig config) {
        FeaturesReporter reporter = new FeaturesReporter(config);
        return PBFeatureParser.getFeatures(document, reporter, config);
    }

    public static FeaturesCollection getFeaturesCollection(PDDocument document, List<FeaturesExtractor> extractors, FeaturesConfig config) {
        FeaturesReporter reporter = new FeaturesReporter(config, extractors);
        return PBFeatureParser.getFeatures(document, reporter, config);
    }

    private static FeaturesCollection getFeatures(PDDocument document, FeaturesReporter reporter, FeaturesConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Features config can not be null");
        }
        if (document != null) {
            PBFeatureParser parser = new PBFeatureParser(reporter, config);
            parser.parseDocumentFeatures(document);
        }
        return reporter.getCollection();
    }

    private void parseDocumentFeatures(PDDocument document) {
        this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createInfoDictFeaturesObject(document.getDocumentInformation()));
        this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createDocSecurityFeaturesObject(document.getEncryption()));
        PDDocumentCatalog catalog = document.getDocumentCatalog();
        if (catalog != null) {
            this.getCatalogFeatures(catalog);
        }
        this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createLowLvlInfoFeaturesObject(document.getDocument()));
    }

    private void getCatalogFeatures(PDDocumentCatalog catalog) {
        PDPageTree pageTree;
        this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createMetadataFeaturesObject(catalog.getMetadata()));
        this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createOutlinesFeaturesObject(catalog.getDocumentOutline()));
        PDAcroForm acroForm = catalog.getAcroForm();
        if (acroForm != null) {
            this.getAcroFormFeatures(acroForm);
        }
        if (catalog.getNames() != null && catalog.getNames().getEmbeddedFiles() != null) {
            this.reportEmbeddedFiles(catalog);
        }
        if (catalog.getOutputIntents() != null) {
            for (PDOutputIntent outInt : catalog.getOutputIntents()) {
                String iccProfileID = this.addICCProfileFromOutputIntent(outInt);
                if (!this.config.isIccProfilesEnabled()) {
                    iccProfileID = null;
                }
                this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createOutputIntentFeaturesObject(outInt, iccProfileID));
            }
        }
        if ((pageTree = catalog.getPages()) != null) {
            this.getPageTreeFeatures(pageTree);
        }
    }

    private void getAcroFormFeatures(PDAcroForm acroForm) {
        List fields = acroForm.getFields();
        if (fields != null) {
            for (PDField field : fields) {
                this.getFieldFeatures(field);
            }
        }
    }

    private void getFieldFeatures(PDField field) {
        PDSignature signature;
        if (this.config.isSignaturesEnabled() && field instanceof PDSignatureField && (signature = ((PDSignatureField)field).getSignature()) != null) {
            this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createSignatureFeaturesObject(signature));
        }
    }

    private void getPageTreeFeatures(PDPageTree pageTree) {
        for (PDPage page : pageTree) {
            COSBase baseThumb;
            Set<String> annotsId = this.addAnnotsDependencies(page);
            annotsId = this.config.isAnnotationsEnabled() ? annotsId : null;
            String thumbID = null;
            if (page.getCOSObject().getDictionaryObject(COSName.getPDFName((String)"Thumb")) != null && this.checkIDBeforeProcess(thumbID = this.getId(baseThumb = page.getCOSObject().getItem(COSName.getPDFName((String)"Thumb")), XOBJECT_ID))) {
                COSBase base = PBFeatureParser.getBase(baseThumb);
                if (base instanceof COSStream) {
                    PDImageXObjectProxy img = new PDImageXObjectProxy(new PDStream((COSStream)base), null);
                    this.parseImageXObject(img, thumbID);
                } else {
                    this.xobjectCreationProblem(thumbID, "Thumb is not a stream");
                }
            }
            thumbID = this.config.isXobjectsEnabled() ? thumbID : null;
            PDResources resources = page.getResources();
            Set<String> extGStateChild = this.parseExGStateFromResource(resources);
            extGStateChild = this.config.isGraphicsStatesEnabled() ? extGStateChild : null;
            Set<String> colorSpaceChild = this.parseColorSpaceFromResources(resources);
            colorSpaceChild = this.config.isColorSpacesEnabled() ? colorSpaceChild : null;
            Set<String> patternChild = this.parsePatternFromResource(resources);
            patternChild = this.config.isPatternsEnabled() ? patternChild : null;
            Set<String> shadingChild = this.parseShadingFromResource(resources);
            shadingChild = this.config.isShadingsEnabled() ? shadingChild : null;
            Set<String> xobjectChild = this.parseXObjectFromResources(resources);
            xobjectChild = this.config.isXobjectsEnabled() ? xobjectChild : null;
            Set<String> fontChild = this.parseFontFromResources(resources);
            fontChild = this.config.isFontsEnabled() ? fontChild : null;
            Set<String> propertiesChild = this.parsePropertiesFromResources(resources);
            propertiesChild = this.config.isPropertiesDictsEnabled() ? propertiesChild : null;
            this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createPageFeaturesObject(page, thumbID, annotsId, extGStateChild, colorSpaceChild, patternChild, shadingChild, xobjectChild, fontChild, propertiesChild, pageTree.indexOf(page) + 1));
        }
    }

    private Set<String> addAnnotsDependencies(PDPage page) {
        COSArray annotsArray = (COSArray)page.getCOSObject().getDictionaryObject(COSName.ANNOTS);
        if (annotsArray == null) {
            return Collections.emptySet();
        }
        HashSet<String> annotsId = new HashSet<String>();
        for (int i = 0; i < annotsArray.size(); ++i) {
            COSBase item = annotsArray.get(i);
            if (item == null) continue;
            String id = this.getId(item, ANNOT);
            annotsId.add(id);
            if (!this.checkIDBeforeProcess(id)) continue;
            COSBase base = PBFeatureParser.getBase(item);
            try {
                PDAnnotation annotation = PDAnnotation.createAnnotation((COSBase)base);
                COSBase pop = annotation.getCOSObject().getItem(COSName.getPDFName((String)"Popup"));
                String popupID = null;
                if (pop != null) {
                    popupID = this.addPopup(pop);
                }
                Set<String> formsIDs = this.getAnnotationResourcesDependencies(annotation);
                popupID = this.config.isAnnotationsEnabled() ? popupID : null;
                formsIDs = this.config.isXobjectsEnabled() ? formsIDs : null;
                this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createAnnotFeaturesObject(annotation, id, popupID, formsIDs));
                continue;
            }
            catch (IOException e) {
                LOGGER.debug((Object)"Unknown annotation type detected.", (Throwable)e);
                this.generateUnknownAnnotation(id);
            }
        }
        return annotsId;
    }

    private String addPopup(COSBase item) {
        String id = this.getId(item, ANNOT);
        if (this.checkIDBeforeProcess(id)) {
            COSBase base = PBFeatureParser.getBase(item);
            try {
                PDAnnotation annotation = PDAnnotation.createAnnotation((COSBase)base);
                this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createAnnotFeaturesObject(annotation, id, null, null));
            }
            catch (IOException e) {
                LOGGER.debug((Object)"Unknown annotation type detected.", (Throwable)e);
                this.generateUnknownAnnotation(id);
            }
        }
        return id;
    }

    private Set<String> getAnnotationResourcesDependencies(PDAnnotation annot) {
        PDAppearanceDictionary dic = annot.getAppearance();
        HashSet<String> appearances = new HashSet<String>();
        if (dic != null) {
            COSBase baseDown;
            COSBase baseRollover;
            COSBase baseNormal = dic.getCOSObject().getItem(COSName.N);
            if (baseNormal != null) {
                appearances.addAll(this.getAppearanceEntryDependencies(dic.getNormalAppearance(), baseNormal));
            }
            if ((baseRollover = dic.getCOSObject().getItem(COSName.R)) != null) {
                appearances.addAll(this.getAppearanceEntryDependencies(dic.getRolloverAppearance(), baseRollover));
            }
            if ((baseDown = dic.getCOSObject().getItem(COSName.D)) != null) {
                appearances.addAll(this.getAppearanceEntryDependencies(dic.getDownAppearance(), baseDown));
            }
        }
        return appearances;
    }

    private Set<String> getAppearanceEntryDependencies(PDAppearanceEntry entry, COSBase entryLink) {
        HashSet<String> res = new HashSet<String>();
        if (entry.isStream()) {
            res.add(this.getAppearanceStreamDependencies(entry.getAppearanceStream(), entryLink));
        } else {
            for (Map.Entry mapEntry : entry.getSubDictionary().entrySet()) {
                res.add(this.getAppearanceStreamDependencies((PDAppearanceStream)mapEntry.getValue(), ((COSDictionary)entry.getCOSObject()).getItem((COSName)mapEntry.getKey())));
            }
        }
        return res;
    }

    private String getAppearanceStreamDependencies(PDAppearanceStream stream, COSBase entryLink) {
        String id = this.getId(entryLink, XOBJECT_ID);
        if (this.checkIDBeforeProcess(id)) {
            this.parseFormXObject((PDFormXObject)stream, id);
        }
        return id;
    }

    private void generateUnknownAnnotation(String id) {
        if (this.config.isAnnotationsEnabled()) {
            try {
                FeatureTreeNode annot = FeatureTreeNode.createRootNode((String)ANNOTATION);
                annot.setAttribute(ID, id);
                ErrorsHelper.addErrorIntoCollection((FeaturesCollection)this.reporter.getCollection(), (FeatureTreeNode)annot, (String)"Unknown annotation type");
                this.reporter.getCollection().addNewFeatureTree(FeaturesObjectTypesEnum.ANNOTATION, annot);
            }
            catch (FeatureParsingException e) {
                String message = "PBFeatureParser.generateUnknownAnnotation logic failure.";
                LOGGER.fatal((Object)message, (Throwable)e);
                throw new IllegalStateException(message, e);
            }
        }
    }

    private void reportEmbeddedFiles(PDDocumentCatalog catalog) {
        int index = 0;
        PDEmbeddedFilesNameTreeNode efTree = catalog.getNames().getEmbeddedFiles();
        try {
            if (this.config.isEmbeddedFilesEnabled() && efTree.getNames() != null) {
                for (PDComplexFileSpecification file : efTree.getNames().values()) {
                    this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createEmbeddedFileFeaturesObject(file, ++index));
                }
            }
        }
        catch (IOException e) {
            LOGGER.debug((Object)"Error creating PDFBox SubType.", (Throwable)e);
            this.handleSubtypeCreationProblem(e.getMessage());
        }
        if (efTree.getKids() != null) {
            for (PDNameTreeNode tree : efTree.getKids()) {
                if (tree == null) continue;
                index = this.reportEmbeddedFileNode((PDNameTreeNode<PDComplexFileSpecification>)tree, index);
            }
        }
    }

    private int reportEmbeddedFileNode(PDNameTreeNode<PDComplexFileSpecification> node, int index) {
        int res = index;
        try {
            if (this.config.isEmbeddedFilesEnabled() && node.getNames() != null) {
                for (PDComplexFileSpecification file : node.getNames().values()) {
                    if (file == null) continue;
                    this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createEmbeddedFileFeaturesObject(file, ++res));
                }
            }
        }
        catch (IOException e) {
            LOGGER.debug((Object)"Subtype creation exception caught", (Throwable)e);
            this.handleSubtypeCreationProblem(e.getMessage());
        }
        if (node.getKids() != null) {
            for (PDNameTreeNode tree : node.getKids()) {
                res = this.reportEmbeddedFileNode((PDNameTreeNode<PDComplexFileSpecification>)tree, res);
            }
        }
        return res;
    }

    private String addICCProfileFromOutputIntent(PDOutputIntent outInt) {
        COSBase outIntBase = outInt.getCOSObject();
        if (outIntBase instanceof COSDictionary) {
            COSDictionary outIntDict = (COSDictionary)outIntBase;
            String iccProfileID = this.getId(outIntDict.getItem(COSName.DEST_OUTPUT_PROFILE), ICCPROFILE);
            if (this.checkIDBeforeProcess(iccProfileID)) {
                this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createICCProfileFeaturesObject(outInt.getDestOutputIntent(), iccProfileID));
            }
            return iccProfileID;
        }
        return null;
    }

    private void handleSubtypeCreationProblem(String errorMessage) {
        this.creationProblem(EMBEDDEDFILE, null, errorMessage, FeaturesObjectTypesEnum.EMBEDDED_FILE, "PBFeatureParser.reportEmbeddedFileNode logic failure.", true);
    }

    private void fontCreationProblem(String nodeID, String errorMessage) {
        this.creationProblem(FONT, nodeID, errorMessage, FeaturesObjectTypesEnum.FONT, "PBFeatureParser.fontCreationProblem logic failure.", false);
    }

    private void patternCreationProblem(String nodeID, String errorMessage) {
        this.creationProblem(PATTERN, nodeID, errorMessage, FeaturesObjectTypesEnum.PATTERN, "PBFeatureParser.patternCreationProblem logic failure.", false);
    }

    private void colorSpaceCreationProblem(String nodeID, String errorMessage) {
        this.creationProblem(COLORSPACE, nodeID, errorMessage, FeaturesObjectTypesEnum.COLORSPACE, "PBFeatureParser.colorSpaceCreationProblem logic failure.", false);
    }

    private void shadingCreationProblem(String nodeID, String errorMessage) {
        this.creationProblem(SHADING, nodeID, errorMessage, FeaturesObjectTypesEnum.SHADING, "PBFeatureParser.shadingCreationProblem logic failure.", false);
    }

    private void xobjectCreationProblem(String nodeID, String errorMessage) {
        this.creationProblem(XOBJECT, nodeID, errorMessage, FeaturesObjectTypesEnum.FAILED_XOBJECT, "PBFeatureParser.xobjectCreationProblem logic failure.", false);
    }

    private void creationProblem(String nodeName, String nodeID, String errorMessage, FeaturesObjectTypesEnum type, String loggerMessage, boolean isTypeError) {
        if (this.config.isFeaturesEnabledForType(type)) {
            try {
                if (!isTypeError) {
                    FeatureTreeNode node = FeatureTreeNode.createRootNode((String)nodeName);
                    if (nodeID != null) {
                        node.setAttribute(ID, nodeID);
                    }
                    this.reporter.getCollection().addNewFeatureTree(type, node);
                    ErrorsHelper.addErrorIntoCollection((FeaturesCollection)this.reporter.getCollection(), (FeatureTreeNode)node, (String)errorMessage);
                } else {
                    String id = ErrorsHelper.addErrorIntoCollection((FeaturesCollection)this.reporter.getCollection(), null, (String)errorMessage);
                    this.reporter.getCollection().addNewError(type, id);
                }
            }
            catch (FeatureParsingException e) {
                LOGGER.fatal((Object)loggerMessage, (Throwable)e);
                throw new IllegalStateException(loggerMessage, e);
            }
        }
    }

    private Set<String> parseColorSpaceFromResources(PDResources resources) {
        if (resources == null || resources.getXObjectNames() == null) {
            return null;
        }
        HashSet<String> colorSpaceIDs = new HashSet<String>();
        for (COSName name : resources.getColorSpaceNames()) {
            COSDictionary dict = (COSDictionary)resources.getCOSObject().getDictionaryObject(COSName.COLORSPACE);
            COSBase base = dict.getItem(name);
            String id = this.getId(base, COLORSPACE_ID);
            try {
                PDColorSpace colorSpace = resources.getColorSpace(name);
                id = PBFeatureParser.checkColorSpaceID(id, colorSpace);
                colorSpaceIDs.add(id);
                if (!this.checkIDBeforeProcess(id)) continue;
                this.parseColorSpace(colorSpace, id);
            }
            catch (IOException e) {
                LOGGER.info((Object)e);
                this.colorSpaceCreationProblem(id, e.getMessage());
            }
        }
        return colorSpaceIDs;
    }

    private Set<String> parseXObjectFromResources(PDResources resources) {
        if (resources == null || resources.getXObjectNames() == null) {
            return null;
        }
        HashSet<String> xobjectsIDs = new HashSet<String>();
        for (COSName name : resources.getXObjectNames()) {
            COSDictionary dict = (COSDictionary)resources.getCOSObject().getDictionaryObject(COSName.XOBJECT);
            COSBase base = dict.getItem(name);
            String id = this.getId(base, XOBJECT_ID);
            xobjectsIDs.add(id);
            if (!this.checkIDBeforeProcess(id)) continue;
            try {
                PDXObject xobj = resources.getXObject(name);
                if (xobj instanceof PDImageXObjectProxy) {
                    this.parseImageXObject((PDImageXObjectProxy)xobj, id);
                    continue;
                }
                if (xobj instanceof PDFormXObject) {
                    this.parseFormXObject((PDFormXObject)xobj, id);
                    continue;
                }
                if (!(xobj instanceof PDPostScriptXObject)) continue;
                this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createPostScriptXObjectFeaturesObject(id));
            }
            catch (IOException e) {
                LOGGER.info((Object)e);
                this.xobjectCreationProblem(id, e.getMessage());
            }
        }
        return xobjectsIDs;
    }

    private Set<String> parsePropertiesFromResources(PDResources resources) {
        if (resources == null || resources.getPropertiesNames() == null) {
            return null;
        }
        HashSet<String> propertiesIDs = new HashSet<String>();
        for (COSName name : resources.getPropertiesNames()) {
            COSDictionary dict = (COSDictionary)resources.getCOSObject().getDictionaryObject(COSName.PROPERTIES);
            COSBase base = dict.getItem(name);
            String id = this.getId(base, PROPERTIES_ID);
            propertiesIDs.add(id);
            if (!this.checkIDBeforeProcess(id)) continue;
            PDPropertyList property = resources.getProperties(name);
            this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createPropertiesDictFeaturesObject(property.getCOSObject(), id));
        }
        return propertiesIDs;
    }

    private Set<String> parseFontFromResources(PDResources resources) {
        if (resources == null || resources.getFontNames() == null) {
            return null;
        }
        HashSet<String> fontIDs = new HashSet<String>();
        for (COSName name : resources.getFontNames()) {
            COSDictionary dict = (COSDictionary)resources.getCOSObject().getDictionaryObject(COSName.FONT);
            COSBase base = dict.getItem(name);
            String id = this.getId(base, FONT_ID);
            fontIDs.add(id);
            if (!this.checkIDBeforeProcess(id)) continue;
            try {
                PDFont font = resources.getFont(name);
                this.parseFont((PDFontLike)font, id);
            }
            catch (IOException e) {
                LOGGER.info((Object)e);
                this.fontCreationProblem(id, e.getMessage());
            }
        }
        return fontIDs;
    }

    private Set<String> parseExGStateFromResource(PDResources resources) {
        if (resources == null || resources.getExtGStateNames() == null) {
            return null;
        }
        HashSet<String> gStatesIDs = new HashSet<String>();
        for (COSName name : resources.getExtGStateNames()) {
            COSDictionary dict = (COSDictionary)resources.getCOSObject().getDictionaryObject(COSName.EXT_G_STATE);
            COSBase base = dict.getItem(name);
            String id = this.getId(base, EXTGSTATE_ID);
            gStatesIDs.add(id);
            if (!this.checkIDBeforeProcess(id)) continue;
            PDExtendedGraphicsState exGState = resources.getExtGState(name);
            this.parseExGState(exGState, id);
        }
        return gStatesIDs;
    }

    private Set<String> parsePatternFromResource(PDResources resources) {
        if (resources == null || resources.getPatternNames() == null) {
            return null;
        }
        HashSet<String> patternIDs = new HashSet<String>();
        for (COSName name : resources.getPatternNames()) {
            COSDictionary dict = (COSDictionary)resources.getCOSObject().getDictionaryObject(COSName.PATTERN);
            COSBase base = dict.getItem(name);
            String id = this.getId(base, PATTERN_ID);
            patternIDs.add(id);
            if (!this.checkIDBeforeProcess(id)) continue;
            try {
                PDAbstractPattern pattern = resources.getPattern(name);
                this.parsePattern(pattern, id);
            }
            catch (IOException e) {
                LOGGER.info((Object)e);
                this.patternCreationProblem(id, e.getMessage());
            }
        }
        return patternIDs;
    }

    private Set<String> parseShadingFromResource(PDResources resources) {
        if (resources == null || resources.getShadingNames() == null) {
            return null;
        }
        HashSet<String> shadingIDs = new HashSet<String>();
        for (COSName name : resources.getShadingNames()) {
            COSDictionary dict = (COSDictionary)resources.getCOSObject().getDictionaryObject(COSName.SHADING);
            COSBase base = dict.getItem(name);
            String id = this.getId(base, SHADING_ID);
            shadingIDs.add(id);
            if (!this.checkIDBeforeProcess(id)) continue;
            try {
                PDShading shading = resources.getShading(name);
                this.parseShading(shading, id);
            }
            catch (IOException e) {
                LOGGER.info((Object)e);
                this.shadingCreationProblem(id, e.getMessage());
            }
        }
        return shadingIDs;
    }

    private void parseImageXObject(PDImageXObjectProxy xobj, String id) {
        COSBase sMaskBase;
        COSBase maskBase;
        COSBase baseColorSpace = ((COSStream)xobj.getCOSObject()).getItem(COSName.CS);
        if (baseColorSpace == null) {
            baseColorSpace = ((COSStream)xobj.getCOSObject()).getItem(COSName.COLORSPACE);
        }
        String idColorSpace = this.getId(baseColorSpace, COLORSPACE_ID);
        try {
            PDColorSpace colorSpace = xobj.getColorSpace();
            idColorSpace = PBFeatureParser.checkColorSpaceID(idColorSpace, colorSpace);
            if (this.checkIDBeforeProcess(idColorSpace)) {
                this.parseColorSpace(colorSpace, idColorSpace);
            }
        }
        catch (IOException e) {
            LOGGER.info((Object)e);
            this.colorSpaceCreationProblem(idColorSpace, e.getMessage());
        }
        String idMask = null;
        COSBase mask = xobj.getCOSStream().getDictionaryObject(COSName.MASK);
        if (mask instanceof COSStream && this.checkIDBeforeProcess(idMask = this.getId(maskBase = ((COSStream)xobj.getCOSObject()).getItem(COSName.MASK), XOBJECT_ID))) {
            try {
                PDImageXObjectProxy imxobj = xobj.getMask();
                this.parseImageXObject(imxobj, idMask);
            }
            catch (IOException e) {
                LOGGER.info((Object)e);
                this.xobjectCreationProblem(idMask, e.getMessage());
            }
        }
        String idSMask = null;
        COSBase sMask = xobj.getCOSStream().getDictionaryObject(COSName.SMASK);
        if (sMask instanceof COSStream && this.checkIDBeforeProcess(idSMask = this.getId(sMaskBase = ((COSStream)xobj.getCOSObject()).getItem(COSName.SMASK), XOBJECT_ID))) {
            try {
                PDImageXObjectProxy imxobj = xobj.getSoftMask();
                this.parseImageXObject(imxobj, idSMask);
            }
            catch (IOException e) {
                LOGGER.info((Object)e);
                this.xobjectCreationProblem(idSMask, e.getMessage());
            }
        }
        COSBase alternates = xobj.getCOSStream().getDictionaryObject(COSName.getPDFName((String)"Alternates"));
        alternates = PBFeatureParser.getBase(alternates);
        HashSet<String> alternatesIDs = new HashSet<String>();
        if (alternates instanceof COSArray) {
            COSArray alternatesArray = (COSArray)alternates;
            for (COSBase entry : alternatesArray) {
                COSBase base = PBFeatureParser.getBase(entry);
                if (!(base instanceof COSDictionary)) continue;
                COSDictionary altDict = (COSDictionary)base;
                COSBase baseImage = altDict.getItem(COSName.IMAGE);
                String idImage = this.getId(baseImage, XOBJECT_ID);
                if (!((baseImage = PBFeatureParser.getBase(baseImage)) instanceof COSStream)) continue;
                alternatesIDs.add(idImage);
                if (!this.checkIDBeforeProcess(idImage)) continue;
                PDImageXObjectProxy im = new PDImageXObjectProxy(new PDStream((COSStream)baseImage), null);
                this.parseImageXObject(im, idImage);
            }
        }
        String string = idColorSpace = this.config.isColorSpacesEnabled() ? idColorSpace : null;
        if (!this.config.isXobjectsEnabled()) {
            idMask = null;
            idSMask = null;
            alternatesIDs = null;
        }
        this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createImageXObjectFeaturesObject(xobj, id, idColorSpace, idMask, idSMask, alternatesIDs));
    }

    private void parseFormXObject(PDFormXObject xobj, String id) {
        PDGroup group = xobj.getGroup();
        String idColorSpace = null;
        if (group != null && COSName.TRANSPARENCY.equals((Object)group.getSubType())) {
            COSBase baseColorSpace = group.getCOSObject().getItem(COSName.CS);
            idColorSpace = this.getId(baseColorSpace, COLORSPACE_ID);
            try {
                PDColorSpace colorSpace = group.getColorSpace();
                idColorSpace = PBFeatureParser.checkColorSpaceID(idColorSpace, colorSpace);
                if (this.checkIDBeforeProcess(idColorSpace)) {
                    this.parseColorSpace(colorSpace, idColorSpace);
                }
            }
            catch (IOException e) {
                LOGGER.info((Object)e);
                this.colorSpaceCreationProblem(idColorSpace, e.getMessage());
            }
        }
        PDResources resources = xobj.getResources();
        Set<String> extGStateChild = this.parseExGStateFromResource(resources);
        extGStateChild = this.config.isGraphicsStatesEnabled() ? extGStateChild : null;
        Set<String> colorSpaceChild = this.parseColorSpaceFromResources(resources);
        if (!this.config.isColorSpacesEnabled()) {
            idColorSpace = null;
            colorSpaceChild = null;
        }
        Set<String> patternChild = this.parsePatternFromResource(resources);
        patternChild = this.config.isPatternsEnabled() ? patternChild : null;
        Set<String> shadingChild = this.parseShadingFromResource(resources);
        shadingChild = this.config.isShadingsEnabled() ? shadingChild : null;
        Set<String> xobjectChild = this.parseXObjectFromResources(resources);
        xobjectChild = this.config.isXobjectsEnabled() ? xobjectChild : null;
        Set<String> fontChild = this.parseFontFromResources(resources);
        fontChild = this.config.isFontsEnabled() ? fontChild : null;
        Set<String> propertiesChild = this.parsePropertiesFromResources(resources);
        propertiesChild = this.config.isPropertiesDictsEnabled() ? propertiesChild : null;
        this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createFormXObjectFeaturesObject(xobj, id, idColorSpace, extGStateChild, colorSpaceChild, patternChild, shadingChild, xobjectChild, fontChild, propertiesChild));
    }

    private void parseExGState(PDExtendedGraphicsState exGState, String id) {
        String childFontID = null;
        if (exGState.getFontSetting() != null && exGState.getFontSetting().getCOSObject() instanceof COSArray && this.checkIDBeforeProcess(childFontID = this.getId(((COSArray)exGState.getFontSetting().getCOSObject()).get(0), FONT_ID))) {
            try {
                PDFont font = exGState.getFontSetting().getFont();
                this.parseFont((PDFontLike)font, childFontID);
            }
            catch (IOException e) {
                LOGGER.info((Object)e);
                this.fontCreationProblem(childFontID, e.getMessage());
            }
        }
        childFontID = this.config.isFontsEnabled() ? childFontID : null;
        this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createExtGStateFeaturesObject(exGState, id, childFontID));
    }

    private void parsePattern(PDAbstractPattern pattern, String id) throws IOException {
        if (pattern instanceof PDTilingPattern) {
            PDTilingPattern tilingPattern = (PDTilingPattern)pattern;
            PDResources resources = tilingPattern.getResources();
            Set<String> extGStateChild = this.parseExGStateFromResource(resources);
            extGStateChild = this.config.isGraphicsStatesEnabled() ? extGStateChild : null;
            Set<String> colorSpaceChild = this.parseColorSpaceFromResources(resources);
            colorSpaceChild = this.config.isColorSpacesEnabled() ? colorSpaceChild : null;
            Set<String> patternChild = this.parsePatternFromResource(resources);
            patternChild = this.config.isPatternsEnabled() ? patternChild : null;
            Set<String> shadingChild = this.parseShadingFromResource(resources);
            shadingChild = this.config.isShadingsEnabled() ? shadingChild : null;
            Set<String> xobjectChild = this.parseXObjectFromResources(resources);
            xobjectChild = this.config.isXobjectsEnabled() ? xobjectChild : null;
            Set<String> fontChild = this.parseFontFromResources(resources);
            fontChild = this.config.isFontsEnabled() ? fontChild : null;
            Set<String> propertiesChild = this.parsePropertiesFromResources(resources);
            propertiesChild = this.config.isPropertiesDictsEnabled() ? propertiesChild : null;
            this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createTilingPatternFeaturesObject(tilingPattern, id, extGStateChild, colorSpaceChild, patternChild, shadingChild, xobjectChild, fontChild, propertiesChild));
        } else {
            COSBase baseExGState;
            String exGStateID;
            PDShadingPattern shadingPattern = (PDShadingPattern)pattern;
            COSBase baseShading = shadingPattern.getCOSObject().getItem(COSName.SHADING);
            String shadingID = this.getId(baseShading, SHADING_ID);
            if (this.checkIDBeforeProcess(shadingID) && shadingPattern.getShading() != null) {
                this.parseShading(shadingPattern.getShading(), shadingID);
            }
            if (this.checkIDBeforeProcess(exGStateID = this.getId(baseExGState = shadingPattern.getCOSObject().getItem(COSName.EXT_G_STATE), EXTGSTATE_ID)) && shadingPattern.getExtendedGraphicsState() != null) {
                this.parseExGState(shadingPattern.getExtendedGraphicsState(), exGStateID);
            }
            shadingID = this.config.isShadingsEnabled() ? shadingID : null;
            exGStateID = this.config.isGraphicsStatesEnabled() ? exGStateID : null;
            this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createShadingPatternFeaturesObject(shadingPattern, id, shadingID, exGStateID));
        }
    }

    private void parseShading(PDShading shading, String id) {
        COSBase base = shading.getCOSObject().getItem(COSName.CS);
        if (base == null) {
            base = shading.getCOSObject().getItem(COSName.COLORSPACE);
        }
        String colorspaceID = this.getId(base, COLORSPACE_ID);
        try {
            PDColorSpace colorSpace = shading.getColorSpace();
            colorspaceID = PBFeatureParser.checkColorSpaceID(colorspaceID, colorSpace);
            if (this.checkIDBeforeProcess(colorspaceID)) {
                this.parseColorSpace(colorSpace, colorspaceID);
            }
        }
        catch (IOException e) {
            LOGGER.info((Object)e);
            this.colorSpaceCreationProblem(colorspaceID, e.getMessage());
        }
        colorspaceID = this.config.isColorSpacesEnabled() ? colorspaceID : null;
        this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createShadingFeaturesObject(shading, id, colorspaceID));
    }

    private void parseFont(PDFontLike font, String id) {
        if (font instanceof PDType3Font) {
            PDResources resources = ((PDType3Font)font).getResources();
            Set<String> extGStateChild = this.parseExGStateFromResource(resources);
            extGStateChild = this.config.isGraphicsStatesEnabled() ? extGStateChild : null;
            Set<String> colorSpaceChild = this.parseColorSpaceFromResources(resources);
            colorSpaceChild = this.config.isColorSpacesEnabled() ? colorSpaceChild : null;
            Set<String> patternChild = this.parsePatternFromResource(resources);
            patternChild = this.config.isPatternsEnabled() ? patternChild : null;
            Set<String> shadingChild = this.parseShadingFromResource(resources);
            shadingChild = this.config.isShadingsEnabled() ? shadingChild : null;
            Set<String> xobjectChild = this.parseXObjectFromResources(resources);
            xobjectChild = this.config.isXobjectsEnabled() ? xobjectChild : null;
            Set<String> fontChild = this.parseFontFromResources(resources);
            fontChild = this.config.isFontsEnabled() ? fontChild : null;
            Set<String> propertiesChild = this.parsePropertiesFromResources(resources);
            propertiesChild = this.config.isPropertiesDictsEnabled() ? propertiesChild : null;
            this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createFontFeaturesObject(font, id, extGStateChild, colorSpaceChild, patternChild, shadingChild, xobjectChild, fontChild, propertiesChild));
        } else if (font instanceof PDType0Font) {
            PDType0Font type0 = (PDType0Font)font;
            COSBase descendantFontsBase = type0.getCOSObject().getDictionaryObject(COSName.DESCENDANT_FONTS);
            if (descendantFontsBase instanceof COSArray) {
                COSBase descendantFontDictionaryBase = ((COSArray)descendantFontsBase).getObject(0);
                String descendantID = this.getId(descendantFontDictionaryBase, FONT_ID);
                if (this.checkIDBeforeProcess(descendantID)) {
                    this.parseFont((PDFontLike)type0.getDescendantFont(), descendantID);
                }
                HashSet<String> descendant = null;
                if (this.config.isFontsEnabled()) {
                    descendant = new HashSet<String>();
                    descendant.add(descendantID);
                }
                this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createFontFeaturesObject(font, id, null, null, null, null, null, descendant, null));
            }
        } else {
            this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createFontFeaturesObject(font, id, null, null, null, null, null, null, null));
        }
    }

    private void parseColorSpace(PDColorSpace colorSpace, String id) {
        String iccProfileID = null;
        String idAlt = null;
        if (colorSpace instanceof PDICCBased) {
            PDICCBased iccBased = (PDICCBased)colorSpace;
            COSArray array = (COSArray)iccBased.getCOSObject();
            COSBase base = array.get(1);
            iccProfileID = this.getId(base, ICCPROFILE);
            if (this.checkIDBeforeProcess(iccProfileID)) {
                this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createICCProfileFeaturesObject(iccBased.getPDStream().getStream(), iccProfileID));
            }
            COSBase baseAlt = iccBased.getPDStream().getStream().getItem(COSName.ALTERNATE);
            idAlt = this.getId(baseAlt, COLORSPACE_ID);
            try {
                PDColorSpace altclr = iccBased.getAlternateColorSpace();
                idAlt = PBFeatureParser.checkColorSpaceID(idAlt, altclr);
                if (this.checkIDBeforeProcess(idAlt)) {
                    this.parseColorSpace(iccBased.getAlternateColorSpace(), idAlt);
                }
            }
            catch (IOException e) {
                LOGGER.info((Object)e);
                this.colorSpaceCreationProblem(idAlt, e.getMessage());
            }
        } else if (colorSpace instanceof PDIndexed || colorSpace instanceof PDSeparation || colorSpace instanceof PDDeviceN) {
            int number = colorSpace instanceof PDIndexed ? 1 : 2;
            COSArray array = (COSArray)colorSpace.getCOSObject();
            COSBase base = array.get(number);
            idAlt = this.getId(base, COLORSPACE_ID);
            try {
                PDColorSpace alt = colorSpace instanceof PDIndexed ? ((PDIndexed)colorSpace).getBaseColorSpace() : (colorSpace instanceof PDSeparation ? ((PDSeparation)colorSpace).getAlternateColorSpace() : ((PDDeviceN)colorSpace).getAlternateColorSpace());
                idAlt = PBFeatureParser.checkColorSpaceID(idAlt, alt);
                if (this.checkIDBeforeProcess(idAlt)) {
                    this.parseColorSpace(alt, idAlt);
                }
            }
            catch (IOException e) {
                LOGGER.info((Object)e);
                this.colorSpaceCreationProblem(idAlt, e.getMessage());
            }
        }
        iccProfileID = this.config.isIccProfilesEnabled() ? iccProfileID : null;
        idAlt = this.config.isColorSpacesEnabled() ? idAlt : null;
        this.reporter.report((IFeaturesObject)PBFeaturesObjectCreator.createColorSpaceFeaturesObject(colorSpace, id, iccProfileID, idAlt));
    }

    private static String checkColorSpaceID(String prevID, PDColorSpace colorSpace) {
        String id = colorSpace instanceof PDDeviceGray ? DEVICEGRAY_ID : (colorSpace instanceof PDDeviceRGB ? DEVICERGB_ID : (colorSpace instanceof PDDeviceCMYK ? DEVICECMYK_ID : prevID));
        return id;
    }

    private static COSBase getBase(COSBase base) {
        COSBase item = base;
        while (item instanceof COSObject) {
            item = ((COSObject)item).getObject();
        }
        return item;
    }

    private String getId(COSBase base, String prefix) {
        if (base == null) {
            return null;
        }
        long numb = this.processedIDs.size();
        COSBase item = base;
        String type = "Dir";
        while (item instanceof COSObject) {
            numb = ((COSObject)item).getObjectNumber();
            type = "Indir";
            item = ((COSObject)item).getObject();
        }
        return prefix + type + numb;
    }

    private boolean checkIDBeforeProcess(String id) {
        if (id == null) {
            return false;
        }
        if (this.processedIDs.contains(id)) {
            return false;
        }
        this.processedIDs.add(id);
        return true;
    }
}

