/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.util.Set;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBFormXObjectFeaturesObject
implements IFeaturesObject {
    private static final String ID = "id";
    private PDFormXObject formXObject;
    private String id;
    private String groupColorSpaceChild;
    private Set<String> extGStateChild;
    private Set<String> colorSpaceChild;
    private Set<String> patternChild;
    private Set<String> shadingChild;
    private Set<String> xobjectChild;
    private Set<String> fontChild;
    private Set<String> propertiesChild;

    public PBFormXObjectFeaturesObject(PDFormXObject formXObject, String id, String groupColorSpaceChild, Set<String> extGStateChild, Set<String> colorSpaceChild, Set<String> patternChild, Set<String> shadingChild, Set<String> xobjectChild, Set<String> fontChild, Set<String> propertiesChild) {
        this.formXObject = formXObject;
        this.id = id;
        this.groupColorSpaceChild = groupColorSpaceChild;
        this.extGStateChild = extGStateChild;
        this.colorSpaceChild = colorSpaceChild;
        this.patternChild = patternChild;
        this.shadingChild = shadingChild;
        this.xobjectChild = xobjectChild;
        this.fontChild = fontChild;
        this.propertiesChild = propertiesChild;
    }

    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.FORM_XOBJECT;
    }

    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeatureParsingException {
        if (this.formXObject != null) {
            COSBase cosBase;
            FeatureTreeNode root = FeatureTreeNode.createRootNode((String)"xobject");
            root.setAttribute("type", "form");
            if (this.id != null) {
                root.setAttribute(ID, this.id);
            }
            PBCreateNodeHelper.addBoxFeature("bbox", this.formXObject.getBBox(), root);
            PBFormXObjectFeaturesObject.parseFloatMatrix(this.formXObject.getMatrix().getValues(), FeatureTreeNode.createChildNode((String)"matrix", (FeatureTreeNode)root));
            if (this.formXObject.getGroup() != null) {
                FeatureTreeNode groupNode = FeatureTreeNode.createChildNode((String)"group", (FeatureTreeNode)root);
                if (this.formXObject.getGroup().getSubType() != null) {
                    PBCreateNodeHelper.addNotEmptyNode("subtype", this.formXObject.getGroup().getSubType().getName(), groupNode);
                    if ("Transparency".equals(this.formXObject.getGroup().getSubType().getName())) {
                        if (this.groupColorSpaceChild != null) {
                            FeatureTreeNode clr = FeatureTreeNode.createChildNode((String)"colorSpace", (FeatureTreeNode)groupNode);
                            clr.setAttribute(ID, this.groupColorSpaceChild);
                        }
                        FeatureTreeNode.createChildNode((String)"isolated", (FeatureTreeNode)groupNode).setValue(String.valueOf(this.formXObject.getGroup().isIsolated()));
                        FeatureTreeNode.createChildNode((String)"knockout", (FeatureTreeNode)groupNode).setValue(String.valueOf(this.formXObject.getGroup().isKnockout()));
                    }
                }
            }
            if (this.formXObject.getCOSStream().getItem(COSName.STRUCT_PARENTS) != null) {
                FeatureTreeNode.createChildNode((String)"structParents", (FeatureTreeNode)root).setValue(String.valueOf(this.formXObject.getStructParents()));
            }
            if ((cosBase = this.formXObject.getCOSStream().getDictionaryObject(COSName.METADATA)) instanceof COSStream) {
                PDMetadata meta = new PDMetadata((COSStream)cosBase);
                PBCreateNodeHelper.parseMetadata(meta, "metadata", root, collection);
            }
            this.parseResources(root);
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.FORM_XOBJECT, root);
            return root;
        }
        return null;
    }

    public FeaturesData getData() {
        return null;
    }

    private static void parseFloatMatrix(float[][] array, FeatureTreeNode parent) throws FeatureParsingException {
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array.length - 1; ++j) {
                FeatureTreeNode element = FeatureTreeNode.createChildNode((String)"element", (FeatureTreeNode)parent);
                element.setAttribute("row", String.valueOf(i + 1));
                element.setAttribute("column", String.valueOf(j + 1));
                element.setAttribute("value", String.valueOf(array[i][j]));
            }
        }
    }

    private void parseResources(FeatureTreeNode root) throws FeatureParsingException {
        if (this.extGStateChild != null && !this.extGStateChild.isEmpty() || this.colorSpaceChild != null && !this.colorSpaceChild.isEmpty() || this.patternChild != null && !this.patternChild.isEmpty() || this.shadingChild != null && !this.shadingChild.isEmpty() || this.xobjectChild != null && !this.xobjectChild.isEmpty() || this.fontChild != null && !this.fontChild.isEmpty() || this.propertiesChild != null && !this.propertiesChild.isEmpty()) {
            FeatureTreeNode resources = FeatureTreeNode.createChildNode((String)"resources", (FeatureTreeNode)root);
            PBCreateNodeHelper.parseIDSet(this.extGStateChild, "graphicsState", "graphicsStates", resources);
            PBCreateNodeHelper.parseIDSet(this.colorSpaceChild, "colorSpace", "colorSpaces", resources);
            PBCreateNodeHelper.parseIDSet(this.patternChild, "pattern", "patterns", resources);
            PBCreateNodeHelper.parseIDSet(this.shadingChild, "shading", "shadings", resources);
            PBCreateNodeHelper.parseIDSet(this.xobjectChild, "xobject", "xobjects", resources);
            PBCreateNodeHelper.parseIDSet(this.fontChild, "font", "fonts", resources);
            PBCreateNodeHelper.parseIDSet(this.propertiesChild, "propertiesDict", "propertiesDicts", resources);
        }
    }
}

