/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import org.apache.pdfbox.pdmodel.graphics.pattern.PDShadingPattern;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBShadingPatternFeaturesObject
implements IFeaturesObject {
    private static final String ID = "id";
    private PDShadingPattern shadingPattern;
    private String id;
    private String shadingChild;
    private String extGStateChild;

    public PBShadingPatternFeaturesObject(PDShadingPattern shadingPattern, String id, String shadingChild, String extGStateChild) {
        this.shadingPattern = shadingPattern;
        this.id = id;
        this.shadingChild = shadingChild;
        this.extGStateChild = extGStateChild;
    }

    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.PATTERN;
    }

    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeatureParsingException {
        if (this.shadingPattern != null) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode((String)"pattern");
            if (this.id != null) {
                root.setAttribute(ID, this.id);
            }
            root.setAttribute("type", "shading");
            if (this.shadingChild != null) {
                FeatureTreeNode shading = FeatureTreeNode.createChildNode((String)"shading", (FeatureTreeNode)root);
                shading.setAttribute(ID, this.shadingChild);
            }
            this.parseFloatMatrix(this.shadingPattern.getMatrix().getValues(), FeatureTreeNode.createChildNode((String)"matrix", (FeatureTreeNode)root));
            if (this.extGStateChild != null) {
                FeatureTreeNode exGState = FeatureTreeNode.createChildNode((String)"graphicsState", (FeatureTreeNode)root);
                exGState.setAttribute(ID, this.extGStateChild);
            }
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.PATTERN, root);
            return root;
        }
        return null;
    }

    public FeaturesData getData() {
        return null;
    }

    private void parseFloatMatrix(float[][] array, FeatureTreeNode parent) throws FeatureParsingException {
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array.length - 1; ++j) {
                FeatureTreeNode element = FeatureTreeNode.createChildNode((String)"element", (FeatureTreeNode)parent);
                element.setAttribute("row", String.valueOf(i + 1));
                element.setAttribute("column", String.valueOf(j + 1));
                element.setAttribute("value", String.valueOf(array[i][j]));
            }
        }
    }
}

