/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.util.Set;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBTilingPatternFeaturesObject
implements IFeaturesObject {
    private static final String ID = "id";
    private PDTilingPattern tilingPattern;
    private String id;
    private Set<String> extGStateChild;
    private Set<String> colorSpaceChild;
    private Set<String> patternChild;
    private Set<String> shadingChild;
    private Set<String> xobjectChild;
    private Set<String> fontChild;
    private Set<String> propertiesChild;

    public PBTilingPatternFeaturesObject(PDTilingPattern tilingPattern, String id, Set<String> extGStateChild, Set<String> colorSpaceChild, Set<String> patternChild, Set<String> shadingChild, Set<String> xobjectChild, Set<String> fontChild, Set<String> propertiesChild) {
        this.tilingPattern = tilingPattern;
        this.id = id;
        this.extGStateChild = extGStateChild;
        this.colorSpaceChild = colorSpaceChild;
        this.patternChild = patternChild;
        this.shadingChild = shadingChild;
        this.xobjectChild = xobjectChild;
        this.fontChild = fontChild;
        this.propertiesChild = propertiesChild;
    }

    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.PATTERN;
    }

    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeatureParsingException {
        if (this.tilingPattern != null) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode((String)"pattern");
            if (this.id != null) {
                root.setAttribute(ID, this.id);
            }
            root.setAttribute("type", "tiling");
            FeatureTreeNode.createChildNode((String)"paintType", (FeatureTreeNode)root).setValue(String.valueOf(this.tilingPattern.getPaintType()));
            FeatureTreeNode.createChildNode((String)"tilingType", (FeatureTreeNode)root).setValue(String.valueOf(this.tilingPattern.getTilingType()));
            PBCreateNodeHelper.addBoxFeature("bbox", this.tilingPattern.getBBox(), root);
            FeatureTreeNode.createChildNode((String)"xStep", (FeatureTreeNode)root).setValue(String.valueOf(this.tilingPattern.getXStep()));
            FeatureTreeNode.createChildNode((String)"yStep", (FeatureTreeNode)root).setValue(String.valueOf(this.tilingPattern.getYStep()));
            this.parseFloatMatrix(this.tilingPattern.getMatrix().getValues(), FeatureTreeNode.createChildNode((String)"matrix", (FeatureTreeNode)root));
            this.parseResources(root);
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.PATTERN, root);
            return root;
        }
        return null;
    }

    public FeaturesData getData() {
        return null;
    }

    private void parseFloatMatrix(float[][] array, FeatureTreeNode parent) throws FeatureParsingException {
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array.length - 1; ++j) {
                FeatureTreeNode element = FeatureTreeNode.createChildNode((String)"element", (FeatureTreeNode)parent);
                element.setAttribute("row", String.valueOf(i + 1));
                element.setAttribute("column", String.valueOf(j + 1));
                element.setAttribute("value", String.valueOf(array[i][j]));
            }
        }
    }

    private void parseResources(FeatureTreeNode root) throws FeatureParsingException {
        if (this.extGStateChild != null && !this.extGStateChild.isEmpty() || this.colorSpaceChild != null && !this.colorSpaceChild.isEmpty() || this.patternChild != null && !this.patternChild.isEmpty() || this.shadingChild != null && !this.shadingChild.isEmpty() || this.xobjectChild != null && !this.xobjectChild.isEmpty() || this.fontChild != null && !this.fontChild.isEmpty() || this.propertiesChild != null && !this.propertiesChild.isEmpty()) {
            FeatureTreeNode resources = FeatureTreeNode.createChildNode((String)"resources", (FeatureTreeNode)root);
            PBCreateNodeHelper.parseIDSet(this.extGStateChild, "graphicsState", "graphicsStates", resources);
            PBCreateNodeHelper.parseIDSet(this.colorSpaceChild, "colorSpace", "colorSpaces", resources);
            PBCreateNodeHelper.parseIDSet(this.patternChild, "pattern", "patterns", resources);
            PBCreateNodeHelper.parseIDSet(this.shadingChild, "shading", "shadings", resources);
            PBCreateNodeHelper.parseIDSet(this.xobjectChild, "xobject", "xobjects", resources);
            PBCreateNodeHelper.parseIDSet(this.fontChild, "font", "fonts", resources);
            PBCreateNodeHelper.parseIDSet(this.propertiesChild, "propertiesDict", "propertiesDicts", resources);
        }
    }
}

