/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.tools;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.pb.objects.ColorComponent;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public final class PBCreateNodeHelper {
    private static final Logger LOGGER = Logger.getLogger(PBCreateNodeHelper.class);
    private static final String LLX = "llx";
    private static final String LLY = "lly";
    private static final String URX = "urx";
    private static final String URY = "ury";

    private PBCreateNodeHelper() {
    }

    private static String getXMLFormat(Calendar calendar) throws DatatypeConfigurationException {
        GregorianCalendar greg = new GregorianCalendar(Locale.US);
        greg.setTime(calendar.getTime());
        greg.setTimeZone(calendar.getTimeZone());
        XMLGregorianCalendar xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(greg);
        return xmlCalendar.toXMLFormat();
    }

    public static FeatureTreeNode createDateNode(String nodeName, FeatureTreeNode parent, Calendar date, FeatureExtractionResult collection) throws FeatureParsingException {
        FeatureTreeNode modificationDate = null;
        if (date != null) {
            modificationDate = parent.addChild(nodeName);
            try {
                modificationDate.setValue(PBCreateNodeHelper.getXMLFormat(date));
            }
            catch (DatatypeConfigurationException e) {
                LOGGER.debug((Object)"DatatypeFactory implementation not available or can't be instantiated", (Throwable)e);
                ErrorsHelper.addErrorIntoCollection((FeatureExtractionResult)collection, (FeatureTreeNode)modificationDate, (String)e.getMessage());
            }
        }
        return modificationDate;
    }

    public static String getStringFromBase(COSBase baseParam) {
        COSBase base = baseParam;
        while (base instanceof COSObject) {
            base = ((COSObject)base).getObject();
        }
        if (base instanceof COSString) {
            COSString str = (COSString)base;
            return str.isHex() ? str.toHexString() : str.getString();
        }
        return null;
    }

    public static FeatureTreeNode addBoxFeature(String name, PDRectangle box, FeatureTreeNode parent) throws FeatureParsingException {
        FeatureTreeNode boxNode = null;
        if (box != null) {
            boxNode = parent.addChild(name);
            boxNode.setAttribute(LLX, String.valueOf(box.getLowerLeftX()));
            boxNode.setAttribute(LLY, String.valueOf(box.getLowerLeftY()));
            boxNode.setAttribute(URX, String.valueOf(box.getUpperRightX()));
            boxNode.setAttribute(URY, String.valueOf(box.getUpperRightY()));
        }
        return boxNode;
    }

    public static FeatureTreeNode addNotEmptyNode(String name, String value, FeatureTreeNode parent) throws FeatureParsingException {
        if (name != null && value != null) {
            FeatureTreeNode node = parent.addChild(name);
            node.setValue(value);
            return node;
        }
        return null;
    }

    public static FeatureTreeNode addDeviceColorSpaceNode(String name, PDColor color, FeatureTreeNode parent, FeatureExtractionResult collection) throws FeatureParsingException {
        if (name == null || color == null) {
            return null;
        }
        FeatureTreeNode colorNode = parent.addChild(name);
        boolean typeDefined = false;
        float[] numbers = color.getComponents();
        for (ColorComponent component : ColorComponent.values()) {
            if (component.getSize() != numbers.length) continue;
            typeDefined = true;
            colorNode.setAttributes(component.createAttributesMap(numbers));
        }
        if (!typeDefined) {
            ErrorsHelper.addErrorIntoCollection((FeatureExtractionResult)collection, (FeatureTreeNode)colorNode, (String)"Can not define color type");
        }
        return colorNode;
    }

    public static void parseIDSet(Set<String> set, String elementName, String setName, FeatureTreeNode root) throws FeatureParsingException {
        if (set != null && !set.isEmpty()) {
            FeatureTreeNode setNode = setName == null ? root : root.addChild(setName);
            for (String entry : set) {
                if (entry == null) continue;
                FeatureTreeNode entryNode = setNode.addChild(elementName);
                entryNode.setAttribute("id", entry);
            }
        }
    }

    public static byte[] inputStreamToByteArray(InputStream is) throws IOException {
        int length;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        while ((length = is.read(bytes)) != -1) {
            baos.write(bytes, 0, length);
        }
        return baos.toByteArray();
    }

    public static FeatureTreeNode parseMetadata(PDMetadata metadata, String nodeName, FeatureTreeNode parent, FeatureExtractionResult collection) throws FeatureParsingException {
        if (metadata == null) {
            return null;
        }
        FeatureTreeNode node = parent.addMetadataChild(nodeName);
        try {
            byte[] bStream = metadata.getByteArray();
            if (bStream != null) {
                String hexString = DatatypeConverter.printHexBinary((byte[])bStream);
                node.setValue(hexString);
            }
        }
        catch (IOException e) {
            LOGGER.debug((Object)"Error while obtaining unfiltered metadata stream", (Throwable)e);
            ErrorsHelper.addErrorIntoCollection((FeatureExtractionResult)collection, (FeatureTreeNode)node, (String)e.getMessage());
        }
        return node;
    }
}

