/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.util.HashSet;
import java.util.Set;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.ColorComponent;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class PBOutlinesFeaturesObject
implements IFeaturesObject {
    private PDDocumentOutline outline;

    public PBOutlinesFeaturesObject(PDDocumentOutline outline) {
        this.outline = outline;
    }

    public FeatureObjectType getType() {
        return FeatureObjectType.OUTLINES;
    }

    public FeatureTreeNode reportFeatures(FeatureExtractionResult collection) throws FeatureParsingException {
        if (this.outline != null) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode((String)"outlines");
            if (this.outline.children() != null) {
                HashSet<PDOutlineItem> items = new HashSet<PDOutlineItem>();
                for (PDOutlineItem item : this.outline.children()) {
                    if (items.contains(item)) continue;
                    PBOutlinesFeaturesObject.createItem(item, root, collection, items);
                }
            }
            collection.addNewFeatureTree(FeatureObjectType.OUTLINES, root);
            return root;
        }
        return null;
    }

    public FeaturesData getData() {
        return null;
    }

    private static void createItem(PDOutlineItem item, FeatureTreeNode root, FeatureExtractionResult collection, Set<PDOutlineItem> items) throws FeatureParsingException {
        if (item != null) {
            items.add(item);
            FeatureTreeNode itemNode = root.addChild("outline");
            PBCreateNodeHelper.addNotEmptyNode("title", item.getTitle(), itemNode);
            FeatureTreeNode color = itemNode.addChild("color");
            PDColor clr = item.getTextColor();
            float[] rgb = clr.getComponents();
            if (rgb.length == ColorComponent.RGB_COMPONENTS.getColors().size()) {
                color.setAttributes(ColorComponent.RGB_COMPONENTS.createAttributesMap(rgb));
            } else {
                ErrorsHelper.addErrorIntoCollection((FeatureExtractionResult)collection, (FeatureTreeNode)color, (String)"Color must be in rgb form");
            }
            FeatureTreeNode style = itemNode.addChild("style");
            style.setAttribute("italic", String.valueOf(item.isItalic()));
            style.setAttribute("bold", String.valueOf(item.isBold()));
            for (PDOutlineItem child : item.children()) {
                if (items.contains(child)) continue;
                PBOutlinesFeaturesObject.createItem(child, itemNode, collection, items);
            }
        }
    }
}

