/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import org.apache.pdfbox.pdmodel.graphics.pattern.PDShadingPattern;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class PBShadingPatternFeaturesObject
implements IFeaturesObject {
    private static final String ID = "id";
    private PDShadingPattern shadingPattern;
    private String id;
    private String shadingChild;
    private String extGStateChild;

    public PBShadingPatternFeaturesObject(PDShadingPattern shadingPattern, String id, String shadingChild, String extGStateChild) {
        this.shadingPattern = shadingPattern;
        this.id = id;
        this.shadingChild = shadingChild;
        this.extGStateChild = extGStateChild;
    }

    public FeatureObjectType getType() {
        return FeatureObjectType.PATTERN;
    }

    public FeatureTreeNode reportFeatures(FeatureExtractionResult collection) throws FeatureParsingException {
        if (this.shadingPattern != null) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode((String)"pattern");
            if (this.id != null) {
                root.setAttribute(ID, this.id);
            }
            root.setAttribute("type", "shading");
            if (this.shadingChild != null) {
                FeatureTreeNode shading = root.addChild("shading");
                shading.setAttribute(ID, this.shadingChild);
            }
            PBCreateNodeHelper.parseFloatMatrix(this.shadingPattern.getMatrix().getValues(), root.addChild("matrix"));
            if (this.extGStateChild != null) {
                FeatureTreeNode exGState = root.addChild("graphicsState");
                exGState.setAttribute(ID, this.extGStateChild);
            }
            collection.addNewFeatureTree(FeatureObjectType.PATTERN, root);
            return root;
        }
        return null;
    }

    public FeaturesData getData() {
        return null;
    }
}

