/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.metadata.fixer.impl.pb.model;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.verapdf.metadata.fixer.entity.InfoDictionary;
import org.verapdf.metadata.fixer.entity.Metadata;
import org.verapdf.metadata.fixer.impl.pb.schemas.AdobePDFSchemaImpl;
import org.verapdf.metadata.fixer.impl.pb.schemas.DublinCoreSchemaImpl;
import org.verapdf.metadata.fixer.impl.pb.schemas.XMPBasicSchemaImpl;
import org.verapdf.metadata.fixer.schemas.AdobePDF;
import org.verapdf.metadata.fixer.schemas.DublinCore;
import org.verapdf.metadata.fixer.schemas.XMPBasic;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.results.MetadataFixerResult;
import org.verapdf.pdfa.results.MetadataFixerResultImpl;
import org.verapdf.xmp.XMPException;
import org.verapdf.xmp.impl.VeraPDFMeta;

public class MetadataImpl
implements Metadata {
    private static final Logger LOGGER = Logger.getLogger(MetadataImpl.class);
    private final VeraPDFMeta metadata;
    private final COSStream stream;

    public MetadataImpl(VeraPDFMeta metadata, COSStream stream) {
        if (metadata == null) {
            throw new IllegalArgumentException("Metadata package can not be null");
        }
        if (stream == null) {
            throw new IllegalArgumentException("Metadata stream can not be null");
        }
        this.metadata = metadata;
        this.stream = stream;
    }

    public void checkMetadataStream(MetadataFixerResultImpl.Builder resultBuilder, PDFAFlavour flavour) {
        PDFAFlavour.Specification part = flavour.getPart();
        if (part == PDFAFlavour.Specification.ISO_19005_2 || part == PDFAFlavour.Specification.ISO_19005_3) {
            COSBase filters = this.stream.getFilters();
            if (filters instanceof COSName && COSName.FLATE_DECODE.equals((Object)filters)) {
                return;
            }
            if (filters instanceof COSArray && ((COSArray)filters).size() == 1 && COSName.FLATE_DECODE.equals((Object)((COSArray)filters).get(0))) {
                return;
            }
            try {
                this.stream.setFilters((COSBase)COSName.FLATE_DECODE);
                this.stream.setNeedToBeUpdated(true);
                resultBuilder.addFix("Metadata stream filtered with FlateDecode");
            }
            catch (IOException e) {
                LOGGER.debug((Object)"Problems with setting filter for stream.");
                LOGGER.debug((Object)e);
            }
        }
        this.setRequiredDictionaryValue(COSName.METADATA, COSName.TYPE, resultBuilder);
        this.setRequiredDictionaryValue(COSName.getPDFName((String)"XML"), COSName.SUBTYPE, resultBuilder);
    }

    private void setRequiredDictionaryValue(COSName value, COSName key, MetadataFixerResultImpl.Builder resultBuilder) {
        if (!value.equals((Object)this.stream.getDictionaryObject(key))) {
            this.stream.setItem(key, (COSBase)value);
            this.stream.setNeedToBeUpdated(true);
            resultBuilder.addFix(value.getName() + " value of " + key.getName() + " key is set to metadata dictionary");
        }
    }

    public void removePDFIdentificationSchema(MetadataFixerResultImpl.Builder resultBuilder, PDFAFlavour flavour) {
        try {
            boolean isDeleted;
            if (this.isValidIdentification()) {
                int part = flavour.getPart().getPartNumber();
                Integer schemaPart = this.metadata.getIdentificationPart();
                if (schemaPart != null && schemaPart != part) {
                    return;
                }
            }
            if (isDeleted = this.metadata.deleteIdentificationSchema()) {
                this.setNeedToBeUpdated(true);
                resultBuilder.addFix("Identification schema removed");
                resultBuilder.status(MetadataFixerResult.RepairStatus.ID_REMOVED);
            }
        }
        catch (XMPException e) {
            LOGGER.debug((Object)"Can not obtain identification part.", (Throwable)e);
        }
    }

    public void addPDFIdentificationSchema(MetadataFixerResultImpl.Builder resultBuilder, PDFAFlavour flavour) {
        int part = flavour.getPart().getPartNumber();
        String conformance = flavour.getLevel().getCode().toUpperCase();
        try {
            if (this.isValidIdentification()) {
                Integer schemaPart = this.metadata.getIdentificationPart();
                String schemaConformance = this.metadata.getIdentificationConformance();
                if (schemaPart != null && schemaConformance != null && (schemaPart != part || MetadataImpl.compare(conformance, schemaConformance) <= 0)) {
                    return;
                }
            }
            this.metadata.setIdentificationPart(Integer.valueOf(part));
            this.metadata.setIdentificationConformance(conformance);
            this.setNeedToBeUpdated(true);
            resultBuilder.addFix("Identification schema added");
        }
        catch (XMPException e) {
            LOGGER.debug((Object)"Can not obtain identification fields.", (Throwable)e);
        }
    }

    private static int compare(String conf, String confToCompare) {
        int confInt = MetadataImpl.confToInt(conf);
        int confToCompareInt = MetadataImpl.confToInt(confToCompare);
        return confInt - confToCompareInt;
    }

    private static int confToInt(String conf) {
        switch (conf) {
            case "A": {
                return 2;
            }
            case "U": {
                return 1;
            }
            case "B": {
                return 0;
            }
        }
        throw new IllegalStateException("Method call with invalid conformance.");
    }

    private boolean isValidIdentification() {
        try {
            Integer identificationPart = this.metadata.getIdentificationPart();
            if (identificationPart == null) {
                return false;
            }
            String identificationConformance = this.metadata.getIdentificationConformance();
            if (identificationPart == 1) {
                return "A".equals(identificationConformance) || "B".equals(identificationConformance);
            }
            if (identificationPart == 2 || identificationPart == 3) {
                return "A".equals(this.metadata.getIdentificationConformance()) || "U".equals(identificationConformance) || "B".equals(identificationConformance);
            }
            return false;
        }
        catch (XMPException e) {
            LOGGER.debug((Object)"Can not obtain identification fields.", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public DublinCore getDublinCoreSchema(InfoDictionary info) {
        return new DublinCoreSchemaImpl(this.metadata, this);
    }

    public AdobePDF getAdobePDFSchema(InfoDictionary info) {
        return new AdobePDFSchemaImpl(this.metadata, this);
    }

    public XMPBasic getXMPBasicSchema(InfoDictionary info) {
        return new XMPBasicSchemaImpl(this.metadata, this);
    }

    public boolean isNeedToBeUpdated() {
        return this.stream.isNeedToBeUpdated();
    }

    public void setNeedToBeUpdated(boolean needToBeUpdated) {
        this.stream.setNeedToBeUpdated(true);
    }

    public void updateMetadataStream() throws IOException, XMPException {
        if (!this.stream.isNeedToBeUpdated()) {
            return;
        }
        try (OutputStream out = this.stream.createUnfilteredStream();){
            VeraPDFMeta.serialize((VeraPDFMeta)this.metadata, (OutputStream)out);
        }
    }
}

