/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.metadata.fixer.impl.pb.model;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.verapdf.metadata.fixer.entity.InfoDictionary;
import org.verapdf.metadata.fixer.utils.DateConverter;

public class InfoDictionaryImpl
implements InfoDictionary {
    private final PDDocumentInformation info;

    public InfoDictionaryImpl(PDDocumentInformation info) {
        if (info == null) {
            throw new IllegalArgumentException("Info dictionary representation can not be null");
        }
        this.info = info;
    }

    public String getTitle() {
        return this.info.getTitle();
    }

    public void setTitle(String title) {
        this.info.setTitle(title);
    }

    public String getSubject() {
        return this.info.getSubject();
    }

    public void setSubject(String subject) {
        this.info.setSubject(subject);
    }

    public String getAuthor() {
        return this.info.getAuthor();
    }

    public int getAuthorSize() {
        return this.info.getAuthor() != null ? 1 : 0;
    }

    public void setAuthor(String author) {
        this.info.setAuthor(author);
    }

    public String getProducer() {
        return this.info.getProducer();
    }

    public void setProducer(String producer) {
        this.info.setProducer(producer);
    }

    public String getKeywords() {
        return this.info.getKeywords();
    }

    public void setKeywords(String keywords) {
        this.info.setKeywords(keywords);
    }

    public String getCreator() {
        return this.info.getCreator();
    }

    public void setCreator(String creator) {
        this.info.setCreator(creator);
    }

    public String getCreationDate() {
        COSBase modDate = this.info.getCOSObject().getDictionaryObject(COSName.CREATION_DATE);
        return modDate instanceof COSString ? ((COSString)modDate).getString() : null;
    }

    public void setCreationDate(String creationDate) {
        this.info.getCOSObject().setString(COSName.CREATION_DATE, DateConverter.toPDFFormat(creationDate));
    }

    public String getModificationDate() {
        COSBase modDate = this.info.getCOSObject().getDictionaryObject(COSName.MOD_DATE);
        return modDate instanceof COSString ? ((COSString)modDate).getString() : null;
    }

    public void setModificationDate(String modificationDate) {
        this.info.getCOSObject().setString(COSName.MOD_DATE, DateConverter.toPDFFormat(modificationDate));
    }

    public boolean isNeedToBeUpdated() {
        return this.info.getCOSObject().isNeedToBeUpdated();
    }

    public void setNeedToBeUpdated(boolean needToBeUpdated) {
        this.info.getCOSObject().setNeedToBeUpdated(needToBeUpdated);
    }
}

