/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.cos;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.verapdf.model.coslayer.CosBBox;
import org.verapdf.model.impl.pb.cos.PBCosArray;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBCosBBox
extends PBCosArray
implements CosBBox {
    private static final Logger LOGGER = Logger.getLogger(PBCosBBox.class.getCanonicalName());
    public static final String COS_BBOX_TYPE = "CosBBox";
    private static final int LEFT_CORNER_POSITION = 0;
    private static final int BOTTOM_CORNER_POSITION = 1;
    private static final int RIGHT_CORNER_POSITION = 2;
    private static final int TOP_CORNER_POSITION = 3;

    public PBCosBBox(COSArray array, PDDocument document, PDFAFlavour flavour) {
        super(array, COS_BBOX_TYPE, document, flavour);
    }

    public Double gettop() {
        return this.getRequiredValue(3);
    }

    public Double getbottom() {
        return this.getRequiredValue(1);
    }

    public Double getleft() {
        return this.getRequiredValue(0);
    }

    public Double getright() {
        return this.getRequiredValue(2);
    }

    private Double getRequiredValue(int position) {
        COSArray array = (COSArray)this.baseObject;
        if (array.size() > position) {
            COSBase base = array.get(position);
            if (base instanceof COSNumber) {
                return ((COSNumber)base).doubleValue();
            }
            LOGGER.log(Level.INFO, "In bbox expected number but got " + base.getClass().getSimpleName());
        } else {
            LOGGER.log(Level.INFO, "Expected size of bbox array greater than" + position + "but got " + array.size());
        }
        return null;
    }
}

