/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.cos;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.verapdf.model.GenericModelObject;
import org.verapdf.model.coslayer.CosObject;
import org.verapdf.model.visitor.cos.pb.PBCosVisitor;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBCosObject
extends GenericModelObject
implements CosObject {
    private static final Logger LOGGER = Logger.getLogger(PBCosObject.class.getCanonicalName());
    public static final int MAX_NUMBER_OF_ELEMENTS = 1;
    protected final COSBase baseObject;

    protected PBCosObject(COSBase baseObject, String type) {
        super(type);
        this.baseObject = baseObject;
    }

    public static CosObject getFromValue(COSBase base, PDDocument document, PDFAFlavour flavour) {
        try {
            if (base != null) {
                PBCosVisitor visitor = PBCosVisitor.getInstance(document, flavour);
                if (base instanceof COSObject) {
                    return (CosObject)PBCosVisitor.visitFromObject((COSObject)base, document, flavour);
                }
                return (CosObject)base.accept((ICOSVisitor)visitor);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Problems with wrapping pdfbox object \"" + base.toString() + "\". " + e.getMessage());
        }
        return null;
    }
}

