/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.external;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.fontbox.cmap.CIDRange;
import org.apache.fontbox.cmap.CMap;
import org.apache.fontbox.cmap.CMapParser;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.verapdf.model.external.CMapFile;
import org.verapdf.model.impl.pb.external.PBoxExternal;

public class PBoxCMapFile
extends PBoxExternal
implements CMapFile {
    private static final Logger LOGGER = Logger.getLogger(PBoxCMapFile.class.getCanonicalName());
    public static final String CMAP_FILE_TYPE = "CMapFile";
    private final COSStream fileStream;

    public PBoxCMapFile(COSStream fileStream) {
        super(CMAP_FILE_TYPE);
        this.fileStream = fileStream;
    }

    public Long getWMode() {
        try {
            CMap map = new CMapParser().parse(this.fileStream.getUnfilteredStream());
            return map.getWMode();
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Could not parse CMap. " + e.getMessage());
            return null;
        }
    }

    public Long getdictWMode() {
        return this.fileStream.getInt(COSName.getPDFName((String)"WMode"), 0);
    }

    public Long getmaximalCID() {
        try {
            CMap map = new CMapParser().parse(this.fileStream.getUnfilteredStream());
            return Math.max(map.getCodeToCidRanges().stream().map(CIDRange::getMaxCid).max(Integer::compare).orElse(0), map.getCodeToCid().values().stream().max(Integer::compare).orElse(0));
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Could not get CID. " + e.getMessage());
            return null;
        }
    }
}

