/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.verapdf.model.GenericModelObject;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.impl.pb.pd.PBoxPDOutputIntent;
import org.verapdf.model.pdlayer.OutputIntents;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxOutputIntents
extends GenericModelObject
implements OutputIntents {
    public static final String OUTPUT_INTENTS_TYPE = "OutputIntents";
    public static final String OUTPUT_INTENTS = "outputIntents";
    List<PDOutputIntent> outInts = null;
    List<org.verapdf.model.pdlayer.PDOutputIntent> pbOutInts = null;
    private final PDDocument document;
    private final PDFAFlavour flavour;

    public PBoxOutputIntents(List<PDOutputIntent> outInts, PDDocument document, PDFAFlavour flavour) {
        super(OUTPUT_INTENTS_TYPE);
        this.outInts = outInts;
        this.document = document;
        this.flavour = flavour;
    }

    public Boolean getsameOutputProfileIndirect() {
        if (this.pbOutInts == null) {
            this.pbOutInts = this.parseOutputIntents();
        }
        String destOutputProfileIndirect = null;
        for (org.verapdf.model.pdlayer.PDOutputIntent outputIntent : this.pbOutInts) {
            String currentOutputProfile = outputIntent.getdestOutputProfileIndirect();
            if (destOutputProfileIndirect != null && currentOutputProfile != null && !destOutputProfileIndirect.equals(currentOutputProfile)) {
                return false;
            }
            destOutputProfileIndirect = destOutputProfileIndirect == null ? currentOutputProfile : destOutputProfileIndirect;
        }
        return true;
    }

    public String getoutputProfileIndirects() {
        return null;
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "outputIntents": {
                return this.getOutputIntents();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<org.verapdf.model.pdlayer.PDOutputIntent> parseOutputIntents() {
        ArrayList<org.verapdf.model.pdlayer.PDOutputIntent> res = new ArrayList<org.verapdf.model.pdlayer.PDOutputIntent>(this.outInts.size());
        for (PDOutputIntent outInt : this.outInts) {
            res.add(new PBoxPDOutputIntent(outInt));
        }
        return res;
    }

    private List<org.verapdf.model.pdlayer.PDOutputIntent> getOutputIntents() {
        if (this.pbOutInts == null) {
            this.pbOutInts = this.parseOutputIntents();
        }
        return this.pbOutInts;
    }

    public String getColorSpace() {
        if (this.pbOutInts == null) {
            this.pbOutInts = this.parseOutputIntents();
        }
        for (org.verapdf.model.pdlayer.PDOutputIntent outputIntent : this.pbOutInts) {
            String colorSpace = ((PBoxPDOutputIntent)outputIntent).getColorSpace();
            if (colorSpace == null) continue;
            return colorSpace;
        }
        return null;
    }
}

