/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd.images;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.PDPostScriptXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObjectProxy;
import org.verapdf.model.coslayer.CosDict;
import org.verapdf.model.impl.pb.cos.PBCosDict;
import org.verapdf.model.impl.pb.pd.PBoxPDResource;
import org.verapdf.model.impl.pb.pd.images.PBoxPDXForm;
import org.verapdf.model.impl.pb.pd.images.PBoxPDXImage;
import org.verapdf.model.pdlayer.PDXObject;
import org.verapdf.model.tools.resources.PDInheritableResources;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDXObject
extends PBoxPDResource
implements PDXObject {
    protected final PDDocument document;
    protected final PDFAFlavour flavour;
    public static final String X_OBJECT_TYPE = "PDXObject";
    public static final String OPI = "OPI";
    protected final PDInheritableResources resources;
    private final String subtype;

    public PBoxPDXObject(org.apache.pdfbox.pdmodel.graphics.PDXObject simplePDObject, PDDocument document, PDFAFlavour flavour) {
        this((COSObjectable)simplePDObject, PDInheritableResources.EMPTY_EXTENDED_RESOURCES, X_OBJECT_TYPE, document, flavour);
    }

    protected PBoxPDXObject(COSObjectable simplePDObject, PDInheritableResources resources, String type, PDDocument document, PDFAFlavour flavour) {
        super(simplePDObject, type);
        this.resources = resources;
        this.subtype = PBoxPDXObject.getSubtype((org.apache.pdfbox.pdmodel.graphics.PDXObject)this.simplePDObject);
        this.document = document;
        this.flavour = flavour;
    }

    private static String getSubtype(org.apache.pdfbox.pdmodel.graphics.PDXObject object) {
        COSBase base = object.getCOSStream().getDictionaryObject(COSName.SUBTYPE);
        return base instanceof COSName ? ((COSName)base).getName() : null;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public Boolean getcontainsOPI() {
        COSBase pageObject = this.simplePDObject.getCOSObject();
        return pageObject != null && pageObject instanceof COSDictionary && ((COSDictionary)pageObject).containsKey(COSName.getPDFName((String)OPI));
    }

    public Boolean getcontainsSMask() {
        COSBase pageObject = this.simplePDObject.getCOSObject();
        return pageObject != null && pageObject instanceof COSDictionary && ((COSDictionary)pageObject).containsKey(COSName.SMASK);
    }

    public static PDXObject getTypedPDXObject(org.apache.pdfbox.pdmodel.graphics.PDXObject pbObject, PDInheritableResources extendedResources, PDDocument document, PDFAFlavour flavour) {
        if (pbObject instanceof PDFormXObject) {
            PDFormXObject object = (PDFormXObject)pbObject;
            PDInheritableResources resources = extendedResources.getExtendedResources(object.getResources());
            return new PBoxPDXForm(object, resources, document, flavour);
        }
        if (pbObject instanceof PDImageXObjectProxy) {
            return new PBoxPDXImage((PDImageXObjectProxy)pbObject, extendedResources, document, flavour);
        }
        if (pbObject instanceof PDPostScriptXObject) {
            return new PBoxPDXObject(pbObject, document, flavour);
        }
        return null;
    }

    protected List<CosDict> getLinkToDictionary(String key) {
        COSStream object = ((org.apache.pdfbox.pdmodel.graphics.PDXObject)this.simplePDObject).getCOSStream();
        COSBase item = object.getDictionaryObject(COSName.getPDFName((String)key));
        if (item instanceof COSDictionary) {
            ArrayList<PBCosDict> list = new ArrayList<PBCosDict>(1);
            list.add(new PBCosDict((COSDictionary)item, this.document, this.flavour));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }
}

