/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.factory.colors;

import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.graphics.color.PDCalGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDCalRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.color.PDIndexed;
import org.apache.pdfbox.pdmodel.graphics.color.PDLab;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDShadingPattern;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;
import org.verapdf.model.impl.pb.containers.StaticContainers;
import org.verapdf.model.impl.pb.pd.colors.PBoxPDCalGray;
import org.verapdf.model.impl.pb.pd.colors.PBoxPDCalRGB;
import org.verapdf.model.impl.pb.pd.colors.PBoxPDDeviceCMYK;
import org.verapdf.model.impl.pb.pd.colors.PBoxPDDeviceGray;
import org.verapdf.model.impl.pb.pd.colors.PBoxPDDeviceN;
import org.verapdf.model.impl.pb.pd.colors.PBoxPDDeviceRGB;
import org.verapdf.model.impl.pb.pd.colors.PBoxPDICCBased;
import org.verapdf.model.impl.pb.pd.colors.PBoxPDICCBasedCMYK;
import org.verapdf.model.impl.pb.pd.colors.PBoxPDIndexed;
import org.verapdf.model.impl.pb.pd.colors.PBoxPDLab;
import org.verapdf.model.impl.pb.pd.colors.PBoxPDSeparation;
import org.verapdf.model.impl.pb.pd.pattern.PBoxPDShadingPattern;
import org.verapdf.model.impl.pb.pd.pattern.PBoxPDTilingPattern;
import org.verapdf.model.pdlayer.PDPattern;
import org.verapdf.model.tools.resources.PDInheritableResources;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class ColorSpaceFactory {
    public static final String CAL_GRAY = "CalGray";
    public static final String CAL_RGB = "CalRGB";
    public static final String DEVICE_CMYK = "DeviceCMYK";
    public static final String DEVICE_GRB = "DeviceRGB";
    public static final String DEVICE_GRAY = "DeviceGray";
    public static final String DEVICE_N = "DeviceN";
    public static final String ICC_BASED = "ICCBased";
    public static final String LAB = "Lab";
    public static final String SEPARATION = "Separation";
    public static final String INDEXED = "Indexed";
    public static final String PATTERN = "Pattern";

    private ColorSpaceFactory() {
    }

    public static org.verapdf.model.pdlayer.PDColorSpace getColorSpace(PDColorSpace colorSpace, PDDocument document, PDFAFlavour flavour) {
        return ColorSpaceFactory.getColorSpace(colorSpace, null, PDInheritableResources.EMPTY_EXTENDED_RESOURCES, 0, false, document, flavour);
    }

    public static org.verapdf.model.pdlayer.PDColorSpace getColorSpace(PDColorSpace colorSpace, PDAbstractPattern pattern, PDInheritableResources resources, int opm, boolean overprintingFlag, PDDocument document, PDFAFlavour flavour) {
        if (colorSpace == null) {
            return null;
        }
        if (StaticContainers.cachedColorSpaces.containsKey(colorSpace)) {
            return StaticContainers.cachedColorSpaces.get(colorSpace);
        }
        switch (colorSpace.getName()) {
            case "CalGray": {
                PBoxPDCalGray result = new PBoxPDCalGray((PDCalGray)colorSpace);
                StaticContainers.cachedColorSpaces.put(colorSpace, result);
                return result;
            }
            case "CalRGB": {
                PBoxPDCalRGB result = new PBoxPDCalRGB((PDCalRGB)colorSpace);
                StaticContainers.cachedColorSpaces.put(colorSpace, result);
                return result;
            }
            case "DeviceN": {
                PBoxPDDeviceN result = new PBoxPDDeviceN((PDDeviceN)colorSpace, document, flavour);
                StaticContainers.cachedColorSpaces.put(colorSpace, result);
                return result;
            }
            case "DeviceCMYK": {
                return PBoxPDDeviceCMYK.getInstance();
            }
            case "DeviceRGB": {
                return PBoxPDDeviceRGB.getInstance();
            }
            case "DeviceGray": {
                return PBoxPDDeviceGray.getInstance();
            }
            case "ICCBased": {
                if (colorSpace.getNumberOfComponents() != 4) {
                    PBoxPDICCBased result = new PBoxPDICCBased((PDICCBased)colorSpace);
                    StaticContainers.cachedColorSpaces.put(colorSpace, result);
                    return result;
                }
                PBoxPDICCBasedCMYK result = new PBoxPDICCBasedCMYK((PDICCBased)colorSpace, opm, overprintingFlag);
                StaticContainers.cachedColorSpaces.put(colorSpace, result);
                return result;
            }
            case "Lab": {
                PBoxPDLab result = new PBoxPDLab((PDLab)colorSpace);
                StaticContainers.cachedColorSpaces.put(colorSpace, result);
                return result;
            }
            case "Separation": {
                PBoxPDSeparation result = new PBoxPDSeparation((PDSeparation)colorSpace, document, flavour);
                StaticContainers.cachedColorSpaces.put(colorSpace, result);
                return result;
            }
            case "Indexed": {
                PBoxPDIndexed result = new PBoxPDIndexed((PDIndexed)colorSpace, document, flavour);
                StaticContainers.cachedColorSpaces.put(colorSpace, result);
                return result;
            }
            case "Pattern": {
                return ColorSpaceFactory.getPattern(pattern, resources, document, flavour);
            }
        }
        return null;
    }

    public static PDPattern getPattern(PDAbstractPattern pattern, PDInheritableResources resources, PDDocument document, PDFAFlavour flavour) {
        if (pattern != null) {
            if (pattern.getPatternType() == 2) {
                return new PBoxPDShadingPattern((PDShadingPattern)pattern, document, flavour);
            }
            if (pattern.getPatternType() == 1) {
                PDTilingPattern tiling = (PDTilingPattern)pattern;
                PDInheritableResources pdResources = resources.getExtendedResources(tiling.getResources());
                return new PBoxPDTilingPattern(tiling, pdResources, document, flavour);
            }
        }
        return null;
    }
}

