/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd.font;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDFontLike;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDType3CharProc;
import org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.apache.pdfbox.pdmodel.font.encoding.Encoding;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;
import org.verapdf.model.impl.pb.pd.PBoxPDContentStream;
import org.verapdf.model.impl.pb.pd.font.PBoxPDSimpleFont;
import org.verapdf.model.pdlayer.PDContentStream;
import org.verapdf.model.tools.resources.PDInheritableResources;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDType3Font
extends PBoxPDSimpleFont
implements org.verapdf.model.pdlayer.PDType3Font {
    public static final String TYPE3_FONT_TYPE = "PDType3Font";
    public static final String CHAR_STRINGS = "charStrings";
    private final PDInheritableResources resources;
    private final PDDocument document;
    private final PDFAFlavour flavour;
    private Map<String, PDContentStream> charStrings = null;

    public PBoxPDType3Font(PDFontLike font, RenderingMode renderingMode, PDInheritableResources resources, PDDocument document, PDFAFlavour flavour) {
        super(font, renderingMode, TYPE3_FONT_TYPE);
        this.resources = resources;
        this.document = document;
        this.flavour = flavour;
    }

    @Override
    public Boolean getisStandard() {
        return Boolean.FALSE;
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        if (CHAR_STRINGS.equals(link)) {
            return this.getCharStrings();
        }
        return super.getLinkedObjects(link);
    }

    private List<PDContentStream> getCharStrings() {
        if (this.charStrings == null) {
            this.parseCharStrings();
        }
        return new ArrayList<PDContentStream>(this.charStrings.values());
    }

    public Map<String, PDContentStream> getCharProcStreams() {
        if (this.charStrings == null) {
            this.parseCharStrings();
        }
        return Collections.unmodifiableMap(this.charStrings);
    }

    public Encoding getEncodingObject() {
        if (this.pdFontLike instanceof PDSimpleFont) {
            return ((PDSimpleFont)this.pdFontLike).getEncoding();
        }
        return null;
    }

    private void parseCharStrings() {
        COSDictionary charProcDict = ((PDType3Font)this.pdFontLike).getCharProcs();
        if (charProcDict != null) {
            Set keySet = charProcDict.keySet();
            HashMap<String, PBoxPDContentStream> map = new HashMap<String, PBoxPDContentStream>(keySet.size());
            for (COSName cosName : keySet) {
                PDType3CharProc charProc = ((PDType3Font)this.pdFontLike).getCharProc(cosName);
                PBoxPDContentStream contentStream = new PBoxPDContentStream((org.apache.pdfbox.contentstream.PDContentStream)charProc, this.resources, this.document, this.flavour);
                map.put(cosName.getName(), contentStream);
            }
            this.charStrings = Collections.unmodifiableMap(map);
        } else {
            this.charStrings = Collections.emptyMap();
        }
    }
}

