/**
 * This file is part of veraPDF PDF Box PDF/A Validation Model Implementation, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF PDF Box PDF/A Validation Model Implementation is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF PDF Box PDF/A Validation Model Implementation as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF PDF Box PDF/A Validation Model Implementation as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
/**
 * 
 */
package org.verapdf.pdfbox.foundry;

import org.verapdf.pdfa.Foundries;
import org.verapdf.pdfa.VeraFoundryProvider;
import org.verapdf.pdfa.VeraPDFFoundry;

/**
 * @author <a href="mailto:carl@openpreservation.org">Carl Wilson</a>
 *         <a href="https://github.com/carlwilson">carlwilson AT github</a>
 *
 * @version 0.1
 * 
 *          Created 26 Oct 2016:22:24:12
 */

public class PdfBoxFoundryProvider implements VeraFoundryProvider {
	private static final VeraFoundryProvider instance = new PdfBoxFoundryProvider();

	private PdfBoxFoundryProvider() {
	}

	public static void initialise() {
		Foundries.registerDefaultProvider(instance);
	}

	/**
	 * @see org.verapdf.pdfa.VeraFoundryProvider#getInstance()
	 */
	@Override
	public VeraPDFFoundry getInstance() {
		return PdfBoxFoundry.getInstance();
	}

}
