/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd.images;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.verapdf.model.coslayer.CosIIFilter;
import org.verapdf.model.coslayer.CosRenderingIntent;
import org.verapdf.model.factory.colors.ColorSpaceFactory;
import org.verapdf.model.impl.pb.cos.PBCosIIFilter;
import org.verapdf.model.impl.pb.cos.PBCosRenderingIntent;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.pdlayer.PDColorSpace;
import org.verapdf.model.pdlayer.PDInlineImage;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDInlineImage
extends PBoxPDObject
implements PDInlineImage {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDInlineImage.class.getCanonicalName());
    public static final String F = "F";
    public static final String INLINE_IMAGE_TYPE = "PDInlineImage";
    private final PDDocument document;
    private final PDFAFlavour flavour;

    public PBoxPDInlineImage(org.apache.pdfbox.pdmodel.graphics.image.PDInlineImage simplePDObject, PDDocument document, PDFAFlavour flavour) {
        super((COSObjectable)simplePDObject, INLINE_IMAGE_TYPE);
        this.document = document;
        this.flavour = flavour;
    }

    public Boolean getInterpolate() {
        return ((PDImage)this.simplePDObject).getInterpolate();
    }

    public String getSubtype() {
        return null;
    }

    public Boolean getisInherited() {
        return Boolean.FALSE;
    }

    public Boolean getcontainsOPI() {
        COSBase pageObject = this.simplePDObject.getCOSObject();
        return pageObject != null && pageObject instanceof COSDictionary && ((COSDictionary)pageObject).containsKey(COSName.getPDFName((String)"OPI"));
    }

    public Boolean getcontainsSMask() {
        COSBase pageObject = this.simplePDObject.getCOSObject();
        return pageObject != null && pageObject instanceof COSDictionary && ((COSDictionary)pageObject).containsKey(COSName.SMASK);
    }

    public Boolean getcontainsAlternates() {
        COSBase pageObject = this.simplePDObject.getCOSObject();
        return pageObject != null && pageObject instanceof COSDictionary && ((COSDictionary)pageObject).containsKey(COSName.getPDFName((String)"Alternates"));
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Intent": {
                return this.getIntent();
            }
            case "imageCS": {
                return this.getImageCS();
            }
            case "SMask": 
            case "OPI": 
            case "Alternates": 
            case "jpxStream": {
                return Collections.emptyList();
            }
            case "F": {
                return this.getFilters();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<CosIIFilter> getFilters() {
        List filters = ((org.apache.pdfbox.pdmodel.graphics.image.PDInlineImage)this.simplePDObject).getFilters();
        ArrayList<CosIIFilter> result = new ArrayList<CosIIFilter>();
        if (filters != null) {
            for (String filter : filters) {
                result.add(new PBCosIIFilter(filter));
            }
        }
        return result;
    }

    private List<PDColorSpace> getImageCS() {
        try {
            PDColorSpace buffer = ColorSpaceFactory.getColorSpace(((PDImage)this.simplePDObject).getColorSpace(), this.document, this.flavour);
            if (buffer != null) {
                ArrayList<PDColorSpace> colorSpaces = new ArrayList<PDColorSpace>(1);
                colorSpaces.add(buffer);
                return Collections.unmodifiableList(colorSpaces);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Problems with color space obtaining from InlineImage XObject. " + e.getMessage());
        }
        return Collections.emptyList();
    }

    private List<CosRenderingIntent> getIntent() {
        COSDictionary imageStream = (COSDictionary)this.simplePDObject.getCOSObject();
        COSName intent = imageStream.getCOSName(COSName.getPDFName((String)"Intent"));
        if (intent != null) {
            ArrayList<PBCosRenderingIntent> intents = new ArrayList<PBCosRenderingIntent>(1);
            intents.add(new PBCosRenderingIntent(intent));
            return Collections.unmodifiableList(intents);
        }
        return Collections.emptyList();
    }
}

