/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.acroforms;

import java.io.File;
import java.io.IOException;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceCharacteristicsDictionary;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDTextField;

public class CreateFormField {
    public static void main(String[] args) throws IOException {
        PDDocument document = new PDDocument();
        PDPage page = new PDPage(PDRectangle.A4);
        document.addPage(page);
        String dir = "../pdfbox/src/main/resources/org/apache/pdfbox/resources/ttf/";
        PDType0Font font = PDType0Font.load((PDDocument)document, (File)new File(dir + "LiberationSans-Regular.ttf"));
        PDAcroForm acroForm = new PDAcroForm(document);
        document.getDocumentCatalog().setAcroForm(acroForm);
        PDResources res = new PDResources();
        COSName fontName = res.add((PDFont)font);
        acroForm.setDefaultResources(res);
        String da = "/" + fontName.getName() + " 12 Tf 0 g";
        acroForm.setDefaultAppearance(da);
        PDTextField textBox = new PDTextField(acroForm);
        textBox.setPartialName("SampleField");
        acroForm.getFields().add(textBox);
        PDAnnotationWidget widget = (PDAnnotationWidget)textBox.getWidgets().get(0);
        PDRectangle rect = new PDRectangle();
        rect.setLowerLeftX(50.0f);
        rect.setLowerLeftY(750.0f);
        rect.setUpperRightX(250.0f);
        rect.setUpperRightY(800.0f);
        widget.setRectangle(rect);
        PDAppearanceCharacteristicsDictionary fieldAppearance = new PDAppearanceCharacteristicsDictionary(new COSDictionary());
        PDColor green = new PDColor(new float[]{0.0f, 1.0f, 0.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE);
        fieldAppearance.setBorderColour(green);
        widget.setAppearanceCharacteristics(fieldAppearance);
        page.getAnnotations().add(widget);
        textBox.setValue("English form contents");
        document.save("exampleForm.pdf");
        document.close();
    }
}

