/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;
import org.apache.pdfbox.pdmodel.common.function.PDFunctionType2;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType2;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType3;
import org.apache.pdfbox.rendering.PDFRenderer;

public class CreateGradientShadingPDF {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(String file) throws IOException {
        PDDocument document = null;
        try {
            document = new PDDocument();
            PDPage page = new PDPage();
            document.addPage(page);
            COSDictionary fdict = new COSDictionary();
            fdict.setInt(COSName.FUNCTION_TYPE, 2);
            COSArray domain = new COSArray();
            domain.add((COSBase)COSInteger.get((long)0L));
            domain.add((COSBase)COSInteger.get((long)1L));
            COSArray c0 = new COSArray();
            c0.add((COSBase)COSFloat.get((String)"1"));
            c0.add((COSBase)COSFloat.get((String)"0"));
            c0.add((COSBase)COSFloat.get((String)"0"));
            COSArray c1 = new COSArray();
            c1.add((COSBase)COSFloat.get((String)"0.5"));
            c1.add((COSBase)COSFloat.get((String)"1"));
            c1.add((COSBase)COSFloat.get((String)"0.5"));
            fdict.setItem(COSName.DOMAIN, (COSBase)domain);
            fdict.setItem(COSName.C0, (COSBase)c0);
            fdict.setItem(COSName.C1, (COSBase)c1);
            fdict.setInt(COSName.N, 1);
            PDFunctionType2 func = new PDFunctionType2((COSBase)fdict);
            PDShadingType2 axialShading = new PDShadingType2(new COSDictionary());
            axialShading.setColorSpace((PDColorSpace)PDDeviceRGB.INSTANCE);
            axialShading.setShadingType(2);
            COSArray coords1 = new COSArray();
            coords1.add((COSBase)COSInteger.get((long)100L));
            coords1.add((COSBase)COSInteger.get((long)400L));
            coords1.add((COSBase)COSInteger.get((long)400L));
            coords1.add((COSBase)COSInteger.get((long)600L));
            axialShading.setCoords(coords1);
            axialShading.setFunction((PDFunction)func);
            PDShadingType3 radialShading = new PDShadingType3(new COSDictionary());
            radialShading.setColorSpace((PDColorSpace)PDDeviceRGB.INSTANCE);
            radialShading.setShadingType(3);
            COSArray coords2 = new COSArray();
            coords2.add((COSBase)COSInteger.get((long)100L));
            coords2.add((COSBase)COSInteger.get((long)400L));
            coords2.add((COSBase)COSInteger.get((long)50L));
            coords2.add((COSBase)COSInteger.get((long)400L));
            coords2.add((COSBase)COSInteger.get((long)600L));
            coords2.add((COSBase)COSInteger.get((long)150L));
            radialShading.setCoords(coords2);
            radialShading.setFunction((PDFunction)func);
            PDPageContentStream contentStream = new PDPageContentStream(document, page, true, false);
            contentStream.shadingFill((PDShading)axialShading);
            contentStream.shadingFill((PDShading)radialShading);
            contentStream.close();
            document.save(file);
            document.close();
            document = PDDocument.load((File)new File(file));
            BufferedImage bim = new PDFRenderer(document).renderImageWithDPI(0, 300.0f);
            ImageIO.write((RenderedImage)bim, "png", new File(file + ".png"));
            document.close();
        }
        finally {
            if (document != null) {
                document.close();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            CreateGradientShadingPDF.usage();
        } else {
            CreateGradientShadingPDF creator = new CreateGradientShadingPDF();
            creator.create(args[0]);
        }
    }

    private static void usage() {
        System.err.println("usage: java org.apache.pdfbox.examples.pdmodel.CreateGradientShadingPDF <outputfile.pdf>");
    }
}

