/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.util.Matrix;

public class CreateLandscapePDF {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt(String message, String outfile) throws IOException {
        PDDocument doc = null;
        try {
            doc = new PDDocument();
            PDType1Font font = PDType1Font.HELVETICA;
            PDPage page = new PDPage(PDRectangle.A4);
            page.setRotation(90);
            doc.addPage(page);
            PDRectangle pageSize = page.getMediaBox();
            float pageWidth = pageSize.getWidth();
            float fontSize = 12.0f;
            float stringWidth = font.getStringWidth(message) * fontSize / 1000.0f;
            float startX = 100.0f;
            float startY = 100.0f;
            PDPageContentStream contentStream = new PDPageContentStream(doc, page, false, false);
            contentStream.transform(new Matrix(0.0f, 1.0f, -1.0f, 0.0f, pageWidth, 0.0f));
            contentStream.setFont((PDFont)font, fontSize);
            contentStream.beginText();
            contentStream.newLineAtOffset(startX, startY);
            contentStream.showText(message);
            contentStream.newLineAtOffset(0.0f, 100.0f);
            contentStream.showText(message);
            contentStream.newLineAtOffset(100.0f, 100.0f);
            contentStream.showText(message);
            contentStream.endText();
            contentStream.moveTo(startX - 2.0f, startY - 2.0f);
            contentStream.lineTo(startX - 2.0f, startY + 200.0f + fontSize);
            contentStream.stroke();
            contentStream.moveTo(startX - 2.0f, startY + 200.0f + fontSize);
            contentStream.lineTo(startX + 100.0f + stringWidth + 2.0f, startY + 200.0f + fontSize);
            contentStream.stroke();
            contentStream.moveTo(startX + 100.0f + stringWidth + 2.0f, startY + 200.0f + fontSize);
            contentStream.lineTo(startX + 100.0f + stringWidth + 2.0f, startY - 2.0f);
            contentStream.stroke();
            contentStream.moveTo(startX + 100.0f + stringWidth + 2.0f, startY - 2.0f);
            contentStream.lineTo(startX - 2.0f, startY - 2.0f);
            contentStream.stroke();
            contentStream.close();
            doc.save(outfile);
        }
        finally {
            if (doc != null) {
                doc.close();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        CreateLandscapePDF app = new CreateLandscapePDF();
        if (args.length != 2) {
            app.usage();
        } else {
            app.doIt(args[0], args[1]);
        }
    }

    private void usage() {
        System.err.println("usage: " + this.getClass().getName() + " <Message> <output-file>");
    }
}

