/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationFileAttachment;

public class ExtractEmbeddedFiles {
    private ExtractEmbeddedFiles() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            ExtractEmbeddedFiles.usage();
            System.exit(1);
        } else {
            PDDocument document = null;
            try {
                File pdfFile = new File(args[0]);
                String filePath = pdfFile.getParent() + System.getProperty("file.separator");
                document = PDDocument.load((File)pdfFile);
                PDDocumentNameDictionary namesDictionary = new PDDocumentNameDictionary(document.getDocumentCatalog());
                PDEmbeddedFilesNameTreeNode efTree = namesDictionary.getEmbeddedFiles();
                if (efTree != null) {
                    Map names = efTree.getNames();
                    if (names != null) {
                        ExtractEmbeddedFiles.extractFiles(names, filePath);
                    } else {
                        List kids = efTree.getKids();
                        for (PDNameTreeNode node : kids) {
                            names = node.getNames();
                            ExtractEmbeddedFiles.extractFiles(names, filePath);
                        }
                    }
                }
                for (PDPage page : document.getPages()) {
                    for (PDAnnotation annotation : page.getAnnotations()) {
                        if (!(annotation instanceof PDAnnotationFileAttachment)) continue;
                        PDAnnotationFileAttachment annotationFileAttachment = (PDAnnotationFileAttachment)annotation;
                        PDComplexFileSpecification fileSpec = (PDComplexFileSpecification)annotationFileAttachment.getFile();
                        PDEmbeddedFile embeddedFile = ExtractEmbeddedFiles.getEmbeddedFile(fileSpec);
                        ExtractEmbeddedFiles.extractFile(filePath, fileSpec.getFilename(), embeddedFile);
                    }
                }
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    private static void extractFiles(Map<String, PDComplexFileSpecification> names, String filePath) throws IOException {
        for (Map.Entry<String, PDComplexFileSpecification> entry : names.entrySet()) {
            String filename = entry.getKey();
            PDComplexFileSpecification fileSpec = entry.getValue();
            PDEmbeddedFile embeddedFile = ExtractEmbeddedFiles.getEmbeddedFile(fileSpec);
            ExtractEmbeddedFiles.extractFile(filePath, filename, embeddedFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractFile(String filePath, String filename, PDEmbeddedFile embeddedFile) throws IOException {
        String embeddedFilename = filePath + filename;
        File file = new File(filePath + filename);
        System.out.println("Writing " + embeddedFilename);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(embeddedFile.getByteArray());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)fos);
    }

    private static PDEmbeddedFile getEmbeddedFile(PDComplexFileSpecification fileSpec) {
        PDEmbeddedFile embeddedFile = null;
        if (fileSpec != null) {
            embeddedFile = fileSpec.getEmbeddedFileUnicode();
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileDos();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileMac();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileUnix();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFile();
            }
        }
        return embeddedFile;
    }

    private static void usage() {
        System.err.println("Usage: java " + ExtractEmbeddedFiles.class.getName() + " <input-pdf>");
    }
}

