/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.File;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.AdobePDFSchema;
import org.apache.xmpbox.schema.DublinCoreSchema;
import org.apache.xmpbox.schema.XMPBasicSchema;
import org.apache.xmpbox.xml.DomXmpParser;
import org.apache.xmpbox.xml.XmpParsingException;

public class ExtractMetadata {
    private ExtractMetadata() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        block13: {
            if (args.length != 1) {
                ExtractMetadata.usage();
                System.exit(1);
            } else {
                PDDocument document = null;
                try {
                    document = PDDocument.load((File)new File(args[0]));
                    PDDocumentCatalog catalog = document.getDocumentCatalog();
                    PDMetadata meta = catalog.getMetadata();
                    if (meta != null) {
                        DomXmpParser xmpParser = new DomXmpParser();
                        try {
                            XMPBasicSchema basic;
                            AdobePDFSchema pdf;
                            XMPMetadata metadata = xmpParser.parse(meta.createInputStream());
                            DublinCoreSchema dc = metadata.getDublinCoreSchema();
                            if (dc != null) {
                                ExtractMetadata.display("Title:", dc.getTitle());
                                ExtractMetadata.display("Description:", dc.getDescription());
                                ExtractMetadata.listString("Creators: ", dc.getCreators());
                                ExtractMetadata.listCalendar("Dates:", dc.getDates());
                                ExtractMetadata.listString("Subjects:", dc.getSubjects());
                            }
                            if ((pdf = metadata.getAdobePDFSchema()) != null) {
                                ExtractMetadata.display("Keywords:", pdf.getKeywords());
                                ExtractMetadata.display("PDF Version:", pdf.getPDFVersion());
                                ExtractMetadata.display("PDF Producer:", pdf.getProducer());
                            }
                            if ((basic = metadata.getXMPBasicSchema()) != null) {
                                ExtractMetadata.display("Create Date:", basic.getCreateDate());
                                ExtractMetadata.display("Modify Date:", basic.getModifyDate());
                                ExtractMetadata.display("Creator Tool:", basic.getCreatorTool());
                            }
                            break block13;
                        }
                        catch (XmpParsingException e) {
                            System.err.println("An error ouccred when parsing the meta data: " + e.getMessage());
                        }
                        break block13;
                    }
                    PDDocumentInformation information = document.getDocumentInformation();
                    if (information != null) {
                        ExtractMetadata.showDocumentInformation(information);
                    }
                }
                finally {
                    if (document != null) {
                        document.close();
                    }
                }
            }
        }
    }

    private static void showDocumentInformation(PDDocumentInformation information) {
        ExtractMetadata.display("Title:", information.getTitle());
        ExtractMetadata.display("Subject:", information.getSubject());
        ExtractMetadata.display("Author:", information.getAuthor());
        ExtractMetadata.display("Creator:", information.getCreator());
        ExtractMetadata.display("Producer:", information.getProducer());
    }

    private static void listString(String title, List<String> list) {
        if (list == null) {
            return;
        }
        System.out.println(title);
        for (String string : list) {
            System.out.println("  " + string);
        }
    }

    private static void listCalendar(String title, List<Calendar> list) {
        if (list == null) {
            return;
        }
        System.out.println(title);
        for (Calendar calendar : list) {
            System.out.println("  " + ExtractMetadata.format(calendar));
        }
    }

    private static String format(Object o) {
        if (o instanceof Calendar) {
            Calendar cal = (Calendar)o;
            return DateFormat.getDateInstance().format(cal.getTime());
        }
        return o.toString();
    }

    private static void display(String title, Object value) {
        if (value != null) {
            System.out.println(title + " " + ExtractMetadata.format(value));
        }
    }

    private static void usage() {
        System.err.println("Usage: java " + ExtractMetadata.class.getName() + " <input-pdf>");
    }
}

