/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.text.PDFTextStripperByArea;

public class PrintURLs {
    private PrintURLs() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        PDDocument doc = null;
        try {
            if (args.length != 1) {
                PrintURLs.usage();
            } else {
                doc = PDDocument.load((File)new File(args[0]));
                int pageNum = 0;
                for (PDPage page : doc.getPages()) {
                    PDAnnotationLink link;
                    PDAnnotation annot;
                    int j;
                    ++pageNum;
                    PDFTextStripperByArea stripper = new PDFTextStripperByArea();
                    List annotations = page.getAnnotations();
                    for (j = 0; j < annotations.size(); ++j) {
                        annot = (PDAnnotation)annotations.get(j);
                        if (!(annot instanceof PDAnnotationLink)) continue;
                        link = (PDAnnotationLink)annot;
                        PDRectangle rect = link.getRectangle();
                        float x = rect.getLowerLeftX();
                        float y = rect.getUpperRightY();
                        float width = rect.getWidth();
                        float height = rect.getHeight();
                        int rotation = page.getRotation();
                        if (rotation == 0) {
                            PDRectangle pageSize = page.getMediaBox();
                            y = pageSize.getHeight() - y;
                        } else if (rotation == 90) {
                            // empty if block
                        }
                        Rectangle2D.Float awtRect = new Rectangle2D.Float(x, y, width, height);
                        stripper.addRegion("" + j, (Rectangle2D)awtRect);
                    }
                    stripper.extractRegions(page);
                    for (j = 0; j < annotations.size(); ++j) {
                        annot = (PDAnnotation)annotations.get(j);
                        if (!(annot instanceof PDAnnotationLink)) continue;
                        link = (PDAnnotationLink)annot;
                        PDAction action = link.getAction();
                        String urlText = stripper.getTextForRegion("" + j);
                        if (!(action instanceof PDActionURI)) continue;
                        PDActionURI uri = (PDActionURI)action;
                        System.out.println("Page " + pageNum + ":'" + urlText + "'=" + uri.getURI());
                    }
                }
            }
        }
        finally {
            if (doc != null) {
                doc.close();
            }
        }
    }

    private static void usage() {
        System.err.println("usage: " + PrintURLs.class.getName() + " <input-file>");
    }
}

