/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationRubberStamp;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;

public class RubberStampWithImage {
    private static final String SAVE_GRAPHICS_STATE = "q\n";
    private static final String RESTORE_GRAPHICS_STATE = "Q\n";
    private static final String CONCATENATE_MATRIX = "cm\n";
    private static final String XOBJECT_DO = "Do\n";
    private static final String SPACE = " ";
    private static final NumberFormat formatDecimal = NumberFormat.getNumberInstance(Locale.US);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt(String[] args) throws IOException {
        if (args.length != 3) {
            this.usage();
        } else {
            PDDocument document = null;
            try {
                document = PDDocument.load((File)new File(args[0]));
                if (document.isEncrypted()) {
                    throw new IOException("Encrypted documents are not supported for this example");
                }
                for (int i = 0; i < document.getNumberOfPages(); ++i) {
                    PDPage page = document.getPage(i);
                    List annotations = page.getAnnotations();
                    PDAnnotationRubberStamp rubberStamp = new PDAnnotationRubberStamp();
                    rubberStamp.setName("TopSecret");
                    rubberStamp.setRectangle(new PDRectangle(200.0f, 100.0f));
                    rubberStamp.setContents("A top secret note");
                    PDImageXObject ximage = PDImageXObject.createFromFile((String)args[2], (PDDocument)document);
                    int lowerLeftX = 250;
                    int lowerLeftY = 550;
                    int formWidth = 150;
                    int formHeight = 25;
                    int imgWidth = 50;
                    int imgHeight = 25;
                    PDRectangle rect = new PDRectangle();
                    rect.setLowerLeftX((float)lowerLeftX);
                    rect.setLowerLeftY((float)lowerLeftY);
                    rect.setUpperRightX((float)(lowerLeftX + formWidth));
                    rect.setUpperRightY((float)(lowerLeftY + formHeight));
                    PDStream stream = new PDStream(document);
                    OutputStream os = stream.createOutputStream();
                    PDFormXObject form = new PDFormXObject(stream);
                    form.setResources(new PDResources());
                    form.setBBox(rect);
                    form.setFormType(1);
                    this.drawXObject(ximage, form.getResources(), os, lowerLeftX, lowerLeftY, imgWidth, imgHeight);
                    os.close();
                    PDAppearanceStream myDic = new PDAppearanceStream(form.getCOSStream());
                    PDAppearanceDictionary appearance = new PDAppearanceDictionary(new COSDictionary());
                    appearance.setNormalAppearance(myDic);
                    rubberStamp.setAppearance(appearance);
                    rubberStamp.setRectangle(rect);
                    annotations.add(rubberStamp);
                }
                document.save(args[1]);
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    private void drawXObject(PDImageXObject xobject, PDResources resources, OutputStream os, float x, float y, float width, float height) throws IOException {
        COSName xObjectId = resources.add(xobject);
        this.appendRawCommands(os, SAVE_GRAPHICS_STATE);
        this.appendRawCommands(os, formatDecimal.format(width));
        this.appendRawCommands(os, SPACE);
        this.appendRawCommands(os, formatDecimal.format(0L));
        this.appendRawCommands(os, SPACE);
        this.appendRawCommands(os, formatDecimal.format(0L));
        this.appendRawCommands(os, SPACE);
        this.appendRawCommands(os, formatDecimal.format(height));
        this.appendRawCommands(os, SPACE);
        this.appendRawCommands(os, formatDecimal.format(x));
        this.appendRawCommands(os, SPACE);
        this.appendRawCommands(os, formatDecimal.format(y));
        this.appendRawCommands(os, SPACE);
        this.appendRawCommands(os, CONCATENATE_MATRIX);
        this.appendRawCommands(os, SPACE);
        this.appendRawCommands(os, "/");
        this.appendRawCommands(os, xObjectId.getName());
        this.appendRawCommands(os, SPACE);
        this.appendRawCommands(os, XOBJECT_DO);
        this.appendRawCommands(os, SPACE);
        this.appendRawCommands(os, RESTORE_GRAPHICS_STATE);
    }

    private void appendRawCommands(OutputStream os, String commands) throws IOException {
        os.write(commands.getBytes("ISO-8859-1"));
    }

    public static void main(String[] args) throws Exception {
        RubberStampWithImage rubberStamp = new RubberStampWithImage();
        rubberStamp.doIt(args);
    }

    private void usage() {
        System.err.println("Usage: java " + this.getClass().getName() + " <input-pdf> <output-pdf> <image-filename>");
    }
}

