/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import org.apache.pdfbox.examples.signature.CMSProcessableInputStream;
import org.apache.pdfbox.examples.signature.TSAClient;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.Attributes;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.util.Store;

public class CreateSignature
implements SignatureInterface {
    private final PrivateKey privateKey;
    private final java.security.cert.Certificate certificate;
    private TSAClient tsaClient;

    public CreateSignature(KeyStore keystore, char[] password) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        Enumeration<String> aliases = keystore.aliases();
        if (!aliases.hasMoreElements()) {
            throw new KeyStoreException("Keystore is empty");
        }
        String alias = aliases.nextElement();
        this.privateKey = (PrivateKey)keystore.getKey(alias, password);
        java.security.cert.Certificate[] certificateChain = keystore.getCertificateChain(alias);
        this.certificate = certificateChain[0];
    }

    public void signDetached(File file) throws IOException {
        this.signDetached(file, file, null);
    }

    public void signDetached(File inFile, File outFile) throws IOException {
        this.signDetached(inFile, outFile, null);
    }

    public void signDetached(File inFile, File outFile, TSAClient tsaClient) throws IOException {
        if (inFile == null || !inFile.exists()) {
            throw new FileNotFoundException("Document for signing does not exist");
        }
        FileOutputStream fos = new FileOutputStream(outFile);
        PDDocument doc = PDDocument.load((File)inFile);
        this.signDetached(doc, fos, tsaClient);
        doc.close();
    }

    public void signDetached(PDDocument document, OutputStream output, TSAClient tsaClient) throws IOException {
        this.tsaClient = tsaClient;
        PDSignature signature = new PDSignature();
        signature.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
        signature.setSubFilter(PDSignature.SUBFILTER_ADBE_PKCS7_DETACHED);
        signature.setName("Example User");
        signature.setLocation("Los Angeles, CA");
        signature.setReason("Testing");
        signature.setSignDate(Calendar.getInstance());
        document.addSignature(signature, (SignatureInterface)this);
        document.saveIncremental(output);
    }

    private CMSSignedData signTimeStamps(CMSSignedData signedData) throws IOException, TSPException {
        SignerInformationStore signerStore = signedData.getSignerInfos();
        ArrayList<SignerInformation> newSigners = new ArrayList<SignerInformation>();
        for (SignerInformation signer : signerStore.getSigners()) {
            newSigners.add(this.signTimeStamp(signer));
        }
        return CMSSignedData.replaceSigners((CMSSignedData)signedData, (SignerInformationStore)new SignerInformationStore(newSigners));
    }

    private SignerInformation signTimeStamp(SignerInformation signer) throws IOException, TSPException {
        AttributeTable unsignedAttributes = signer.getUnsignedAttributes();
        ASN1EncodableVector vector = new ASN1EncodableVector();
        if (unsignedAttributes != null) {
            vector = unsignedAttributes.toASN1EncodableVector();
        }
        byte[] token = this.tsaClient.getTimeStampToken(signer.getSignature());
        ASN1ObjectIdentifier oid = PKCSObjectIdentifiers.id_aa_signatureTimeStampToken;
        Attribute signatureTimeStamp = new Attribute(oid, (ASN1Set)new DERSet((ASN1Encodable)ASN1Primitive.fromByteArray((byte[])token)));
        vector.add((ASN1Encodable)signatureTimeStamp);
        Attributes signedAttributes = new Attributes(vector);
        SignerInformation newSigner = SignerInformation.replaceUnsignedAttributes((SignerInformation)signer, (AttributeTable)new AttributeTable(signedAttributes));
        if (newSigner == null) {
            return signer;
        }
        return newSigner;
    }

    public byte[] sign(InputStream content) throws IOException {
        try {
            ArrayList<java.security.cert.Certificate> certList = new ArrayList<java.security.cert.Certificate>();
            certList.add(this.certificate);
            JcaCertStore certs = new JcaCertStore(certList);
            CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
            Certificate cert = Certificate.getInstance((Object)ASN1Primitive.fromByteArray((byte[])this.certificate.getEncoded()));
            ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA256WithRSA").build(this.privateKey);
            gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build()).build(sha1Signer, new X509CertificateHolder(cert)));
            gen.addCertificates((Store)certs);
            CMSProcessableInputStream msg = new CMSProcessableInputStream(content);
            CMSSignedData signedData = gen.generate((CMSTypedData)msg, false);
            if (this.tsaClient != null) {
                signedData = this.signTimeStamps(signedData);
            }
            return signedData.getEncoded();
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
        catch (CMSException e) {
            throw new IOException(e);
        }
        catch (TSPException e) {
            throw new IOException(e);
        }
        catch (OperatorCreationException e) {
            throw new IOException(e);
        }
    }

    public static void main(String[] args) throws IOException, GeneralSecurityException {
        if (args.length < 3) {
            CreateSignature.usage();
            System.exit(1);
        }
        String tsaUrl = null;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-tsa")) continue;
            if (++i >= args.length) {
                CreateSignature.usage();
            }
            tsaUrl = args[i];
        }
        KeyStore keystore = KeyStore.getInstance("PKCS12");
        char[] password = args[1].toCharArray();
        keystore.load(new FileInputStream(args[0]), password);
        TSAClient tsaClient = null;
        if (tsaUrl != null) {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            tsaClient = new TSAClient(new URL(tsaUrl), null, null, digest);
        }
        CreateSignature signing = new CreateSignature(keystore, password);
        File inFile = new File(args[2]);
        String name = inFile.getName();
        String substring = name.substring(0, name.lastIndexOf(46));
        File outFile = new File(inFile.getParent(), substring + "_signed.pdf");
        signing.signDetached(inFile, outFile, tsaClient);
    }

    private static void usage() {
        System.err.println("usage: java " + CreateSignature.class.getName() + " <pkcs12_keystore> <password> <pdf_to_sign>\noptions:\n  -tsa <url>    sign timestamp using the given TSA server");
    }
}

