/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateKey;
import java.util.Calendar;
import java.util.Enumeration;
import org.apache.pdfbox.examples.signature.CMSProcessableInputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSigProperties;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSignDesigner;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;

public class CreateVisibleSignature
implements SignatureInterface {
    private static final BouncyCastleProvider BCPROVIDER = new BouncyCastleProvider();
    private final PrivateKey privKey;
    private final java.security.cert.Certificate[] cert;
    private SignatureOptions options;

    public CreateVisibleSignature(KeyStore keystore, char[] pin) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, IOException {
        Enumeration<String> aliases = keystore.aliases();
        String alias = null;
        if (!aliases.hasMoreElements()) {
            throw new IOException("Could not find alias");
        }
        alias = aliases.nextElement();
        this.privKey = (PrivateKey)keystore.getKey(alias, pin);
        this.cert = keystore.getCertificateChain(alias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File signPDF(File document, PDVisibleSigProperties signatureProperties) throws IOException {
        int c;
        byte[] buffer = new byte[8192];
        if (document == null || !document.exists()) {
            throw new IOException("Document for signing does not exist");
        }
        String name = document.getName();
        String substring = name.substring(0, name.lastIndexOf(46));
        File outputDocument = new File(document.getParent(), substring + "_signed.pdf");
        FileInputStream fis = new FileInputStream(document);
        FileOutputStream fos = new FileOutputStream(outputDocument);
        while ((c = fis.read(buffer)) != -1) {
            fos.write(buffer, 0, c);
        }
        fis.close();
        PDDocument doc = PDDocument.load((File)document);
        PDSignature signature = new PDSignature();
        signature.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
        signature.setSubFilter(PDSignature.SUBFILTER_ADBE_PKCS7_DETACHED);
        signature.setName("signer name");
        signature.setLocation("signer location");
        signature.setReason("reason for signature");
        signature.setSignDate(Calendar.getInstance());
        if (signatureProperties != null && signatureProperties.isVisualSignEnabled()) {
            try {
                this.options = new SignatureOptions();
                this.options.setVisualSignature(signatureProperties);
                doc.addSignature(signature, (SignatureInterface)this, this.options);
            }
            finally {
                if (this.options != null) {
                    this.options.close();
                }
            }
        } else {
            doc.addSignature(signature, (SignatureInterface)this);
        }
        doc.saveIncremental((OutputStream)fos);
        return outputDocument;
    }

    public byte[] sign(InputStream content) throws IOException {
        try {
            Certificate certificate = Certificate.getInstance((Object)ASN1Primitive.fromByteArray((byte[])this.cert[0].getEncoded()));
            AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find("SHA256WITHRSAENCRYPTION");
            AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
            RSAPrivateKey privateRSAKey = (RSAPrivateKey)this.privKey;
            RSAKeyParameters keyParams = new RSAKeyParameters(true, privateRSAKey.getModulus(), privateRSAKey.getPrivateExponent());
            ContentSigner sigGen = new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build((AsymmetricKeyParameter)keyParams);
            CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
            gen.addSignerInfoGenerator(new SignerInfoGeneratorBuilder((DigestCalculatorProvider)new BcDigestCalculatorProvider()).build(sigGen, new X509CertificateHolder(certificate)));
            CMSProcessableInputStream processable = new CMSProcessableInputStream(content);
            CMSSignedData signedData = gen.generate((CMSTypedData)processable, false);
            return signedData.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new IOException(e);
        }
        catch (CMSException e) {
            throw new IOException(e);
        }
        catch (OperatorCreationException e) {
            throw new IOException(e);
        }
    }

    public static void main(String[] args) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (args.length != 4) {
            CreateVisibleSignature.usage();
            System.exit(1);
        } else {
            File ksFile = new File(args[0]);
            KeyStore keystore = KeyStore.getInstance("PKCS12", (Provider)BCPROVIDER);
            char[] pin = args[1].toCharArray();
            keystore.load(new FileInputStream(ksFile), pin);
            File document = new File(args[2]);
            CreateVisibleSignature signing = new CreateVisibleSignature(keystore, (char[])pin.clone());
            FileInputStream image = new FileInputStream(args[3]);
            PDVisibleSignDesigner visibleSig = new PDVisibleSignDesigner(args[2], (InputStream)image, 1);
            visibleSig.xAxis(0.0f).yAxis(0.0f).zoom(-50.0f).signatureFieldName("signature");
            PDVisibleSigProperties signatureProperties = new PDVisibleSigProperties();
            signatureProperties.signerName("name").signerLocation("location").signatureReason("Security").preferredSize(0).page(1).visualSignEnabled(true).setPdVisibleSignature(visibleSig).buildSignature();
            signing.signPDF(document, signatureProperties);
        }
    }

    private static void usage() {
        System.err.println("Usage: java " + CreateVisibleSignature.class.getName() + " <pkcs12-keystore-file> <pin> <input-pdf> <sign-image>");
    }
}

