/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.util;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.contentstream.PDFStreamEngine;
import org.apache.pdfbox.contentstream.operator.DrawObject;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.contentstream.operator.OperatorProcessor;
import org.apache.pdfbox.contentstream.operator.state.Concatenate;
import org.apache.pdfbox.contentstream.operator.state.Restore;
import org.apache.pdfbox.contentstream.operator.state.Save;
import org.apache.pdfbox.contentstream.operator.state.SetGraphicsStateParameters;
import org.apache.pdfbox.contentstream.operator.state.SetMatrix;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.util.Matrix;

public class PrintImageLocations
extends PDFStreamEngine {
    public PrintImageLocations() throws IOException {
        this.addOperator((OperatorProcessor)new Concatenate());
        this.addOperator((OperatorProcessor)new DrawObject());
        this.addOperator((OperatorProcessor)new SetGraphicsStateParameters());
        this.addOperator((OperatorProcessor)new Save());
        this.addOperator((OperatorProcessor)new Restore());
        this.addOperator((OperatorProcessor)new SetMatrix());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            PrintImageLocations.usage();
        } else {
            PDDocument document = null;
            try {
                document = PDDocument.load((File)new File(args[0]));
                PrintImageLocations printer = new PrintImageLocations();
                int pageNum = 0;
                for (PDPage page : document.getPages()) {
                    System.out.println("Processing page: " + ++pageNum);
                    printer.processPage(page);
                }
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    protected void processOperator(Operator operator, List<COSBase> operands) throws IOException {
        String operation = operator.getName();
        if ("Do".equals(operation)) {
            COSName objectName = (COSName)operands.get(0);
            PDXObject xobject = this.getResources().getXObject(objectName);
            if (xobject instanceof PDImageXObject) {
                PDImageXObject image = (PDImageXObject)xobject;
                int imageWidth = image.getWidth();
                int imageHeight = image.getHeight();
                System.out.println("*******************************************************************");
                System.out.println("Found image [" + objectName.getName() + "]");
                Matrix ctmNew = this.getGraphicsState().getCurrentTransformationMatrix();
                float imageXScale = ctmNew.getScalingFactorX();
                float imageYScale = ctmNew.getScalingFactorY();
                System.out.println("position = " + ctmNew.getTranslateX() + ", " + ctmNew.getTranslateY());
                System.out.println("size = " + imageWidth + "px, " + imageHeight + "px");
                System.out.println("size = " + imageXScale + "pu, " + imageYScale + "pu");
                System.out.println("size = " + (imageXScale /= 72.0f) + "in, " + (imageYScale /= 72.0f) + "in");
                imageXScale = (float)((double)imageXScale * 25.4);
                imageYScale = (float)((double)imageYScale * 25.4);
                System.out.println("size = " + imageXScale + "mm, " + imageYScale + "mm");
                System.out.println();
            } else if (xobject instanceof PDFormXObject) {
                PDFormXObject form = (PDFormXObject)xobject;
                this.showForm(form);
            }
        } else {
            super.processOperator(operator, operands);
        }
    }

    private static void usage() {
        System.err.println("Usage: java org.apache.pdfbox.examples.pdmodel.PrintImageLocations <input-pdf>");
    }
}

