/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdfwriter.ContentStreamWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDStream;

public class RemoveAllText {
    private RemoveAllText() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            RemoveAllText.usage();
        } else {
            PDDocument document = null;
            try {
                document = PDDocument.load((File)new File(args[0]));
                if (document.isEncrypted()) {
                    System.err.println("Error: Encrypted documents are not supported for this example.");
                    System.exit(1);
                }
                for (PDPage page : document.getPages()) {
                    PDFStreamParser parser = new PDFStreamParser(page.getStream());
                    parser.parse();
                    List tokens = parser.getTokens();
                    ArrayList newTokens = new ArrayList();
                    for (Object token : tokens) {
                        Operator op;
                        if (token instanceof Operator && ((op = (Operator)token).getName().equals("TJ") || op.getName().equals("Tj"))) {
                            newTokens.remove(newTokens.size() - 1);
                            continue;
                        }
                        newTokens.add(token);
                    }
                    PDStream newContents = new PDStream(document);
                    ContentStreamWriter writer = new ContentStreamWriter(newContents.createOutputStream());
                    writer.writeTokens(newTokens);
                    newContents.addCompression();
                    page.setContents(newContents);
                }
                document.save(args[1]);
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java org.apache.pdfbox.examples.pdmodel.RemoveAllText <input-pdf> <output-pdf>");
    }
}

