/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.File;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdfparser.PDFObjectStreamParser;
import org.apache.pdfbox.pdmodel.PDDocument;

public class DecompressObjectstreams {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        System.setProperty("apple.awt.UIElement", "true");
        if (args.length < 1) {
            DecompressObjectstreams.usage();
        }
        String inputFilename = args[0];
        String outputFilename = args.length > 1 ? args[1] : (inputFilename.matches(".*\\.[pP][dD][fF]$") ? inputFilename.replaceAll("\\.[pP][dD][fF]$", ".unc.pdf") : inputFilename + ".unc.pdf");
        PDDocument doc = null;
        try {
            doc = PDDocument.load((File)new File(inputFilename));
            for (COSObject objStream : doc.getDocument().getObjectsByType(COSName.OBJ_STM)) {
                COSStream stream = (COSStream)objStream.getObject();
                PDFObjectStreamParser sp = new PDFObjectStreamParser(stream, doc.getDocument());
                sp.parse();
                for (COSObject next : sp.getObjects()) {
                    COSObjectKey key = new COSObjectKey(next);
                    COSObject obj = doc.getDocument().getObjectFromPool(key);
                    obj.setObject(next.getObject());
                }
                doc.getDocument().removeObject(new COSObjectKey(objStream));
            }
            doc.save(outputFilename);
        }
        catch (Exception e) {
            System.out.println("Error processing file: " + e.getMessage());
        }
        finally {
            if (doc != null) {
                try {
                    doc.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java -cp pdfbox-app-x.y.z.jar org.apache.pdfbox.tools.DecompressObjectstreams <input PDF File> [<Output PDF File>]\n  <input PDF File>       The PDF document to decompress\n  <output PDF File>      The output filename (default is to replace .pdf with .unc.pdf)");
        System.exit(1);
    }
}

