/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.tools.ExtensionFileFilter;
import org.apache.pdfbox.tools.gui.ArrayEntry;
import org.apache.pdfbox.tools.gui.DocumentEntry;
import org.apache.pdfbox.tools.gui.MapEntry;
import org.apache.pdfbox.tools.gui.OSXAdapter;
import org.apache.pdfbox.tools.gui.PDFTreeCellRenderer;
import org.apache.pdfbox.tools.gui.PDFTreeModel;
import org.apache.pdfbox.tools.gui.PageEntry;
import org.apache.pdfbox.tools.pdfdebugger.colorpane.CSArrayBased;
import org.apache.pdfbox.tools.pdfdebugger.colorpane.CSDeviceN;
import org.apache.pdfbox.tools.pdfdebugger.colorpane.CSIndexed;
import org.apache.pdfbox.tools.pdfdebugger.colorpane.CSSeparation;
import org.apache.pdfbox.tools.pdfdebugger.flagbitspane.FlagBitsPane;
import org.apache.pdfbox.tools.pdfdebugger.pagepane.PagePane;
import org.apache.pdfbox.tools.pdfdebugger.treestatus.TreeStatus;
import org.apache.pdfbox.tools.pdfdebugger.treestatus.TreeStatusPane;
import org.apache.pdfbox.tools.pdfdebugger.ui.Tree;
import org.apache.pdfbox.tools.util.FileOpenSaveDialog;
import org.apache.pdfbox.tools.util.RecentFiles;

public class PDFDebugger
extends JFrame {
    private TreeStatusPane statusPane;
    private RecentFiles recentFiles;
    private boolean isPageMode;
    private PDDocument document;
    private String currentFilePath;
    private static final Set<COSName> SPECIALCOLORSPACES = new HashSet<COSName>(Arrays.asList(COSName.INDEXED, COSName.SEPARATION, COSName.DEVICEN));
    private static final Set<COSName> OTHERCOLORSPACES = new HashSet<COSName>(Arrays.asList(COSName.ICCBASED, COSName.PATTERN, COSName.CALGRAY, COSName.CALRGB, COSName.LAB));
    private static final String PASSWORD = "-password";
    private static final int SHORCUT_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    private static final boolean IS_MAC_OS = OS_NAME.startsWith("mac os x");
    private JMenuItem aboutMenuItem;
    private JMenuItem contentsMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem cutMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenu editMenu;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenu recentFilesMenu;
    private JMenu viewMenu;
    private JMenuItem viewModeItem;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTextPane jTextPane1;
    private Tree tree;
    private JMenuBar menuBar;
    private JMenuItem openMenuItem;
    private JMenuItem pasteMenuItem;
    private JMenuItem saveAsMenuItem;
    private JMenuItem saveMenuItem;
    private final JPanel documentPanel = new JPanel();

    public PDFDebugger() {
        this.initComponents();
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.tree = new Tree(this);
        this.jScrollPane2 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.recentFilesMenu = new JMenu();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.cutMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.deleteMenuItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.viewModeItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.contentsMenuItem = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.tree.setCellRenderer(new PDFTreeCellRenderer());
        this.tree.setModel(null);
        this.setTitle("PDFBox Debugger");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                PDFDebugger.this.tree.requestFocusInWindow();
                super.windowOpened(windowEvent);
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                PDFDebugger.this.exitForm(evt);
            }
        });
        this.jScrollPane1.setBorder(new BevelBorder(0));
        this.jScrollPane1.setPreferredSize(new Dimension(300, 500));
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                PDFDebugger.this.jTree1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tree);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        this.jSplitPane1.setDividerSize(3);
        this.jScrollPane2.setPreferredSize(new Dimension(300, 500));
        this.jScrollPane2.setViewportView(this.jTextPane1);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        JScrollPane documentScroller = new JScrollPane();
        documentScroller.setViewportView(this.documentPanel);
        this.statusPane = new TreeStatusPane(this.tree);
        this.statusPane.getPanel().setBorder(new BevelBorder(0));
        this.statusPane.getPanel().setPreferredSize(new Dimension(300, 25));
        this.getContentPane().add((Component)this.statusPane.getPanel(), "First");
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.fileMenu.setText("File");
        this.openMenuItem.setText("Open...");
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, SHORCUT_KEY_MASK));
        this.openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PDFDebugger.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.saveMenuItem.setText("Save");
        this.saveAsMenuItem.setText("Save As ...");
        try {
            this.recentFiles = new RecentFiles(this.getClass(), 5);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.recentFilesMenu.setText("Open Recent");
        this.recentFilesMenu.setEnabled(false);
        this.addRecentFileItems();
        this.fileMenu.add(this.recentFilesMenu);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke("alt F4"));
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PDFDebugger.this.exitMenuItemActionPerformed(evt);
            }
        });
        if (!IS_MAC_OS) {
            this.fileMenu.add(this.exitMenuItem);
        }
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.cutMenuItem.setText("Cut");
        this.editMenu.add(this.cutMenuItem);
        this.copyMenuItem.setText("Copy");
        this.editMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setText("Paste");
        this.editMenu.add(this.pasteMenuItem);
        this.deleteMenuItem.setText("Delete");
        this.editMenu.add(this.deleteMenuItem);
        this.viewMenu.setText("View");
        this.viewModeItem.setText("Show Pages");
        this.viewModeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PDFDebugger.this.isPageMode) {
                    PDFDebugger.this.viewModeItem.setText("Show Pages");
                    PDFDebugger.this.isPageMode = false;
                } else {
                    PDFDebugger.this.viewModeItem.setText("Show Internal Structure");
                    PDFDebugger.this.isPageMode = true;
                }
                PDFDebugger.this.initTree();
            }
        });
        this.viewMenu.add(this.viewModeItem);
        this.menuBar.add(this.viewMenu);
        this.helpMenu.setText("Help");
        this.contentsMenuItem.setText("Contents");
        this.helpMenu.add(this.contentsMenuItem);
        this.aboutMenuItem.setText("About");
        this.helpMenu.add(this.aboutMenuItem);
        this.setJMenuBar(this.menuBar);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 700) / 2, (screenSize.height - 600) / 2, 700, 600);
        this.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport transferSupport) {
                return transferSupport.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport transferSupport) {
                try {
                    Transferable transferable = transferSupport.getTransferable();
                    List files = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    PDFDebugger.this.readPDFFile((File)files.get(0), "");
                    return true;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (UnsupportedFlavorException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        if (IS_MAC_OS) {
            try {
                Method osxOpenFiles = this.getClass().getDeclaredMethod("osxOpenFiles", String.class);
                osxOpenFiles.setAccessible(true);
                OSXAdapter.setFileHandler(this, osxOpenFiles);
                Method osxQuit = this.getClass().getDeclaredMethod("osxQuit", new Class[0]);
                osxQuit.setAccessible(true);
                OSXAdapter.setQuitHandler(this, osxQuit);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void osxOpenFiles(String filename) {
        try {
            this.readPDFFile(filename, "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void osxQuit() {
        this.exitMenuItemActionPerformed(null);
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        try {
            if (IS_MAC_OS) {
                FileDialog openDialog = new FileDialog((Frame)this, "Open");
                openDialog.setFilenameFilter(new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String s) {
                        return file.getName().toLowerCase().endsWith(".pdf");
                    }
                });
                openDialog.setVisible(true);
                if (openDialog.getFile() != null) {
                    this.readPDFFile(openDialog.getFile(), "");
                }
            } else {
                String[] extensions = new String[]{"pdf", "PDF"};
                ExtensionFileFilter pdfFilter = new ExtensionFileFilter(extensions, "PDF Files (*.pdf)");
                FileOpenSaveDialog openDialog = new FileOpenSaveDialog(this, pdfFilter);
                File file = openDialog.openFile();
                if (file != null) {
                    this.readPDFFile(file, "");
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void jTree1ValueChanged(TreeSelectionEvent evt) {
        TreePath path = this.tree.getSelectionPath();
        if (path != null) {
            try {
                String data;
                Object selectedNode = path.getLastPathComponent();
                if (this.isSpecialColorSpace(selectedNode) || this.isOtherColorSpace(selectedNode)) {
                    this.showColorPane(selectedNode);
                    return;
                }
                if (this.isPage(selectedNode)) {
                    this.showPage(selectedNode);
                    return;
                }
                if (this.isFlagNode(selectedNode)) {
                    Object parentNode = path.getParentPath().getLastPathComponent();
                    this.showFlagPane(parentNode, selectedNode);
                    return;
                }
                if (!this.jSplitPane1.getRightComponent().equals(this.jScrollPane2)) {
                    this.jSplitPane1.setRightComponent(this.jScrollPane2);
                }
                if ((data = this.convertToString(selectedNode)) != null) {
                    this.jTextPane1.setText(data);
                } else {
                    this.jTextPane1.setText("");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    private boolean isSpecialColorSpace(Object selectedNode) {
        COSBase arrayEntry;
        if ((selectedNode = this.getUnderneathObject(selectedNode)) instanceof COSArray && ((COSArray)selectedNode).size() > 0 && (arrayEntry = ((COSArray)selectedNode).get(0)) instanceof COSName) {
            COSName name = (COSName)arrayEntry;
            return SPECIALCOLORSPACES.contains(name);
        }
        return false;
    }

    private boolean isOtherColorSpace(Object selectedNode) {
        COSBase arrayEntry;
        if ((selectedNode = this.getUnderneathObject(selectedNode)) instanceof COSArray && ((COSArray)selectedNode).size() > 0 && (arrayEntry = ((COSArray)selectedNode).get(0)) instanceof COSName) {
            COSName name = (COSName)arrayEntry;
            return OTHERCOLORSPACES.contains(name);
        }
        return false;
    }

    private boolean isPage(Object selectedNode) {
        COSDictionary dict;
        COSBase typeItem;
        return (selectedNode = this.getUnderneathObject(selectedNode)) instanceof COSDictionary ? COSName.PAGE.equals((Object)(typeItem = (dict = (COSDictionary)selectedNode).getItem(COSName.TYPE))) : selectedNode instanceof PageEntry;
    }

    private boolean isFlagNode(Object selectedNode) {
        if (selectedNode instanceof MapEntry) {
            COSName key = ((MapEntry)selectedNode).getKey();
            return COSName.FLAGS.equals((Object)key) || COSName.F.equals((Object)key) || COSName.FF.equals((Object)key) || COSName.PANOSE.equals((Object)key);
        }
        return false;
    }

    private void showColorPane(Object csNode) {
        COSArray array;
        COSBase arrayEntry;
        if ((csNode = this.getUnderneathObject(csNode)) instanceof COSArray && ((COSArray)csNode).size() > 0 && (arrayEntry = (array = (COSArray)csNode).get(0)) instanceof COSName) {
            COSName csName = (COSName)arrayEntry;
            if (csName.equals((Object)COSName.SEPARATION)) {
                this.jSplitPane1.setRightComponent(new CSSeparation(array).getPanel());
            } else if (csName.equals((Object)COSName.DEVICEN)) {
                this.jSplitPane1.setRightComponent(new CSDeviceN(array).getPanel());
            } else if (csName.equals((Object)COSName.INDEXED)) {
                this.jSplitPane1.setRightComponent(new CSIndexed(array).getPanel());
            } else if (OTHERCOLORSPACES.contains(csName)) {
                this.jSplitPane1.setRightComponent(new CSArrayBased(array).getPanel());
            }
        }
    }

    private void showPage(Object selectedNode) {
        COSDictionary page = (selectedNode = this.getUnderneathObject(selectedNode)) instanceof COSDictionary ? (COSDictionary)selectedNode : ((PageEntry)selectedNode).getDict();
        COSBase typeItem = page.getItem(COSName.TYPE);
        if (COSName.PAGE.equals((Object)typeItem)) {
            PagePane pagePane = new PagePane(this.document, page);
            this.jSplitPane1.setRightComponent(new JScrollPane(pagePane.getPanel()));
        }
    }

    private void showFlagPane(Object parentNode, Object selectedNode) {
        if ((parentNode = this.getUnderneathObject(parentNode)) instanceof COSDictionary) {
            selectedNode = ((MapEntry)selectedNode).getKey();
            selectedNode = this.getUnderneathObject(selectedNode);
            FlagBitsPane flagBitsPane = new FlagBitsPane((COSDictionary)parentNode, (COSName)selectedNode);
            this.jSplitPane1.setRightComponent(flagBitsPane.getPane());
        }
    }

    private Object getUnderneathObject(Object selectedNode) {
        if (selectedNode instanceof MapEntry) {
            selectedNode = ((MapEntry)selectedNode).getValue();
        } else if (selectedNode instanceof ArrayEntry) {
            selectedNode = ((ArrayEntry)selectedNode).getValue();
        }
        if (selectedNode instanceof COSObject) {
            selectedNode = ((COSObject)selectedNode).getObject();
        }
        return selectedNode;
    }

    private String convertToString(Object selectedNode) {
        String data = null;
        if (selectedNode instanceof COSBoolean) {
            data = "" + ((COSBoolean)selectedNode).getValue();
        } else if (selectedNode instanceof COSFloat) {
            data = "" + ((COSFloat)selectedNode).floatValue();
        } else if (selectedNode instanceof COSNull) {
            data = "null";
        } else if (selectedNode instanceof COSInteger) {
            data = "" + ((COSInteger)selectedNode).intValue();
        } else if (selectedNode instanceof COSName) {
            data = "" + ((COSName)selectedNode).getName();
        } else if (selectedNode instanceof COSString) {
            String text = ((COSString)selectedNode).getString();
            for (char c : text.toCharArray()) {
                if (!Character.isISOControl(c)) continue;
                text = "<" + ((COSString)selectedNode).toHexString() + ">";
                break;
            }
            data = "" + text;
        } else if (selectedNode instanceof COSStream) {
            try {
                int amountRead;
                COSStream stream = (COSStream)selectedNode;
                InputStream ioStream = stream.getUnfilteredStream();
                ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((amountRead = ioStream.read(buffer, 0, buffer.length)) != -1) {
                    byteArray.write(buffer, 0, amountRead);
                }
                data = byteArray.toString();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else if (selectedNode instanceof MapEntry) {
            data = this.convertToString(((MapEntry)selectedNode).getValue());
        } else if (selectedNode instanceof ArrayEntry) {
            data = this.convertToString(((ArrayEntry)selectedNode).getValue());
        }
        return data;
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        if (this.document != null) {
            try {
                this.document.close();
                this.recentFiles.addFile(this.currentFilePath);
                this.recentFiles.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        System.exit(0);
    }

    private void exitForm(WindowEvent evt) {
        if (this.document != null) {
            try {
                this.document.close();
                this.recentFiles.addFile(this.currentFilePath);
                this.recentFiles.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        System.exit(0);
    }

    public static void main(String[] args) throws Exception {
        File file;
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                StringBuilder sb = new StringBuilder();
                sb.append(throwable.toString());
                for (StackTraceElement element : throwable.getStackTrace()) {
                    sb.append('\n');
                    sb.append(element);
                }
                JOptionPane.showMessageDialog(null, "Error: " + sb.toString(), "Error", 0);
            }
        });
        PDFDebugger viewer = new PDFDebugger();
        String filename = null;
        String password = "";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(PASSWORD)) {
                if (++i >= args.length) {
                    PDFDebugger.usage();
                }
                password = args[i];
                continue;
            }
            filename = args[i];
        }
        if (filename != null && (file = new File(filename)).exists()) {
            viewer.readPDFFile(filename, password);
        }
        viewer.setVisible(true);
    }

    private void readPDFFile(String filePath, String password) throws IOException {
        File file = new File(filePath);
        this.readPDFFile(file, password);
    }

    private void readPDFFile(File file, String password) throws IOException {
        if (this.document != null) {
            this.document.close();
            this.recentFiles.addFile(this.currentFilePath);
        }
        this.currentFilePath = file.getPath();
        this.recentFiles.removeFile(file.getPath());
        this.parseDocument(file, password);
        this.initTree();
        if (IS_MAC_OS) {
            this.setTitle(file.getName());
            this.getRootPane().putClientProperty("Window.documentFile", file);
        } else {
            this.setTitle("PDF Debugger - " + file.getAbsolutePath());
        }
        this.addRecentFileItems();
    }

    private void initTree() {
        TreeStatus treeStatus = new TreeStatus(this.document.getDocument().getTrailer());
        this.statusPane.updateTreeStatus(treeStatus);
        if (this.isPageMode) {
            File file = new File(this.currentFilePath);
            DocumentEntry documentEntry = new DocumentEntry(this.document, file.getName());
            this.tree.setModel(new PDFTreeModel(documentEntry));
            this.tree.setSelectionPath(treeStatus.getPathForString("Root/Pages/Kids/[0]"));
        } else {
            this.tree.setModel(new PDFTreeModel(this.document));
            this.tree.setSelectionPath(treeStatus.getPathForString("Root"));
        }
    }

    private void parseDocument(File file, String password) throws IOException {
        this.document = PDDocument.load((File)file, (String)password);
    }

    private void addRecentFileItems() {
        AbstractAction recentMenuAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String filePath = (String)((JComponent)actionEvent.getSource()).getClientProperty("path");
                try {
                    PDFDebugger.this.readPDFFile(filePath, "");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        if (!this.recentFiles.isEmpty()) {
            this.recentFilesMenu.removeAll();
            List<String> files = this.recentFiles.getFiles();
            for (int i = files.size() - 1; i >= 0; --i) {
                String path = files.get(i);
                String name = new File(path).getName();
                JMenuItem recentFileMenuItem = new JMenuItem(name);
                recentFileMenuItem.putClientProperty("path", path);
                recentFileMenuItem.addActionListener(recentMenuAction);
                this.recentFilesMenu.add(recentFileMenuItem);
            }
            this.recentFilesMenu.setEnabled(true);
        }
    }

    private static void usage() {
        System.err.println("usage: java -jar pdfbox-app-x.y.z.jar PDFDebugger [OPTIONS] <input-file>\n  -password <password>      Password to decrypt the document\n  <input-file>              The PDF document to be loaded\n");
    }
}

