/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.printing.PDFPrinter;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.tools.ExtensionFileFilter;
import org.apache.pdfbox.tools.Version;
import org.apache.pdfbox.tools.gui.PageWrapper;
import org.apache.pdfbox.tools.gui.ReaderBottomPanel;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;
import org.apache.pdfbox.tools.util.RecentFiles;

public class PDFReader
extends JFrame {
    private File currentDir = new File(".");
    private JMenuItem saveAsImageMenuItem;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenuBar menuBar;
    private JMenuItem openMenuItem;
    private JMenu recentFileSubmenu;
    private JMenuItem printMenuItem;
    private JMenu viewMenu;
    private JMenuItem nextPageItem;
    private JMenuItem previousPageItem;
    private JMenuItem firstPageItem;
    private JMenuItem lastPageItem;
    private final JPanel documentPanel = new JPanel();
    private final ReaderBottomPanel bottomStatusPanel = new ReaderBottomPanel();
    private PDFRenderer renderer;
    private PDDocument document = null;
    private PDPageTree pages = null;
    private int currentPage = 0;
    private int numberOfPages = 0;
    private String currentFilename = null;
    private String currentFilePath = null;
    private static final String PASSWORD = "-password";
    private static final String VERSION = Version.getVersion();
    private static final String BASETITLE = "PDFBox " + VERSION;
    private static final String PREVIOUS_PAGE = "previous_page";
    private static final String NEXT_PAGE = "next_page";
    private static final String FIRST_PAGE = "first_page";
    private static final String LAST_PAGE = "last_page";
    private RecentFiles recentFiles;

    public PDFReader() {
        this.initComponents();
    }

    private void initComponents() {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.recentFileSubmenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.saveAsImageMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.printMenuItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.nextPageItem = new JMenuItem();
        this.previousPageItem = new JMenuItem();
        this.firstPageItem = new JMenuItem();
        this.lastPageItem = new JMenuItem();
        this.setTitle(BASETITLE);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PDFReader.this.exitApplication();
            }
        });
        JScrollPane documentScroller = new JScrollPane();
        documentScroller.setViewportView(this.documentPanel);
        this.getContentPane().add((Component)documentScroller, "Center");
        this.getContentPane().add((Component)this.bottomStatusPanel, "South");
        this.fileMenu.setText("File");
        this.openMenuItem.setText("Open");
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.openMenuItem.setToolTipText("Open PDF file");
        this.openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PDFReader.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        try {
            this.recentFiles = new RecentFiles(this.getClass(), 5);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.recentFileSubmenu.setText("Open recent Files");
        this.recentFileSubmenu.setEnabled(false);
        this.addRecentFileItems();
        this.fileMenu.add(this.recentFileSubmenu);
        this.fileMenu.addSeparator();
        this.printMenuItem.setText("Print");
        this.printMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.printMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (PDFReader.this.document != null) {
                        PDFPrinter printer = new PDFPrinter(PDFReader.this.document);
                        PrinterJob job = PrinterJob.getPrinterJob();
                        job.setPageable(printer.getPageable());
                        if (job.printDialog()) {
                            job.print();
                        }
                    }
                }
                catch (PrinterException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.fileMenu.add(this.printMenuItem);
        this.saveAsImageMenuItem.setText("Save as image");
        this.saveAsImageMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (PDFReader.this.document != null) {
                    try {
                        PDFReader.this.saveImage();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        this.fileMenu.add(this.saveAsImageMenuItem);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PDFReader.this.exitApplication();
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        AbstractAction previousPageAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    PDFReader.this.previousPage();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        AbstractAction nextPageAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    PDFReader.this.nextPage();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        AbstractAction firstPageAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    PDFReader.this.firstPage();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        AbstractAction lastPageAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    PDFReader.this.lastPage();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.viewMenu.setText("View");
        this.nextPageItem.setText("Next page");
        this.nextPageItem.setAccelerator(KeyStroke.getKeyStroke('+'));
        this.nextPageItem.addActionListener(nextPageAction);
        this.nextPageItem.setEnabled(false);
        this.viewMenu.add(this.nextPageItem);
        this.previousPageItem.setText("Previous page");
        this.previousPageItem.setAccelerator(KeyStroke.getKeyStroke('-'));
        this.previousPageItem.addActionListener(previousPageAction);
        this.previousPageItem.setEnabled(false);
        this.viewMenu.add(this.previousPageItem);
        this.viewMenu.addSeparator();
        this.firstPageItem.setText("First Page");
        this.firstPageItem.setAccelerator(KeyStroke.getKeyStroke(36, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.firstPageItem.addActionListener(firstPageAction);
        this.firstPageItem.setEnabled(false);
        this.viewMenu.add(this.firstPageItem);
        this.lastPageItem.setText("Last Page");
        this.lastPageItem.setAccelerator(KeyStroke.getKeyStroke(35, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.lastPageItem.addActionListener(lastPageAction);
        this.lastPageItem.setEnabled(false);
        this.viewMenu.add(this.lastPageItem);
        this.menuBar.add(this.viewMenu);
        this.setJMenuBar(this.menuBar);
        InputMap documentInputMap = this.documentPanel.getInputMap(2);
        documentInputMap.put(KeyStroke.getKeyStroke("PAGE_UP"), PREVIOUS_PAGE);
        documentInputMap.put(KeyStroke.getKeyStroke("PAGE_DOWN"), NEXT_PAGE);
        documentInputMap.put(KeyStroke.getKeyStroke("HOME"), FIRST_PAGE);
        documentInputMap.put(KeyStroke.getKeyStroke("END"), LAST_PAGE);
        ActionMap documentActionMap = this.documentPanel.getActionMap();
        documentActionMap.put(PREVIOUS_PAGE, previousPageAction);
        documentActionMap.put(NEXT_PAGE, nextPageAction);
        documentActionMap.put(FIRST_PAGE, firstPageAction);
        documentActionMap.put(LAST_PAGE, lastPageAction);
        JScrollBar verticalScroller = documentScroller.getVerticalScrollBar();
        verticalScroller.setUnitIncrement(20);
        InputMap scrollerInputMap = verticalScroller.getInputMap(2);
        scrollerInputMap.put(KeyStroke.getKeyStroke("DOWN"), "positiveUnitIncrement");
        scrollerInputMap.put(KeyStroke.getKeyStroke("UP"), "negativeUnitIncrement");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 700) / 2, (screenSize.height - 600) / 2, 700, 600);
    }

    private void addRecentFileItems() {
        AbstractAction recentMenuAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String filePath = (String)((JComponent)actionEvent.getSource()).getClientProperty("path");
                try {
                    PDFReader.this.openPDFFile(filePath, "");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        MouseListener mouseListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                String filePath = (String)((JComponent)mouseEvent.getSource()).getClientProperty("path");
                PDFReader.this.bottomStatusPanel.getStatusLabel().setText(filePath);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                PDFReader.this.bottomStatusPanel.getStatusLabel().setText("");
            }
        };
        if (!this.recentFiles.isEmpty()) {
            this.recentFileSubmenu.removeAll();
            List<String> files = this.recentFiles.getFiles();
            for (int i = files.size() - 1; i >= 0; --i) {
                String path = files.get(i);
                String name = new File(path).getName();
                JMenuItem recentFileMenuItem = new JMenuItem(name);
                recentFileMenuItem.putClientProperty("path", path);
                recentFileMenuItem.addActionListener(recentMenuAction);
                recentFileMenuItem.addMouseListener(mouseListener);
                this.recentFileSubmenu.add(recentFileMenuItem);
            }
            this.recentFileSubmenu.setEnabled(true);
        }
    }

    private void updateTitle() {
        this.setTitle(BASETITLE + ": " + this.currentFilename + " (" + (this.currentPage + 1) + "/" + this.numberOfPages + ")");
    }

    private void nextPage() throws IOException {
        if (this.currentPage < this.numberOfPages - 1) {
            ++this.currentPage;
            this.updateTitle();
            this.showPage(this.currentPage);
        }
    }

    private void previousPage() throws IOException {
        if (this.currentPage > 0) {
            --this.currentPage;
            this.updateTitle();
            this.showPage(this.currentPage);
        }
    }

    private void firstPage() throws IOException {
        if (this.currentPage > 0) {
            this.currentPage = 0;
            this.updateTitle();
            this.showPage(this.currentPage);
        }
    }

    private void lastPage() throws IOException {
        if (this.currentPage < this.numberOfPages - 1) {
            this.currentPage = this.numberOfPages - 1;
            this.updateTitle();
            this.showPage(this.currentPage);
        }
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(this.currentDir);
        ExtensionFileFilter pdfFilter = new ExtensionFileFilter(new String[]{"PDF"}, "PDF Files");
        chooser.setFileFilter(pdfFilter);
        int result = chooser.showOpenDialog(this);
        if (result == 0) {
            String name = chooser.getSelectedFile().getPath();
            this.currentDir = new File(name).getParentFile();
            try {
                this.openPDFFile(name, "");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void exitApplication() {
        try {
            if (this.document != null) {
                this.document.close();
                this.recentFiles.addFile(this.currentFilePath);
            }
            this.recentFiles.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) throws Exception {
        PDFReader viewer = new PDFReader();
        String password = "";
        String filename = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(PASSWORD)) {
                if (++i >= args.length) {
                    PDFReader.usage();
                }
                password = args[i];
                continue;
            }
            filename = args[i];
        }
        if (filename != null) {
            viewer.openPDFFile(filename, password);
        }
        viewer.setVisible(true);
    }

    private void openPDFFile(String filename, String password) throws IOException {
        if (this.document != null) {
            this.document.close();
            this.documentPanel.removeAll();
            this.recentFiles.addFile(this.currentFilePath);
        }
        File file = new File(filename);
        this.currentFilePath = file.getPath();
        this.recentFiles.removeFile(file.getPath());
        this.parseDocument(file, password);
        this.pages = this.document.getPages();
        this.numberOfPages = this.document.getNumberOfPages();
        this.currentFilename = file.getAbsolutePath();
        this.currentPage = 0;
        this.updateTitle();
        this.showPage(0);
        this.addRecentFileItems();
    }

    private void showPage(int pageNumber) throws IOException {
        PageWrapper wrapper = new PageWrapper(this.getBottomStatusPanel().getStatusLabel());
        wrapper.displayPage(this.renderer, this.pages.get(pageNumber), pageNumber);
        if (this.documentPanel.getComponentCount() > 0) {
            this.documentPanel.remove(0);
        }
        this.documentPanel.add(wrapper.getPanel());
        this.pack();
        this.updateViewMenu();
    }

    private void updateViewMenu() {
        if (this.currentPage == 0) {
            this.nextPageItem.setEnabled(true);
            this.previousPageItem.setEnabled(false);
            this.firstPageItem.setEnabled(false);
            this.lastPageItem.setEnabled(true);
        } else if (this.currentPage == this.numberOfPages - 1) {
            this.nextPageItem.setEnabled(false);
            this.previousPageItem.setEnabled(true);
            this.firstPageItem.setEnabled(true);
            this.lastPageItem.setEnabled(false);
        } else {
            this.nextPageItem.setEnabled(true);
            this.previousPageItem.setEnabled(true);
            this.firstPageItem.setEnabled(true);
            this.lastPageItem.setEnabled(true);
        }
    }

    private void saveImage() throws IOException {
        BufferedImage pageAsImage = this.renderer.renderImage(this.currentPage);
        String imageFilename = this.currentFilename;
        if (imageFilename.toLowerCase().endsWith(".pdf")) {
            imageFilename = imageFilename.substring(0, imageFilename.length() - 4);
        }
        imageFilename = imageFilename + "_" + (this.currentPage + 1);
        ImageIOUtil.writeImage(pageAsImage, imageFilename + ".png", 300);
    }

    private void parseDocument(File file, String password) throws IOException {
        this.document = PDDocument.load((File)file, (String)password);
        this.renderer = new PDFRenderer(this.document);
    }

    public ReaderBottomPanel getBottomStatusPanel() {
        return this.bottomStatusPanel;
    }

    private static void usage() {
        System.err.println("usage: java -jar pdfbox-app-" + VERSION + ".jar PDFReader [OPTIONS] <input-file>\n  -password <password>      Password to decrypt the document\n  <input-file>              The PDF document to be loaded\n");
    }
}

