/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.awt.print.PrinterJob;
import java.io.File;
import javax.print.PrintService;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.PDFPrinter;

public class PrintPDF {
    private static final String PASSWORD = "-password";
    private static final String SILENT = "-silentPrint";
    private static final String PRINTER_NAME = "-printerName";

    private PrintPDF() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        System.setProperty("apple.awt.UIElement", "true");
        String password = "";
        String pdfFile = null;
        boolean silentPrint = false;
        String printerName = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(PASSWORD)) {
                if (++i >= args.length) {
                    PrintPDF.usage();
                }
                password = args[i];
                continue;
            }
            if (args[i].equals(PRINTER_NAME)) {
                if (++i >= args.length) {
                    PrintPDF.usage();
                }
                printerName = args[i];
                continue;
            }
            if (args[i].equals(SILENT)) {
                silentPrint = true;
                continue;
            }
            pdfFile = args[i];
        }
        if (pdfFile == null) {
            PrintPDF.usage();
        }
        PDDocument document = null;
        try {
            document = PDDocument.load((File)new File(pdfFile), (String)password);
            PrinterJob printJob = PrinterJob.getPrinterJob();
            printJob.setJobName(new File(pdfFile).getName());
            if (printerName != null) {
                PrintService[] printService = PrinterJob.lookupPrintServices();
                boolean printerFound = false;
                for (int i = 0; !printerFound && i < printService.length; ++i) {
                    if (!printService[i].getName().contains(printerName)) continue;
                    printJob.setPrintService(printService[i]);
                    printerFound = true;
                }
            }
            PDFPrinter printer = new PDFPrinter(document);
            if (silentPrint) {
                printer.silentPrint(printJob);
            } else {
                printer.print(printJob);
            }
        }
        finally {
            if (document != null) {
                document.close();
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java -jar pdfbox-app-x.y.z.jar PrintPDF [OPTIONS] <PDF file>\n  -password  <password>        Password to decrypt document\n  -silentPrint                 Print without prompting for printer info\n");
        System.exit(1);
    }
}

