/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PDFPagePanel
extends JPanel {
    private static final long serialVersionUID = -4629033339560890669L;
    private PDFRenderer renderer;
    private int pageNum;
    private final Cursor waitCursor = new Cursor(3);

    public void setPage(PDFRenderer renderer, PDPage page, int pageNum) throws IOException {
        this.renderer = renderer;
        this.pageNum = pageNum;
        PDRectangle cropBox = page.getCropBox();
        Dimension drawDimension = new Dimension((int)cropBox.getWidth(), (int)cropBox.getHeight());
        int rotationAngle = page.getRotation();
        Dimension pageDimension = rotationAngle == 90 || rotationAngle == 270 ? new Dimension(drawDimension.height, drawDimension.width) : drawDimension;
        this.setSize(pageDimension);
        this.setBackground(Color.white);
    }

    @Override
    public void paint(Graphics g) {
        try {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            Component rootComponent = SwingUtilities.getRoot(this);
            Cursor cursor = rootComponent.getCursor();
            rootComponent.setCursor(this.waitCursor);
            this.renderer.renderPageToGraphics(this.pageNum, (Graphics2D)g);
            rootComponent.setCursor(cursor);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

