/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools.pdfdebugger.flagbitspane;

import javax.swing.JPanel;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.tools.pdfdebugger.flagbitspane.AnnotFlag;
import org.apache.pdfbox.tools.pdfdebugger.flagbitspane.FieldFlag;
import org.apache.pdfbox.tools.pdfdebugger.flagbitspane.Flag;
import org.apache.pdfbox.tools.pdfdebugger.flagbitspane.FlagBitsPaneView;
import org.apache.pdfbox.tools.pdfdebugger.flagbitspane.FontFlag;
import org.apache.pdfbox.tools.pdfdebugger.flagbitspane.PanoseFlag;

public class FlagBitsPane {
    private FlagBitsPaneView view;

    public FlagBitsPane(COSDictionary dictionary, COSName flagType) {
        this.createPane(dictionary, flagType);
    }

    private void createPane(COSDictionary dictionary, COSName flagType) {
        Flag flag;
        if (flagType.equals((Object)COSName.FLAGS)) {
            flag = new FontFlag(dictionary);
            this.view = new FlagBitsPaneView(flag.getFlagType(), flag.getFlagValue(), flag.getFlagBits(), flag.getColumnNames());
        }
        if (flagType.equals((Object)COSName.F)) {
            flag = new AnnotFlag(dictionary);
            this.view = new FlagBitsPaneView(flag.getFlagType(), flag.getFlagValue(), flag.getFlagBits(), flag.getColumnNames());
        }
        if (flagType.equals((Object)COSName.FF)) {
            flag = new FieldFlag(dictionary);
            this.view = new FlagBitsPaneView(flag.getFlagType(), flag.getFlagValue(), flag.getFlagBits(), flag.getColumnNames());
        }
        if (flagType.equals((Object)COSName.PANOSE)) {
            flag = new PanoseFlag(dictionary);
            this.view = new FlagBitsPaneView(flag.getFlagType(), flag.getFlagValue(), flag.getFlagBits(), flag.getColumnNames());
        }
    }

    public JPanel getPane() {
        return this.view.getPanel();
    }
}

