/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools.pdfdebugger.treestatus;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreePath;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.tools.gui.ArrayEntry;
import org.apache.pdfbox.tools.gui.MapEntry;
import org.apache.pdfbox.tools.gui.PageEntry;

public final class TreeStatus {
    private Object rootNode;

    private TreeStatus() {
    }

    public TreeStatus(Object rootNode) {
        this.rootNode = rootNode;
    }

    public String getStringForPath(TreePath path) {
        return this.generatePathString(path);
    }

    public TreePath getPathForString(String statusString) {
        return this.generatePath(statusString);
    }

    private String generatePathString(TreePath path) {
        StringBuilder pathStringBuilder = new StringBuilder();
        while (path.getParentPath() != null) {
            Object object = path.getLastPathComponent();
            pathStringBuilder.insert(0, "/" + this.getObjectName(object));
            path = path.getParentPath();
        }
        pathStringBuilder.delete(0, 1);
        return pathStringBuilder.toString();
    }

    private TreePath generatePath(String pathString) {
        List<String> nodes = this.parsePathString(pathString);
        if (nodes == null) {
            return null;
        }
        Object obj = this.rootNode;
        TreePath treePath = new TreePath(obj);
        for (String node : nodes) {
            if ((obj = this.searchNode(obj, node)) == null) {
                return null;
            }
            treePath = treePath.pathByAddingChild(obj);
        }
        return treePath;
    }

    private String getObjectName(Object treeNode) {
        if (treeNode instanceof MapEntry) {
            MapEntry entry = (MapEntry)treeNode;
            COSName key = entry.getKey();
            return key.getName();
        }
        if (treeNode instanceof ArrayEntry) {
            ArrayEntry entry = (ArrayEntry)treeNode;
            return "[" + entry.getIndex() + "]";
        }
        if (treeNode instanceof PageEntry) {
            PageEntry entry = (PageEntry)treeNode;
            return entry.getPath();
        }
        throw new IllegalArgumentException("Unknown treeNode type: " + treeNode.getClass().getName());
    }

    private List<String> parsePathString(String path) {
        ArrayList<String> nodes = new ArrayList<String>();
        for (String node : path.split("/")) {
            if ((node = node.trim()).startsWith("[")) {
                node = node.replace("]", "").replace("[", "");
            }
            if ((node = node.trim()).isEmpty()) {
                return null;
            }
            nodes.add(node);
        }
        return nodes;
    }

    private Object searchNode(Object obj, String searchStr) {
        COSArray array;
        int index;
        if (obj instanceof MapEntry) {
            obj = ((MapEntry)obj).getValue();
        } else if (obj instanceof ArrayEntry) {
            obj = ((ArrayEntry)obj).getValue();
        }
        if (obj instanceof COSObject) {
            obj = ((COSObject)obj).getObject();
        }
        if (obj instanceof COSDictionary) {
            COSDictionary dic = (COSDictionary)obj;
            if (dic.containsKey(searchStr)) {
                MapEntry entry = new MapEntry();
                entry.setKey(COSName.getPDFName((String)searchStr));
                entry.setValue(dic.getDictionaryObject(searchStr));
                entry.setValue(dic.getItem(searchStr));
                return entry;
            }
        } else if (obj instanceof COSArray && (index = Integer.parseInt(searchStr)) <= (array = (COSArray)obj).size() - 1) {
            ArrayEntry entry = new ArrayEntry();
            entry.setIndex(index);
            entry.setValue(array.getObject(index));
            entry.setItem(array.get(index));
            return entry;
        }
        return null;
    }
}

