/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.encryption;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.DecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.MessageDigests;
import org.apache.pdfbox.pdmodel.encryption.PDEncryption;
import org.apache.pdfbox.pdmodel.encryption.PublicKeyDecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.PublicKeyProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.PublicKeyRecipient;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandler;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.KeyTransRecipientId;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class PublicKeySecurityHandler
extends SecurityHandler {
    public static final String FILTER = "Adobe.PubSec";
    private static final String SUBFILTER = "adbe.pkcs7.s4";
    private PublicKeyProtectionPolicy policy = null;

    public PublicKeySecurityHandler() {
    }

    public PublicKeySecurityHandler(PublicKeyProtectionPolicy p) {
        this.policy = p;
        this.keyLength = this.policy.getEncryptionKeyLength();
    }

    @Override
    public void prepareForDecryption(PDEncryption encryption, COSArray documentIDArray, DecryptionMaterial decryptionMaterial) throws IOException {
        if (!(decryptionMaterial instanceof PublicKeyDecryptionMaterial)) {
            throw new IOException("Provided decryption material is not compatible with the document");
        }
        this.setDecryptMetadata(encryption.isEncryptMetaData());
        if (encryption.getLength() != 0) {
            this.keyLength = encryption.getLength();
        }
        PublicKeyDecryptionMaterial material = (PublicKeyDecryptionMaterial)decryptionMaterial;
        try {
            int i;
            boolean foundRecipient = false;
            byte[] envelopedData = null;
            byte[][] recipientFieldsBytes = new byte[encryption.getRecipientsLength()][];
            int recipientFieldsLength = 0;
            StringBuilder extraInfo = new StringBuilder();
            for (i = 0; i < encryption.getRecipientsLength(); ++i) {
                COSString recipientFieldString = encryption.getRecipientStringAt(i);
                byte[] recipientBytes = recipientFieldString.getBytes();
                CMSEnvelopedData data = new CMSEnvelopedData(recipientBytes);
                Iterator recipCertificatesIt = data.getRecipientInfos().getRecipients().iterator();
                int j = 0;
                while (recipCertificatesIt.hasNext()) {
                    RecipientId rid;
                    RecipientInformation ri = (RecipientInformation)recipCertificatesIt.next();
                    X509Certificate certificate = material.getCertificate();
                    X509CertificateHolder materialCert = null;
                    if (null != certificate) {
                        materialCert = new X509CertificateHolder(certificate.getEncoded());
                    }
                    if ((rid = ri.getRID()).match(materialCert) && !foundRecipient) {
                        foundRecipient = true;
                        PrivateKey privateKey = (PrivateKey)material.getPrivateKey();
                        envelopedData = ri.getContent(new JceKeyTransEnvelopedRecipient(privateKey).setProvider("BC"));
                        break;
                    }
                    ++j;
                    if (certificate == null) continue;
                    extraInfo.append('\n');
                    extraInfo.append(j);
                    extraInfo.append(": ");
                    if (!(rid instanceof KeyTransRecipientId)) continue;
                    this.appendCertInfo(extraInfo, (KeyTransRecipientId)rid, certificate, materialCert);
                }
                recipientFieldsBytes[i] = recipientBytes;
                recipientFieldsLength += recipientBytes.length;
            }
            if (!foundRecipient || envelopedData == null) {
                throw new IOException("The certificate matches none of " + i + " recipient entries" + extraInfo.toString());
            }
            if (envelopedData.length != 24) {
                throw new IOException("The enveloped data does not contain 24 bytes");
            }
            byte[] accessBytes = new byte[4];
            System.arraycopy(envelopedData, 20, accessBytes, 0, 4);
            AccessPermission currentAccessPermission = new AccessPermission(accessBytes);
            currentAccessPermission.setReadOnly();
            this.setCurrentAccessPermission(currentAccessPermission);
            byte[] sha1Input = new byte[recipientFieldsLength + 20];
            System.arraycopy(envelopedData, 0, sha1Input, 0, 20);
            int sha1InputOffset = 20;
            for (byte[] recipientFieldsByte : recipientFieldsBytes) {
                System.arraycopy(recipientFieldsByte, 0, sha1Input, sha1InputOffset, recipientFieldsByte.length);
                sha1InputOffset += recipientFieldsByte.length;
            }
            MessageDigest md = MessageDigests.getSHA1();
            byte[] mdResult = md.digest(sha1Input);
            this.encryptionKey = new byte[this.keyLength / 8];
            System.arraycopy(mdResult, 0, this.encryptionKey, 0, this.keyLength / 8);
        }
        catch (CMSException e) {
            throw new IOException(e);
        }
        catch (KeyStoreException e) {
            throw new IOException(e);
        }
        catch (CertificateEncodingException e) {
            throw new IOException(e);
        }
    }

    private void appendCertInfo(StringBuilder extraInfo, KeyTransRecipientId ktRid, X509Certificate certificate, X509CertificateHolder materialCert) {
        BigInteger ridSerialNumber = ktRid.getSerialNumber();
        if (ridSerialNumber != null) {
            String certSerial = "unknown";
            BigInteger certSerialNumber = certificate.getSerialNumber();
            if (certSerialNumber != null) {
                certSerial = certSerialNumber.toString(16);
            }
            extraInfo.append("serial-#: rid ");
            extraInfo.append(ridSerialNumber.toString(16));
            extraInfo.append(" vs. cert ");
            extraInfo.append(certSerial);
            extraInfo.append(" issuer: rid '");
            extraInfo.append(ktRid.getIssuer());
            extraInfo.append("' vs. cert '");
            extraInfo.append(materialCert == null ? "null" : materialCert.getIssuer());
            extraInfo.append("' ");
        }
    }

    @Override
    public void prepareDocumentForEncryption(PDDocument doc) throws IOException {
        if (this.keyLength == 256) {
            throw new IOException("256 bit key length is not supported yet for public key security");
        }
        try {
            KeyGenerator key;
            Security.addProvider(new BouncyCastleProvider());
            PDEncryption dictionary = doc.getEncryption();
            if (dictionary == null) {
                dictionary = new PDEncryption();
            }
            dictionary.setFilter(FILTER);
            dictionary.setLength(this.keyLength);
            dictionary.setVersion(2);
            dictionary.removeV45filters();
            dictionary.setSubFilter(SUBFILTER);
            byte[] seed = new byte[20];
            try {
                key = KeyGenerator.getInstance("AES");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            key.init(192, new SecureRandom());
            SecretKey sk = key.generateKey();
            System.arraycopy(sk.getEncoded(), 0, seed, 0, 20);
            byte[][] recipientsField = this.computeRecipientsField(seed);
            dictionary.setRecipients(recipientsField);
            int sha1InputLength = seed.length;
            for (int j = 0; j < dictionary.getRecipientsLength(); ++j) {
                COSString string = dictionary.getRecipientStringAt(j);
                sha1InputLength += string.getBytes().length;
            }
            byte[] sha1Input = new byte[sha1InputLength];
            System.arraycopy(seed, 0, sha1Input, 0, 20);
            int sha1InputOffset = 20;
            for (int j = 0; j < dictionary.getRecipientsLength(); ++j) {
                COSString string = dictionary.getRecipientStringAt(j);
                System.arraycopy(string.getBytes(), 0, sha1Input, sha1InputOffset, string.getBytes().length);
                sha1InputOffset += string.getBytes().length;
            }
            MessageDigest sha1 = MessageDigests.getSHA1();
            byte[] mdResult = sha1.digest(sha1Input);
            this.encryptionKey = new byte[this.keyLength / 8];
            System.arraycopy(mdResult, 0, this.encryptionKey, 0, this.keyLength / 8);
            doc.setEncryptionDictionary(dictionary);
            doc.getDocument().setEncryptionDictionary(dictionary.getCOSDictionary());
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    private byte[][] computeRecipientsField(byte[] seed) throws GeneralSecurityException, IOException {
        byte[][] recipientsField = new byte[this.policy.getNumberOfRecipients()][];
        Iterator<PublicKeyRecipient> it = this.policy.getRecipientsIterator();
        int i = 0;
        while (it.hasNext()) {
            PublicKeyRecipient recipient = it.next();
            X509Certificate certificate = recipient.getX509();
            int permission = recipient.getPermission().getPermissionBytesForPublicKey();
            byte[] pkcs7input = new byte[24];
            byte one = (byte)permission;
            byte two = (byte)(permission >>> 8);
            byte three = (byte)(permission >>> 16);
            byte four = (byte)(permission >>> 24);
            System.arraycopy(seed, 0, pkcs7input, 0, 20);
            pkcs7input[20] = four;
            pkcs7input[21] = three;
            pkcs7input[22] = two;
            pkcs7input[23] = one;
            ASN1Primitive obj = this.createDERForRecipient(pkcs7input, certificate);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DEROutputStream k = new DEROutputStream(baos);
            k.writeObject(obj);
            recipientsField[i] = baos.toByteArray();
            ++i;
        }
        return recipientsField;
    }

    private ASN1Primitive createDERForRecipient(byte[] in, X509Certificate cert) throws IOException, GeneralSecurityException {
        Cipher cipher;
        KeyGenerator keygen;
        AlgorithmParameterGenerator apg;
        String algorithm = "1.2.840.113549.3.2";
        try {
            apg = AlgorithmParameterGenerator.getInstance(algorithm);
            keygen = KeyGenerator.getInstance(algorithm);
            cipher = Cipher.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not find a suitable javax.crypto provider", e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException("Could not find a suitable javax.crypto provider", e);
        }
        AlgorithmParameters parameters = apg.generateParameters();
        ASN1InputStream input = new ASN1InputStream(parameters.getEncoded("ASN.1"));
        ASN1Primitive object = input.readObject();
        input.close();
        keygen.init(128);
        SecretKey secretkey = keygen.generateKey();
        cipher.init(1, (Key)secretkey, parameters);
        byte[] bytes = cipher.doFinal(in);
        KeyTransRecipientInfo recipientInfo = this.computeRecipientInfo(cert, secretkey.getEncoded());
        DERSet set = new DERSet(new RecipientInfo(recipientInfo));
        AlgorithmIdentifier algorithmId = new AlgorithmIdentifier(new ASN1ObjectIdentifier(algorithm), object);
        EncryptedContentInfo encryptedInfo = new EncryptedContentInfo(PKCSObjectIdentifiers.data, algorithmId, new DEROctetString(bytes));
        EnvelopedData enveloped = new EnvelopedData(null, (ASN1Set)set, encryptedInfo, (ASN1Set)null);
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.envelopedData, enveloped);
        return contentInfo.toASN1Primitive();
    }

    private KeyTransRecipientInfo computeRecipientInfo(X509Certificate x509certificate, byte[] abyte0) throws IOException, CertificateEncodingException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Cipher cipher;
        ASN1InputStream input = new ASN1InputStream(x509certificate.getTBSCertificate());
        TBSCertificateStructure certificate = TBSCertificateStructure.getInstance(input.readObject());
        input.close();
        AlgorithmIdentifier algorithmId = certificate.getSubjectPublicKeyInfo().getAlgorithm();
        IssuerAndSerialNumber serial = new IssuerAndSerialNumber(certificate.getIssuer(), certificate.getSerialNumber().getValue());
        try {
            cipher = Cipher.getInstance(algorithmId.getAlgorithm().getId());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not find a suitable javax.crypto provider", e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException("Could not find a suitable javax.crypto provider", e);
        }
        cipher.init(1, x509certificate.getPublicKey());
        DEROctetString octets = new DEROctetString(cipher.doFinal(abyte0));
        RecipientIdentifier recipientId = new RecipientIdentifier(serial);
        return new KeyTransRecipientInfo(recipientId, algorithmId, octets);
    }

    @Override
    public boolean hasProtectionPolicy() {
        return this.policy != null;
    }
}

